/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgTypeRecord;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaDefaultTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaPropertiesPanel;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaReservedWord;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.AltaColorComboBox;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeDlgChooser;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AltaTypeFrame
extends DBInternalFrame
implements PlugModel,
Preferencies.PreferenciesListener {
    private static Logger _LOG = Logger.getLogger(AltaTypeFrame.class.getPackage().getName());
    private CeciliaAppl _appl;
    private DBType _dbType;
    private JPanel _panel = new JPanel(new BorderLayout());
    private JLabel _typeNameLabel = new JLabel(ResMsgOcas.getString("TYPE_NAME"));
    private JTextField _typeName = new JTextField("");
    private JTabbedPane _tabPane = new JTabbedPane();
    private JPanel _fieldPanel = new JPanel();
    private TypeTable _typeTable;
    private AltaColorComboBox _colorCB;
    private JLabel _fieldNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    private JTextField _fieldName = new JTextField("");
    private JLabel _fieldTypeLabel = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
    private JComboBox _fieldTypeSelector = new JComboBox();
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlEdit;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    private JButton _allocateFieldTypeButton = new JButton(ResMsgVoc.getString("VOC_AFFECT"));
    private JToolBar _fieldButtonPanel = new JToolBar();
    private JPanel _typeFieldPanel = new JPanel();
    private AltaPropertiesPanel _propertiesPanel;
    private JPopupMenu _popupMenu = new JPopupMenu();
    private JPanel _emptyPanel = new JPanel();
    private JTextField _valueEnumTypeField = new JTextField("");
    private JPanel _predefinePanel = new JPanel();
    private JTextField _predefineType = new JTextField("");
    private JButton _selectPredefineType = new JButton("...");
    private static TypeDlgChooser _typeChooser = null;
    private static Object _LockerDlgChooser = new Object();
    private JPanel _intervalPanel = new JPanel();
    private JLabel _minLabel = new JLabel("Min");
    private JLabel _maxLabel = new JLabel("Max");
    private JTextField _minValue = new JTextField("");
    private JTextField _maxValue = new JTextField("");
    private JComboBox _listDirectionCombo = new JComboBox();
    private ItemListener _listDirectionListener;
    private FieldEditor _fieldNameEditor = new FieldEditor();
    private int _editingRow = -1;
    private CrossFieldEditor _crossFieldNameEditor = new CrossFieldEditor();
    private JTextField _lastFocusField = this._fieldName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_typeChooser == null) {
            TypeDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_typeChooser == null) {
                    dlg = new TypeDlgChooser(win, appl);
                    dlg.setOnlyEnum(true);
                }
                if (_typeChooser == null) {
                    _typeChooser = dlg;
                }
            }
        }
        return _typeChooser;
    }

    public AltaTypeFrame(DBType dbType, CeciliaAppl appl) {
        super(dbType.getDBFolder());
        this._appl = appl;
        this._dbType = dbType.getCopy();
        this.createActions();
        this.makePanel();
        this._typeName.setText(this.getDBFolder().getParent().getName());
        this._typeName.setEditable(false);
        this._lastFocusField = this._fieldName;
        this.setFrameIcon(DBFolderResources.getFrameIcon(dbType.getDBFolder()));
        this.setModified(false);
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._lastFocusField != null) {
            this._lastFocusField.requestFocus();
        }
    }

    @Override
    protected CeciliaAppl getApplication() {
        return this._appl;
    }

    @Override
    public DBType getDBWrap() {
        return this._dbType;
    }

    @Override
    public AltaTypeFrame getMasterFrame() {
        return this;
    }

    private void makePanel() {
        this._typeTable = new TypeTable();
        this.getContentPane().add(this._panel);
        this._panel.add((Component)this._tabPane, "Center");
        if (this._appl.isReader()) {
            this._panel.add(this.createAndPlugLogsButtonAt(this.createClosePanel()), "South");
        } else {
            this._panel.add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        }
        JPanel panel = new JPanel(new GridBagLayout());
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this._tabPane.addTab(ResMsgVoc.getString("VOC_GENERAL"), panel);
        this._propertiesPanel = new AltaPropertiesPanel(this._dbType.getDBFolder());
        this._propertiesPanel.setEditable(!this._appl.isReader());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_PROPERTIES"), this._propertiesPanel);
        panel.add((Component)this._typeNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._typeName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._fieldPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._fieldPanel.setLayout(new GridBagLayout());
        this._fieldPanel.setOpaque(false);
        JScrollPane scrollTable = new JScrollPane(this._typeTable);
        this._fieldPanel.add((Component)scrollTable, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 5, 5), 0, 0));
        if (!this._appl.isReader()) {
            this._fieldPanel.add((Component)this._fieldButtonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 2, 5), 0, 0));
            this._fieldPanel.add((Component)this._typeFieldPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 2, 5), 0, 0));
        }
        this._fieldButtonPanel.add(Box.createGlue());
        this._fieldButtonPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        this._fieldButtonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        this._fieldButtonPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        if (this._dbType instanceof DBRecord) {
            this._fieldButtonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            this._fieldButtonPanel.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        }
        this._fieldButtonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        this._fieldButtonPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        this._fieldButtonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        this._fieldButtonPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        this._fieldButtonPanel.add(Box.createGlue());
        this._fieldButtonPanel.setFloatable(false);
        this._typeFieldPanel.setLayout(new GridBagLayout());
        this._typeFieldPanel.setOpaque(false);
        this._typeFieldPanel.setBorder(BorderFactory.createEtchedBorder());
        this._typeFieldPanel.add((Component)this._fieldNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._typeFieldPanel.add((Component)this._fieldName, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this._dbType instanceof DBRecord) {
            this._typeFieldPanel.add((Component)this._fieldTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._fieldTypeSelector, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._valueEnumTypeField, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._predefinePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._intervalPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._emptyPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._emptyPanel.setOpaque(false);
            this._predefinePanel.setLayout(new GridBagLayout());
            this._predefinePanel.add((Component)this._predefineType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
            this._predefinePanel.add((Component)this._selectPredefineType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
            this._typeFieldPanel.add((Component)this._allocateFieldTypeButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this._dbType instanceof DBRecord) {
            this._intervalPanel.setLayout(new GridBagLayout());
            this._intervalPanel.setOpaque(false);
            this._intervalPanel.add((Component)this._minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this._intervalPanel.add((Component)this._minValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this._intervalPanel.add((Component)this._maxLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this._intervalPanel.add((Component)this._maxValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        this._typeNameLabel.setForeground(Color.black);
        this._fieldNameLabel.setForeground(Color.black);
        this._fieldTypeLabel.setForeground(Color.black);
        this._minLabel.setForeground(Color.black);
        this._maxLabel.setForeground(Color.black);
        this._fieldTypeSelector.addItem("bool");
        this._fieldTypeSelector.addItem("enum");
        this._fieldTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._fieldTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._fieldTypeSelector.addItem("int");
        this._fieldTypeSelector.addItem("float");
        this._valueEnumTypeField.setVisible(false);
        this._intervalPanel.setVisible(false);
        this._predefinePanel.setVisible(false);
        this._typeTable.setModel(new TypeTableModel(this._typeTable));
        this._typeTable.doLayout();
        this._typeTable.setSelectionMode(2);
        this._typeTable.getTableHeader().setReorderingAllowed(false);
        this._colorCB = new AltaColorComboBox(SwingUtilities.getWindowAncestor(this._typeTable));
        if (this._dbType instanceof DBRecord) {
            this._listDirectionCombo.addItem(DBRecordField.Direction.INVERSE);
            this._listDirectionCombo.addItem(DBRecordField.Direction.NORMAL);
            this._listDirectionCombo.setRenderer(new DBRecordField.Direction.SpecificListCellRenderer());
            this._typeTable.setRowHeight(20);
            if (!this._appl.isReader()) {
                TableColumnModel tableColumnModel = this._typeTable.getColumnModel();
                TableColumn valueColumn = tableColumnModel.getColumn(0);
                valueColumn.setCellEditor(new TypeTableCellEditor(this._listDirectionCombo));
                valueColumn = tableColumnModel.getColumn(2);
                valueColumn.setCellEditor(new TypeTableCellEditor(this._listDirectionCombo));
                valueColumn = tableColumnModel.getColumn(3);
                valueColumn.setCellEditor(new TypeTableCellEditor(this._listDirectionCombo));
                valueColumn = tableColumnModel.getColumn(4);
            }
            this._typeTable.getTableHeader().getColumnModel().getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer());
            this._typeTable.getTableHeader().getColumnModel().getColumn(1).setCellRenderer(new AltaDefaultTableCellRenderer());
            this._typeTable.getTableHeader().getColumnModel().getColumn(2).setCellRenderer(new DBRecordField.Direction.SpecificTableCellRenderer());
            this._typeTable.getTableHeader().getColumnModel().getColumn(3).setCellRenderer(new AltaDefaultTableCellRenderer());
        } else {
            TableColumnModel tableColumnModel = this._typeTable.getColumnModel();
            TableColumn valueColumn = tableColumnModel.getColumn(0);
            valueColumn.setCellEditor(new TypeTableCellEditor(this._listDirectionCombo));
            this._typeTable.getTableHeader().getColumnModel().getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer());
            if (!this._appl.isReader()) {
                TableColumn colorColumn = tableColumnModel.getColumn(1);
                colorColumn.setCellEditor(new DefaultCellEditor(this._colorCB));
            }
        }
        if (!this._appl.isReader()) {
            if (this._dbType instanceof DBRecord) {
                this._popupMenu.add(this._ctrlEdit);
                this._popupMenu.addSeparator();
            }
            this._popupMenu.add(this._ctrlDel);
            this._popupMenu.add(this._ctrlUp);
            this._popupMenu.add(this._ctrlDown);
            this._popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AltaTypeFrame.this.selectField();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            scrollTable.setComponentPopupMenu(this._popupMenu);
        }
        this.selectField();
        this.defineActions();
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                    AltaTypeFrame.this.addRecordField();
                } else {
                    AltaTypeFrame.this.addEnumField();
                }
            }
        }.setDesc(ResMsgOcas.getString("TYPE_EDIT_ADD_FIELD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaTypeFrame.this._dbType != null && (indexes = AltaTypeFrame.this._typeTable.getSelectedRows()).length > 0) {
                    for (int idx = indexes.length - 1; idx >= 0; --idx) {
                        if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                            DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).removeField(indexes[idx]);
                            ((DBRecord)AltaTypeFrame.this._dbType).removeCross(field.getName());
                            continue;
                        }
                        if (!(AltaTypeFrame.this._dbType instanceof DBEnum)) continue;
                        ((DBEnum)AltaTypeFrame.this._dbType).removeValue(indexes[idx]);
                    }
                    AltaTypeFrame.this._typeTable.clearSelection();
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                    AltaTypeFrame.this.setModified(true);
                }
            }
        }.setDesc(ResMsgOcas.getString("TYPE_EDIT_DEL_FIELD"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaTypeFrame.this._dbType == null) {
                    return;
                }
                if (AltaTypeFrame.this._dbType instanceof DBEnum) {
                    return;
                }
                if (AltaTypeFrame.this._typeTable.getSelectedRow() == -1) {
                    return;
                }
                DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(AltaTypeFrame.this._typeTable.getSelectedRow());
                AltaType type = field.getType();
                if (!(type instanceof DBType)) {
                    return;
                }
                if (((DBType)type).getDBFolder() == null) {
                    return;
                }
                DBFolderTreeActivable tree = AltaTypeFrame.this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
                if (tree != null) {
                    tree.edit(((DBType)type).getDBFolder(), false);
                }
            }
        }.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("CMD_MOVE_UP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaTypeFrame.this._dbType != null && (indexes = AltaTypeFrame.this._typeTable.getSelectedRows()).length > 0) {
                    boolean change = false;
                    AltaTypeFrame.this._typeTable.clearSelection();
                    for (int index : indexes) {
                        String value;
                        if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                            DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(index);
                            if (field != null) {
                                ((DBRecord)AltaTypeFrame.this._dbType).removeField(index);
                                ((DBRecord)AltaTypeFrame.this._dbType).addField(field, index - 1);
                                change = true;
                            }
                        } else if (AltaTypeFrame.this._dbType instanceof DBEnum && (value = AltaTypeFrame.this._dbType.getValueAt(index)) != null) {
                            Color currentColor = ((DBEnum)AltaTypeFrame.this._dbType).getColorEnumerate(value);
                            ((DBEnum)AltaTypeFrame.this._dbType).removeValue(index);
                            ((DBEnum)AltaTypeFrame.this._dbType).addValue(value, index - 1);
                            ((DBEnum)AltaTypeFrame.this._dbType).setColorToEnumerate(value, currentColor);
                            change = true;
                        }
                        AltaTypeFrame.this._typeTable.addRowSelectionInterval(index - 1, index - 1);
                    }
                    if (change) {
                        AltaTypeFrame.this.selectField();
                        AltaTypeFrame.this.setModified(true);
                    }
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("CMD_MOVE_DOWN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaTypeFrame.this._dbType != null && (indexes = AltaTypeFrame.this._typeTable.getSelectedRows()).length > 0) {
                    boolean change = false;
                    AltaTypeFrame.this._typeTable.clearSelection();
                    ArrayList<Integer> listDownElements = new ArrayList<Integer>();
                    for (int index = indexes.length - 1; index >= 0; --index) {
                        listDownElements.add(indexes[index]);
                    }
                    Iterator iterator = listDownElements.iterator();
                    while (iterator.hasNext()) {
                        String value;
                        int index = (Integer)iterator.next();
                        if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                            DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(index);
                            if (field != null) {
                                ((DBRecord)AltaTypeFrame.this._dbType).removeField(index);
                                ((DBRecord)AltaTypeFrame.this._dbType).addField(field, index + 1);
                                change = true;
                            }
                        } else if (AltaTypeFrame.this._dbType instanceof DBEnum && (value = AltaTypeFrame.this._dbType.getValueAt(index)) != null) {
                            Color currentColor = ((DBEnum)AltaTypeFrame.this._dbType).getColorEnumerate(value);
                            ((DBEnum)AltaTypeFrame.this._dbType).removeValue(index);
                            ((DBEnum)AltaTypeFrame.this._dbType).addValue(value, index + 1);
                            ((DBEnum)AltaTypeFrame.this._dbType).setColorToEnumerate(value, currentColor);
                            change = true;
                        }
                        AltaTypeFrame.this._typeTable.addRowSelectionInterval(index + 1, index + 1);
                    }
                    if (change) {
                        AltaTypeFrame.this.selectField();
                        AltaTypeFrame.this.setModified(true);
                    }
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_DOWN"));
    }

    private void defineActions() {
        this._listDirectionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int index;
                if (AltaTypeFrame.this._dbType != null && (index = AltaTypeFrame.this._typeTable.getSelectedRow()) != -1) {
                    DBRecordField oldField = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(index);
                    if (AltaTypeFrame.this._listDirectionCombo.getSelectedItem() != null) {
                        oldField.setDirection((DBRecordField.Direction)((Object)AltaTypeFrame.this._listDirectionCombo.getSelectedItem()));
                    }
                    AltaTypeFrame.this._listDirectionCombo.removeItemListener(AltaTypeFrame.this._listDirectionListener);
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                    AltaTypeFrame.this.setModified(true);
                }
            }
        };
        this._fieldTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (AltaTypeFrame.this._fieldTypeSelector.getSelectedIndex()) {
                    case 0: 
                    case 4: 
                    case 5: {
                        AltaTypeFrame.this._emptyPanel.setVisible(true);
                        AltaTypeFrame.this._valueEnumTypeField.setVisible(false);
                        AltaTypeFrame.this._intervalPanel.setVisible(false);
                        AltaTypeFrame.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 1: {
                        AltaTypeFrame.this._emptyPanel.setVisible(false);
                        AltaTypeFrame.this._valueEnumTypeField.setVisible(true);
                        AltaTypeFrame.this._intervalPanel.setVisible(false);
                        AltaTypeFrame.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 2: {
                        AltaTypeFrame.this._emptyPanel.setVisible(false);
                        AltaTypeFrame.this._valueEnumTypeField.setVisible(false);
                        AltaTypeFrame.this._intervalPanel.setVisible(true);
                        AltaTypeFrame.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 3: {
                        AltaTypeFrame.this._emptyPanel.setVisible(false);
                        AltaTypeFrame.this._valueEnumTypeField.setVisible(false);
                        AltaTypeFrame.this._intervalPanel.setVisible(false);
                        AltaTypeFrame.this._predefinePanel.setVisible(true);
                    }
                }
            }
        });
        this._allocateFieldTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (AltaTypeFrame.this._dbType != null && (index = AltaTypeFrame.this._typeTable.getSelectedRow()) != -1) {
                    DBRecordField oldField = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(index);
                    switch (AltaTypeFrame.this._fieldTypeSelector.getSelectedIndex()) {
                        case 0: {
                            oldField.setType(AltaTypeBool.getInstance());
                            if (!(AltaTypeFrame.this._dbType instanceof DBRecord)) break;
                            oldField.setCrossField("");
                            ((DBRecord)AltaTypeFrame.this._dbType).removeCross(oldField.getName());
                            break;
                        }
                        case 1: {
                            if (!AltaTypeFrame.this._valueEnumTypeField.getText().equals("")) {
                                if (AltaTypeFrame.this._valueEnumTypeField.getText().indexOf(" ") == -1) {
                                    String convertEnumType = AltaTypeEnum.convertInEnumType(AltaTypeFrame.this._valueEnumTypeField.getText());
                                    if (convertEnumType != null) {
                                        oldField.setType(new AltaTypeEnum("{" + convertEnumType + "}"));
                                        if (!(AltaTypeFrame.this._dbType instanceof DBRecord)) break;
                                        oldField.setCrossField("");
                                        ((DBRecord)AltaTypeFrame.this._dbType).removeCross(oldField.getName());
                                        break;
                                    }
                                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("TYPE_SPECIFY_ERROR"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                    break;
                                }
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            break;
                        }
                        case 2: {
                            try {
                                int minValue = Integer.parseInt(AltaTypeFrame.this._minValue.getText());
                                try {
                                    int maxValue = Integer.parseInt(AltaTypeFrame.this._maxValue.getText());
                                    if (minValue >= 0) {
                                        if (maxValue >= 0) {
                                            if (maxValue > minValue) {
                                                oldField.setType(new AltaTypeBound(minValue, maxValue));
                                                if (!(AltaTypeFrame.this._dbType instanceof DBRecord)) break;
                                                oldField.setCrossField("");
                                                ((DBRecord)AltaTypeFrame.this._dbType).removeCross(oldField.getName());
                                                break;
                                            }
                                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                            break;
                                        }
                                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                        break;
                                    }
                                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                }
                                catch (NumberFormatException e1) {
                                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                }
                            }
                            catch (NumberFormatException e2) {
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            }
                            break;
                        }
                        case 3: {
                            AltaType defaultType = AltaTypeParser.getType(AltaTypeFrame.this._predefineType.getText(), AltaTypeFrame.this._appl.getDAOFactory());
                            if (defaultType != null) {
                                if (!(defaultType instanceof DBEnum)) break;
                                oldField.setType(defaultType);
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._allocateFieldTypeButton), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            break;
                        }
                        case 4: {
                            oldField.setType(AltaTypeInt.getInstance());
                            if (!(AltaTypeFrame.this._dbType instanceof DBRecord)) break;
                            oldField.setCrossField("");
                            ((DBRecord)AltaTypeFrame.this._dbType).removeCross(oldField.getName());
                            break;
                        }
                        case 5: {
                            oldField.setType(AltaTypeFloat.getInstance());
                            if (!(AltaTypeFrame.this._dbType instanceof DBRecord)) break;
                            oldField.setCrossField("");
                            ((DBRecord)AltaTypeFrame.this._dbType).removeCross(oldField.getName());
                        }
                    }
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                    AltaTypeFrame.this.setModified(true);
                }
            }
        });
        this._typeTable.getActionMap().put("DELETE", this._ctrlDel);
        this._typeTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._typeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AltaTypeFrame.this._dbType != null && AltaTypeFrame.this._dbType instanceof DBRecord) {
                    int index = AltaTypeFrame.this._typeTable.getSelectedRow();
                    if (index != -1) {
                        DBRecordField oldField = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(index);
                        AltaTypeFrame.this._fieldName.setText(oldField.getName());
                        if (oldField.getType() instanceof AltaTypeBool) {
                            AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(0);
                        } else if (oldField.getType() instanceof AltaTypeBound) {
                            AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(2);
                            AltaTypeFrame.this._minValue.setText(Integer.toString(((AltaTypeBound)oldField.getType()).getMin()));
                            AltaTypeFrame.this._maxValue.setText(Integer.toString(((AltaTypeBound)oldField.getType()).getMax()));
                        } else if (oldField.getType() instanceof AltaTypeEnum) {
                            AltaType oldType = oldField.getType();
                            String enumeration = oldField.getType().getValue();
                            if (oldType instanceof DBType && ((DBType)oldType).getDBFolder() != null) {
                                AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(3);
                                AltaTypeFrame.this._predefineType.setText(((DBType)oldType).getDBFolder().getRefPath());
                            } else {
                                AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(1);
                                if (enumeration.indexOf("{") != -1) {
                                    enumeration = enumeration.substring(1, enumeration.length() - 1);
                                }
                                AltaTypeFrame.this._valueEnumTypeField.setText(enumeration);
                            }
                        } else if (oldField.getType() instanceof AltaTypeInt) {
                            AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(4);
                        } else if (oldField.getType() instanceof AltaTypeFloat) {
                            AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(5);
                        }
                    } else {
                        AltaTypeFrame.this._fieldName.setText("");
                        AltaTypeFrame.this._fieldTypeSelector.setSelectedIndex(0);
                    }
                }
            }
        });
        this._fieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                    AltaTypeFrame.this.addRecordField();
                } else {
                    AltaTypeFrame.this.addEnumField();
                }
                AltaTypeFrame.this._lastFocusField.requestFocus();
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaTypeFrame.this._lastFocusField = (JTextField)e.getSource();
            }
        };
        this._typeName.addFocusListener(focusListener);
        this._fieldName.addFocusListener(focusListener);
        this._selectPredefineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDlgChooser dlg = AltaTypeFrame.getDlgChooser(SwingUtilities.getWindowAncestor(AltaTypeFrame.this._selectPredefineType), AltaTypeFrame.this._appl);
                DAOFolder daoFolder = AltaTypeFrame.this._appl.getDAOFactory().createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("TYPE_FAMILIES", AltaTypeFrame.this._predefineType.getText());
                if (dbFolder != null) {
                    dlg.setSelectFolder(dbFolder);
                }
                dlg.setVisible(true);
                if (dlg.getResult() && (dbFolder = dlg.getSelectFolder()) != null) {
                    AltaTypeFrame.this._predefineType.setText(dbFolder.getRefPath());
                }
            }
        });
    }

    private boolean verifyFieldName() {
        String character = "";
        String field = this._fieldName.getText();
        if (field.equals("")) {
            this._fieldName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._fieldName), ResMsgOcas.getString("KEY_0340"), ResMsgVoc.getString("VOC_ERROR"), 0);
        } else {
            character = UtilOcas.controlName(field);
            if (character != null) {
                this._fieldName.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._fieldName), ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", character), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else if (this.isReservedWord(field)) {
                this._fieldName.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._fieldName), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", field), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else if (this._dbType.valueExist(field)) {
                this._fieldName.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._fieldName), ResMsgOcas.getString("TYPE_EDIT_FIELD_ALREADY_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean addEnumField() {
        if (this._dbType == null) {
            return false;
        }
        if (!this.verifyFieldName()) {
            return false;
        }
        String field = this._fieldName.getText();
        int index = this._typeTable.getSelectedRow();
        if (index != -1) {
            ((DBEnum)this._dbType).addValue(field, index + 1);
            this._typeTable.setRowSelectionInterval(index + 1, index + 1);
        } else {
            index = this._dbType.getValueCount();
            ((DBEnum)this._dbType).addValue(field, index);
            this._typeTable.setRowSelectionInterval(index, index);
        }
        ((TypeTableModel)this._typeTable.getModel()).refresh(false);
        this.setModified(true);
        return true;
    }

    public boolean addRecordField() {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && ((DBRecord)this._dbType).getFields().size() >= DemoLimits.Limit.LINK_FIELDS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._typeTable), ResMsgOcas.getString("DEMO_LINK_FIELDS"), JOptionCecilia.getTopTitleOf(this._typeTable), 0);
            return false;
        }
        if (this._dbType == null) {
            return false;
        }
        if (!this.verifyFieldName()) {
            return false;
        }
        DBRecordField newField = null;
        switch (this._fieldTypeSelector.getSelectedIndex()) {
            case 0: {
                newField = new DBRecordField(this._fieldName.getText(), AltaTypeBool.getInstance());
                break;
            }
            case 1: {
                if (!this._valueEnumTypeField.getText().equals("")) {
                    if (this._valueEnumTypeField.getText().indexOf(" ") == -1) {
                        String convertEnumType = AltaTypeEnum.convertInEnumType(this._valueEnumTypeField.getText());
                        if (convertEnumType != null) {
                            newField = new DBRecordField(this._fieldName.getText(), new AltaTypeEnum("{" + convertEnumType + "}"));
                            break;
                        }
                        this._valueEnumTypeField.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeField), ResMsgOcas.getString("TYPE_SPECIFY_ERROR"), ResMsgVoc.getString("VOC_ERROR"), 0);
                        break;
                    }
                    this._valueEnumTypeField.requestFocus();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeField), ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                this._valueEnumTypeField.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._valueEnumTypeField), ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"), ResMsgVoc.getString("VOC_ERROR"), 0);
                break;
            }
            case 2: {
                try {
                    int minValue = Integer.parseInt(this._minValue.getText());
                    try {
                        int maxValue = Integer.parseInt(this._maxValue.getText());
                        if (minValue >= 0) {
                            if (maxValue >= 0) {
                                if (maxValue > minValue) {
                                    newField = new DBRecordField(this._fieldName.getText(), new AltaTypeBound(minValue, maxValue));
                                    break;
                                }
                                this._maxValue.requestFocus();
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._maxValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_2"), ResMsgVoc.getString("VOC_ERROR"), 0);
                                break;
                            }
                            this._maxValue.requestFocus();
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._maxValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            break;
                        }
                        this._minValue.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._minValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                    catch (NumberFormatException e1) {
                        this._maxValue.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._maxValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                }
                catch (NumberFormatException e2) {
                    this._minValue.requestFocus();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._minValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                }
                break;
            }
            case 3: {
                AltaType defaultType = AltaTypeParser.getType(this._predefineType.getText(), this._appl.getDAOFactory());
                if (defaultType != null) {
                    newField = new DBRecordField(this._fieldName.getText(), defaultType);
                    break;
                }
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._predefineType), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                break;
            }
            case 4: {
                newField = new DBRecordField(this._fieldName.getText(), AltaTypeInt.getInstance());
                break;
            }
            case 5: {
                newField = new DBRecordField(this._fieldName.getText(), AltaTypeFloat.getInstance());
            }
        }
        if (newField != null) {
            newField.setID(((DBRecord)this._dbType).getNextFieldID());
            int index = this._typeTable.getSelectedRow();
            if (index != -1) {
                ((DBRecord)this._dbType).addField(newField, index + 1);
                this._typeTable.setRowSelectionInterval(index + 1, index + 1);
            } else {
                index = this._dbType.getValueCount();
                ((DBRecord)this._dbType).addField(newField, index);
                this._typeTable.setRowSelectionInterval(index, index);
            }
            ((TypeTableModel)this._typeTable.getModel()).refresh(false);
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_TYPE");
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this._appl, this._ctrlClose).realiseDo();
        return true;
    }

    @Override
    public boolean verifyData() {
        if (this._typeTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_ATLEAST_ONE_FIELD"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        String comment = this._propertiesPanel.getComment();
        if (!DBFactory.verifyDescription(comment)) {
            this._tabPane.setSelectedIndex(1);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._propertiesPanel), ResMsgObj.msgFormat("MSG_ERR_DESCRIPTION_FRM", (short)1023), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return super.verifyData();
    }

    @Override
    protected String getDescription() {
        return this._propertiesPanel.getComment();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        if (!this.doSave()) {
            return false;
        }
        this._propertiesPanel.updateDBFolder(this.getDBFolder());
        return true;
    }

    public void saveAsType() {
    }

    public boolean isReservedWord(String word) {
        return AltaReservedWord.isReservedWord(word);
    }

    protected Pageable createPageable(final PageFormat format, final Preferencies pref) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Pageable doCreatePageable() {
                ExpBook book = new ExpBook(AltaTypeFrame.this.getApplication().getDAOFactory());
                book.setPreferencies(pref);
                DBType type = AltaTypeFrame.this.getDBWrap();
                XPortConfig<DBEnum> exportCfg = type instanceof DBEnum ? new XPortCfgTypeEnum() : new XPortCfgTypeRecord();
                exportCfg.configBook(book, (DBEnum)type);
                ListProcessorJavaInteractive printable = null;
                try (SrbInputStream scribe = new SrbInputStream("");){
                    book.writeScribe(scribe);
                }
                printable = new ListProcessorJavaInteractive(scribe);
                printable.processScribeFile();
                printable.computePageCount(format);
                return printable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    @Override
    public boolean preview() {
        Pageable fgPageable = this.createPageable(this.getApplication().getPageFormat(), this.getApplication().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf(this), fgPageable, this.getApplication(), new PrefFieldsCategory[0]){

            @Override
            public void updatePreferencies() {
                this.setBook(AltaTypeFrame.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        return true;
    }

    @Override
    public boolean print() {
        Pageable fgPageable = this.createPageable(this.getApplication().getPageFormat(), this.getApplication().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(fgPageable);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public void toDoWhenBeOpened() {
        super.toDoWhenBeOpened();
        this._appl.getPreferencies().addPreferenciesListener(this);
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this._appl.getTopWindow().setEnabledAction("PRINT", true);
        this._appl.getTopWindow().setEnabledAction("PRINT_PREVIEW", true);
        this.requestFocus();
        this._lastFocusField.requestFocus();
    }

    @Override
    public void toDoWhenDeActivated() {
        this._appl.getTopWindow().setEnabledAction("PRINT", false);
        this._appl.getTopWindow().setEnabledAction("PRINT_PREVIEW", false);
        super.toDoWhenDeActivated();
    }

    @Override
    public void toDoWhenBeClosed() {
        this._appl.getPreferencies().removePreferenciesListener(this);
        this._typeTable.getInputMap(0).remove(KeyStroke.getKeyStroke("DELETE"));
        super.toDoWhenBeClosed();
    }

    @Override
    protected boolean withUpdateEdit() {
        return this._dbType instanceof DBRecord;
    }

    @Override
    protected void updateEdit() {
        if (!(this._dbType instanceof DBRecord)) {
            return;
        }
        DBRecord dbRecord = (DBRecord)this._dbType;
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), dbRecord.getLogs());
        if (!dbRecord.update(this.getApplication().getDAOFactory(), logMng)) {
            ((TypeTableModel)this._typeTable.getModel()).refresh(false);
        }
        this.updateLogs(dbRecord.getUseRelations(), oldLevel, oldNbr);
    }

    @Override
    public boolean isModified() {
        if (this._propertiesPanel.isModified()) {
            return true;
        }
        return super.isModified();
    }

    @Override
    public void setModified(boolean value) {
        this._propertiesPanel.setModified(value);
        super.setModified(value);
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            this._propertiesPanel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
    }

    @Override
    public String toString() {
        return ResMsgVoc.getString("VOC_TYPE") + " : " + this.getTitle();
    }

    public void selectField() {
        if (this._typeTable.getSelectedRowCount() == 1) {
            int index = this._typeTable.getSelectedRow();
            this._ctrlUp.setEnabled(index != 0);
            this._ctrlDown.setEnabled(index != this._typeTable.getRowCount() - 1);
            this._ctrlDel.setEnabled(!this._appl.isReader());
            this._allocateFieldTypeButton.setEnabled(!this._appl.isReader());
            boolean isPredefineType = false;
            if (this._dbType != null && this._dbType instanceof DBRecord) {
                DBRecordField field = ((DBRecord)this._dbType).getFieldAt(index);
                if (field != null) {
                    this._fieldName.setText(field.getName());
                    AltaType currentType = field.getType();
                    if (currentType != null) {
                        if (currentType instanceof AltaTypeBool) {
                            this._fieldTypeSelector.setSelectedIndex(0);
                        } else if (currentType instanceof AltaTypeEnum) {
                            String enumeration = currentType.getValue();
                            this._fieldTypeSelector.setSelectedIndex(1);
                            if (enumeration.indexOf("{") != -1) {
                                enumeration = enumeration.substring(1, enumeration.length() - 1);
                            }
                            this._valueEnumTypeField.setText(enumeration);
                        } else if (currentType instanceof AltaTypeBound) {
                            this._fieldTypeSelector.setSelectedIndex(2);
                            this._minValue.setText(Integer.toString(((AltaTypeBound)currentType).getMin()));
                            this._maxValue.setText(Integer.toString(((AltaTypeBound)currentType).getMax()));
                        } else if (currentType instanceof DBType) {
                            this._fieldTypeSelector.setSelectedIndex(3);
                            this._predefineType.setText(((DBType)currentType).getDBFolder().getRefPath());
                            isPredefineType = true;
                        } else if (currentType instanceof AltaTypeInt) {
                            this._fieldTypeSelector.setSelectedIndex(4);
                        } else if (currentType instanceof AltaTypeFloat) {
                            this._fieldTypeSelector.setSelectedIndex(5);
                        }
                    } else {
                        this._fieldTypeSelector.setSelectedIndex(-1);
                    }
                }
            } else if (this._dbType != null) {
                this._fieldName.setText(this._dbType.getValueAt(index));
            }
            this._ctrlEdit.setEnabled(isPredefineType);
        } else {
            this._fieldName.setText("");
            if (this._typeTable.getSelectedRowCount() == 0) {
                this._ctrlDel.setEnabled(false);
                this._ctrlUp.setEnabled(false);
                this._ctrlDown.setEnabled(false);
                this._ctrlEdit.setEnabled(false);
                this._allocateFieldTypeButton.setEnabled(false);
            } else {
                this._ctrlEdit.setEnabled(false);
                this._allocateFieldTypeButton.setEnabled(false);
                this._ctrlDel.setEnabled(!this._appl.isReader());
                int[] indexes = this._typeTable.getSelectedRows();
                this._ctrlUp.setEnabled(indexes[0] != 0);
                this._ctrlDown.setEnabled(indexes[indexes.length - 1] != this._typeTable.getRowCount() - 1);
            }
        }
    }

    @Override
    public String getInfo(String key) {
        return null;
    }

    @Override
    public IModel getModel(String key) {
        if (!key.equals("docbook.file") && !key.equals("word.file")) {
            return null;
        }
        JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
        if (type == null) {
            return null;
        }
        StringBuilder defaultName = new StringBuilder();
        defaultName.append("Type_").append(this.getDBFolder().getParent().getName()).append("_").append(this.getDBFolder().getName());
        File file = ExpBookUtility.selectFile(type, this.getApplication().getPlugable(), this, this.getDBFolder(), defaultName.toString());
        if (file == null) {
            return null;
        }
        ExpBook book = this.prepareBook();
        if (ExpBookUtility.realiseExport(book, file, this)) {
            return new IModel.DefaultModel(key, file);
        }
        return null;
    }

    private ExpBook prepareBook() {
        ExpBook book = new ExpBook(this.getApplication().getDAOFactory());
        book.setPageFormat(this.getApplication().getPageFormat());
        book.setPreferencies(this.getApplication().getPreferencies());
        if (this._dbType instanceof DBRecord) {
            XPortCfgTypeRecord xPortCfg = new XPortCfgTypeRecord();
            xPortCfg.configBook(book, (DBRecord)this._dbType);
        } else {
            XPortCfgTypeEnum xPortCfg = new XPortCfgTypeEnum();
            xPortCfg.configBook(book, (DBEnum)this._dbType);
        }
        return book;
    }

    @Override
    public CInternalFrame.MemorizedLocation withMemorizedLocation() {
        return CInternalFrame.MemorizedLocation.KEEP_SIZE_AT_FIRST;
    }

    public JTable getTable() {
        return this._typeTable;
    }

    public class FieldEditor
    extends JTextField
    implements KeyListener {
        boolean enterHasBeenPressed;

        FieldEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            switch (e.getID()) {
                case 1005: {
                    if (!this.enterHasBeenPressed) {
                        this.validText();
                    }
                }
                case 1004: {
                    this.enterHasBeenPressed = false;
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.enterHasBeenPressed = true;
                this.validText();
            }
        }

        public void validText() {
            String character = "";
            int selectedRow = AltaTypeFrame.this._editingRow;
            if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(selectedRow);
                if (!field.getName().equals(this.getText())) {
                    if (!AltaReservedWord.isReservedWord(this.getText())) {
                        character = UtilOcas.controlName(this.getText());
                        if (character == null) {
                            if (!AltaTypeFrame.this._dbType.valueExist(this.getText())) {
                                ((DBRecord)AltaTypeFrame.this._dbType).renameCross(field.getName(), this.getText());
                                field.setName(this.getText());
                                AltaTypeFrame.this._fieldName.setText(this.getText());
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this.setModified(true);
                            } else {
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                                this.requestFocus();
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_EDIT_FIELD_ALREADY_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            }
                        } else {
                            ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                            AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                            this.requestFocus();
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", character), ResMsgVoc.getString("VOC_ERROR"), 0);
                        }
                    } else {
                        ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                        AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                        this.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                } else {
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                }
            } else {
                String field = this.getText();
                if (!AltaTypeFrame.this._dbType.getValueAt(selectedRow).equals(field)) {
                    if (!AltaReservedWord.isReservedWord(field)) {
                        character = UtilOcas.controlName(field);
                        if (character == null) {
                            if (!AltaTypeFrame.this._dbType.valueExist(field)) {
                                ((DBEnum)AltaTypeFrame.this._dbType).setValueAt(field, selectedRow);
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this.setModified(true);
                            } else {
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                                this.requestFocus();
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_EDIT_FIELD_ALREADY_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            }
                        } else {
                            ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                            AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                            this.requestFocus();
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", character), ResMsgVoc.getString("VOC_ERROR"), 0);
                        }
                    } else {
                        ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                        AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                        this.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", field), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                } else {
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                }
            }
            if (AltaTypeFrame.this._typeTable.getCellEditor() != null) {
                AltaTypeFrame.this._typeTable.getCellEditor().stopCellEditing();
            }
            AltaTypeFrame.this._typeTable.setEditable(false);
        }
    }

    public class CrossFieldEditor
    extends JTextField {
        boolean enterHasBeenPressed;

        CrossFieldEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CrossFieldEditor.this.enterHasBeenPressed = true;
                        CrossFieldEditor.this.validText();
                    }
                }
            });
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            switch (e.getID()) {
                case 1005: {
                    if (!this.enterHasBeenPressed) {
                        this.validText();
                    }
                }
                case 1004: {
                    this.enterHasBeenPressed = false;
                }
            }
        }

        public void validText() {
            if (AltaTypeFrame.this._editingRow != -1) {
                int selectedRow = AltaTypeFrame.this._editingRow;
                DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(selectedRow);
                if (this.getText().isEmpty()) {
                    field.setCrossField("");
                    ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                    AltaTypeFrame.this.setModified(true);
                } else if (!field.getCrossField().equals(this.getText())) {
                    DBRecordField crossField = ((DBRecord)AltaTypeFrame.this._dbType).fieldExist(this.getText());
                    if (crossField != null) {
                        if (field.canBeCrossWith(crossField)) {
                            if (!((DBRecord)AltaTypeFrame.this._dbType).isFieldCrossed(this.getText())) {
                                field.setCrossField(crossField.getName());
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this.setModified(true);
                            } else {
                                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                                AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                                this.requestFocus();
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._typeTable), ResMsgOcas.msgFormat("TYPE_EDIT_FIELD_ALREADY_CROSS", crossField.getName()), ResMsgVoc.getString("VOC_ERROR"), 0);
                            }
                        } else {
                            ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                            AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                            this.requestFocus();
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._typeTable), ResMsgOcas.msgFormat("TYPE_EDIT_FIELDS_CROSS_ERROR", field.getName(), crossField.getName()), ResMsgVoc.getString("VOC_ERROR"), 0);
                        }
                    } else {
                        ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
                        AltaTypeFrame.this._tabPane.setSelectedIndex(0);
                        this.requestFocus();
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaTypeFrame.this._typeTable), ResMsgOcas.msgFormat("TYPE_EDIT_FIELD_UNKNOW", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                }
            } else {
                ((TypeTableModel)AltaTypeFrame.this._typeTable.getModel()).refresh(false);
            }
            if (AltaTypeFrame.this._typeTable.getCellEditor() != null) {
                AltaTypeFrame.this._typeTable.getCellEditor().stopCellEditing();
            }
            AltaTypeFrame.this._typeTable.setEditable(false);
        }
    }

    public class TypeTable
    extends CeciliaTable {
        public TypeTable _this = this;
        public boolean _isEditable = false;

        public TypeTable() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TypeTable.this._isEditable = false;
                }
            });
        }

        @Override
        protected boolean withSorter() {
            return false;
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            this._isEditable = true;
            int row = this._this.rowAtPoint(e.getPoint());
            int column = this._this.columnAtPoint(e.getPoint());
            if (((TypeTableModel)this._this.getModel()).isCellEditable(row, column)) {
                AltaTypeFrame.this._editingRow = row;
                this._this.editCellAt(row, column);
                this._this.getEditorComponent().requestFocus();
            } else {
                this._isEditable = false;
                if (AltaTypeFrame.this._typeTable.columnAtPoint(e.getPoint()) != 1) {
                    return;
                }
                if (AltaTypeFrame.this._dbType == null) {
                    return;
                }
                if (AltaTypeFrame.this._dbType instanceof DBEnum) {
                    return;
                }
                if (AltaTypeFrame.this._typeTable.getSelectedRow() == -1) {
                    return;
                }
                DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(AltaTypeFrame.this._typeTable.getSelectedRow());
                AltaType type = field.getType();
                if (!(type instanceof DBType)) {
                    return;
                }
                if (((DBType)type).getDBFolder() == null) {
                    return;
                }
                DBFolderTreeActivable tree = AltaTypeFrame.this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
                if (tree != null) {
                    tree.edit(((DBType)type).getDBFolder(), false);
                }
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._isEditable = false;
            super.editingCanceled(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this._isEditable = false;
            super.editingStopped(e);
        }

        public boolean isEditable() {
            return this._isEditable;
        }

        public void setEditable(boolean editable) {
            this._isEditable = editable;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            try {
                AltaTypeFrame.this.selectField();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (AltaTypeFrame.this._dbType instanceof DBEnum && column == 1) {
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected2, boolean hasFocus, int row2, int column2) {
                        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected2, hasFocus, row2, column2);
                        if (value instanceof Color) {
                            Color color = (Color)value;
                            label.setText(" ");
                            label.setBackground(color);
                        }
                        return label;
                    }
                };
                return renderer;
            }
            return super.getCellRenderer(row, column);
        }
    }

    public class TypeTableModel
    extends AbstractTableModel {
        private JTable _table;
        public static final int IDX_COL_NAME = 0;
        public static final int IDX_COL_TYPE = 1;
        public static final int IDX_COL_DIRECTION = 2;
        public static final int IDX_COL_CROSSED = 3;
        public static final int IDX_COL_COLOR_ENUMERATE = 1;
        public static final int IDX_COL_LINKTODISPLAY = 4;

        TypeTableModel(JTable table) {
            this._table = table;
        }

        public void refresh(boolean columnChanged) {
            int c;
            int nbColumn = 0;
            ArrayList<Integer> tabColumnWidth = new ArrayList<Integer>();
            TableColumnModel headerColumnModel = this._table.getTableHeader().getColumnModel();
            int[] selectedRows = this._table.getSelectedRows();
            if (!columnChanged) {
                nbColumn = this.getColumnCount();
                for (c = 0; c < nbColumn; ++c) {
                    tabColumnWidth.add(headerColumnModel.getColumn(c).getWidth());
                }
            }
            this.fireTableChanged(null);
            if (columnChanged) {
                int tableWidth = this._table.getSize().width;
                nbColumn = this.getColumnCount() - 1;
                int columnWidth = tableWidth / nbColumn;
                for (int c2 = 1; c2 < nbColumn; ++c2) {
                    headerColumnModel.getColumn(c2).setPreferredWidth(columnWidth);
                }
                columnWidth = tableWidth - columnWidth * (nbColumn - 1) - (nbColumn + 1);
                headerColumnModel.getColumn(nbColumn).setWidth(columnWidth);
            } else {
                for (c = 0; c < nbColumn; ++c) {
                    headerColumnModel.getColumn(c).setPreferredWidth((Integer)tabColumnWidth.get(c));
                }
            }
            if (this.getColumnCount() == 5) {
                this._table.setRowHeight(20);
                tableColumnModel = this._table.getColumnModel();
                valueColumn = tableColumnModel.getColumn(0);
                valueColumn.setCellEditor(new TypeTableCellEditor(AltaTypeFrame.this._listDirectionCombo));
                valueColumn = tableColumnModel.getColumn(2);
                valueColumn.setCellEditor(new TypeTableCellEditor(AltaTypeFrame.this._listDirectionCombo));
                valueColumn = tableColumnModel.getColumn(3);
                valueColumn.setCellEditor(new TypeTableCellEditor(AltaTypeFrame.this._listDirectionCombo));
                headerColumnModel.getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer());
                headerColumnModel.getColumn(1).setCellRenderer(new AltaDefaultTableCellRenderer());
                headerColumnModel.getColumn(2).setCellRenderer(new DBRecordField.Direction.SpecificTableCellRenderer());
                headerColumnModel.getColumn(3).setCellRenderer(new AltaDefaultTableCellRenderer());
            } else {
                tableColumnModel = this._table.getColumnModel();
                valueColumn = tableColumnModel.getColumn(0);
                valueColumn.setCellEditor(new TypeTableCellEditor(AltaTypeFrame.this._listDirectionCombo));
                headerColumnModel.getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer());
                headerColumnModel.getColumn(1).setCellEditor(new DefaultCellEditor(AltaTypeFrame.this._colorCB));
            }
            if (selectedRows.length != 0 && selectedRows[selectedRows.length - 1] < this._table.getRowCount()) {
                for (int i = 0; i < selectedRows.length; ++i) {
                    this._table.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
                }
            }
        }

        @Override
        public int getColumnCount() {
            if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                return 5;
            }
            return 2;
        }

        @Override
        public int getRowCount() {
            if (AltaTypeFrame.this._dbType == null) {
                return 0;
            }
            return AltaTypeFrame.this._dbType.getValueCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaTypeFrame.this._dbType != null) {
                if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                    DBRecordField recordField = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(row);
                    switch (col) {
                        case 0: {
                            return recordField.getName();
                        }
                        case 1: {
                            AltaType type = recordField.getType();
                            if (type instanceof DBType) {
                                return ((DBType)type).getDBFolder().getRefPath();
                            }
                            if (type == null) {
                                return "???";
                            }
                            return type.getValue();
                        }
                        case 2: {
                            return recordField.getDirection();
                        }
                        case 3: {
                            return recordField.getCrossField();
                        }
                        case 4: {
                            return recordField.isLinkToDisplay();
                        }
                    }
                } else {
                    switch (col) {
                        case 0: {
                            return AltaTypeFrame.this._dbType.getValueAt(row);
                        }
                        case 1: {
                            return ((DBEnum)AltaTypeFrame.this._dbType).getColorEnumerate(AltaTypeFrame.this._dbType.getValueAt(row));
                        }
                    }
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                switch (column) {
                    case 0: {
                        return ResMsgVoc.getString("VOC_NAME");
                    }
                    case 1: {
                        return ResMsgVoc.getString("VOC_TYPE");
                    }
                    case 2: {
                        return ResMsgVoc.getString("VOC_SENS");
                    }
                    case 3: {
                        return ResMsgVoc.getString("VOC_CROSS");
                    }
                    case 4: {
                        return ResMsgVoc.getString("VOC_LINKTODISPLAY");
                    }
                }
                return "";
            }
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COLOR");
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            if (c == 2) {
                return DBRecordField.Direction.class;
            }
            if (AltaTypeFrame.this._dbType instanceof DBRecord && c == 4) {
                return Boolean.class;
            }
            if (!(AltaTypeFrame.this._dbType instanceof DBRecord) && c == 1) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (AltaTypeFrame.this._appl.isReader()) {
                return false;
            }
            if (!AltaTypeFrame.this._typeTable.isEditable() && col != 4 && AltaTypeFrame.this._dbType instanceof DBEnum && col != 1) {
                return false;
            }
            return !(AltaTypeFrame.this._dbType instanceof DBRecord) || col != 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (AltaTypeFrame.this._appl.isReader()) {
                return;
            }
            if (AltaTypeFrame.this._dbType instanceof DBRecord && column == 4) {
                DBRecord record = (DBRecord)AltaTypeFrame.this._dbType;
                DBRecordField field = record.getFieldAt(row);
                if (!field.isLinkToDisplay()) {
                    field.setLinkToDisplay(true);
                    AltaTypeFrame.this.setModified(true);
                    for (int i = 0; i < record.getValueCount(); ++i) {
                        if (row == i) continue;
                        DBRecordField otherField = record.getFieldAt(i);
                        otherField.setLinkToDisplay(false);
                        this.fireTableCellUpdated(i, 4);
                    }
                }
            } else if (!(AltaTypeFrame.this._dbType instanceof DBRecord) && column == 1) {
                DBEnum enumerate = (DBEnum)AltaTypeFrame.this._dbType;
                if (aValue != null) {
                    Color color = (Color)aValue;
                    enumerate.setColorToEnumerate(enumerate.getValueAt(row), (Color)aValue);
                    AltaTypeFrame.this.setModified(true);
                    for (int i = 0; i < enumerate.getValueCount(); ++i) {
                        String enumerateVal;
                        Color currentColor;
                        if (i == row || !color.equals(currentColor = enumerate.getColorEnumerate(enumerateVal = enumerate.getValueAt(i)))) continue;
                        enumerate.setColorToEnumerate(enumerateVal, color);
                        this.fireTableCellUpdated(i, 1);
                    }
                } else {
                    enumerate.setColorToEnumerate(enumerate.getValueAt(row), null);
                }
            }
        }
    }

    public class TypeTableCellEditor
    extends DefaultCellEditor {
        JComboBox _combo;

        TypeTableCellEditor(JComboBox combo) {
            super(new JComboBox());
            this._combo = combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelect, int row, int column) {
            AltaTypeFrame.this._editingRow = -1;
            if (row != -1) {
                switch (column) {
                    case 0: {
                        if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                            DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(row);
                            AltaTypeFrame.this._fieldNameEditor.setText(field.getName());
                        } else {
                            AltaTypeFrame.this._fieldNameEditor.setText(AltaTypeFrame.this._dbType.getValueAt(row));
                        }
                        AltaTypeFrame.this._editingRow = row;
                        return AltaTypeFrame.this._fieldNameEditor;
                    }
                    case 2: {
                        DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(row);
                        this._combo.removeItemListener(AltaTypeFrame.this._listDirectionListener);
                        this._combo.setSelectedItem((Object)field.getDirection());
                        this._combo.addItemListener(AltaTypeFrame.this._listDirectionListener);
                        return this._combo;
                    }
                    case 3: {
                        if (AltaTypeFrame.this._dbType instanceof DBRecord) {
                            DBRecordField field = ((DBRecord)AltaTypeFrame.this._dbType).getFieldAt(row);
                            AltaTypeFrame.this._crossFieldNameEditor.setText(field.getCrossField());
                        }
                        AltaTypeFrame.this._editingRow = row;
                        return AltaTypeFrame.this._crossFieldNameEditor;
                    }
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelect, row, column);
        }
    }
}

