/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AverageAttributeDriver {
    DBAttrib _attribute;
    ArrayList<AverageAttributeCriterion> _criteriums;

    public AverageAttributeDriver(DBAttrib attribute) {
        this._attribute = attribute;
        this._criteriums = new ArrayList();
    }

    public AverageAttributeDriver(DBAttrib attribute, List<AverageAttributeCriterion> criterions) {
        this._attribute = attribute;
        this._criteriums = new ArrayList<AverageAttributeCriterion>(criterions);
    }

    public String toString() {
        return this._attribute.toString();
    }

    public DBAttrib getAttribute() {
        return this._attribute;
    }

    public AverageAttributeDriver setAttribute(DBAttrib dbAttrib) {
        this._attribute = dbAttrib;
        return this;
    }

    public ArrayList<AverageAttributeCriterion> getCriterions(boolean copy) {
        if (copy) {
            ArrayList<AverageAttributeCriterion> result = new ArrayList<AverageAttributeCriterion>(this._criteriums.size() + 1);
            for (AverageAttributeCriterion criterionItem : this._criteriums) {
                result.add(criterionItem.getCopy());
            }
            return result;
        }
        return this._criteriums;
    }

    public AverageAttributeDriver setCriterions(List<AverageAttributeCriterion> criterions) {
        this._criteriums = new ArrayList<AverageAttributeCriterion>(criterions);
        return this;
    }

    public AverageAttributeDriver getCopy() {
        AverageAttributeDriver dest = new AverageAttributeDriver(this._attribute);
        dest._criteriums = new ArrayList(this._criteriums.size());
        for (int i = 0; i < this._criteriums.size(); ++i) {
            dest._criteriums.add(this._criteriums.get(i).getCopy());
        }
        return dest;
    }

    public void toXML(Appendable out, String indent, boolean withID) throws IOException {
        out.append(indent).append("<").append("cec.params.average.compute");
        DBObjectXmlUtility.writeDBFolder(out, this._attribute.getDBFolder(), null, withID);
        out.append(">\n");
        if (!this._criteriums.isEmpty()) {
            String indent1 = indent + "  ";
            for (AverageAttributeCriterion criterion : this._criteriums) {
                criterion.toXML(out, indent1, withID);
            }
        }
        out.append(indent).append("</").append("cec.params.average.compute").append(">\n");
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        DBRelation dbRelation = new DBRelation(dbSrcFolder, typeSrcRelation, this._attribute.getDBFolder(), "ATTRIBUTE");
        relations.add(dbRelation);
        if (!this._criteriums.isEmpty()) {
            for (AverageAttributeCriterion criterion : this._criteriums) {
                criterion.addRelation(dbSrcFolder, typeSrcRelation, relations);
            }
        }
    }

    public void update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
    }
}

