/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.swing.DlgPanelTime;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.project.DBProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AverageFlightDurationPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(AverageFlightDurationPanel.class.getPackage().getName());
    DBProject _dbProject;
    boolean _isAdmin;
    private DlgPanelTime _ctrlDuration;
    private JLabel _ctrlLabelDuration;
    private JCheckBox _ctrlCheckDuration;
    private double _oldDuration = Double.NaN;

    public AverageFlightDurationPanel() {
        this.build();
    }

    public void init(DBProject dbProject, boolean isAdmin) {
        String property;
        DBObjProperty dbObjProp;
        DBObject dbObj;
        this._dbProject = dbProject;
        this._isAdmin = isAdmin;
        this._ctrlCheckDuration.setEnabled(this._isAdmin);
        this._ctrlDuration.setEnabled(this._isAdmin && this._ctrlCheckDuration.isSelected());
        this._ctrlLabelDuration.setEnabled(this._isAdmin && this._ctrlCheckDuration.isSelected());
        if (this._dbProject == null) {
            return;
        }
        boolean checkDuration = false;
        if (this._dbProject.getDBFolder() != null && (dbObj = this._dbProject.getDBFolder().getObject()) != null && (dbObjProp = dbObj.getProperty("project.flightduration.averagevalue")) != null && !(property = dbObjProp.getValue()).isEmpty()) {
            try {
                double duration = Double.parseDouble(property);
                if (duration <= 0.0) {
                    _LOG.warning("Extended property for 'project.flightduration.averagevalue' must be a positif number: " + property);
                } else {
                    checkDuration = true;
                    this._ctrlDuration.setComputeTime(duration);
                    this._oldDuration = duration;
                }
            }
            catch (NumberFormatException nfe) {
                _LOG.warning("Extended property for 'project.flightduration.averagevalue' with not double value: " + property);
            }
        }
        this._ctrlCheckDuration.setSelected(checkDuration);
    }

    private double getCurrentDuration() {
        if (this._ctrlCheckDuration.isSelected()) {
            return this._ctrlDuration.getComputeTime();
        }
        return Double.NaN;
    }

    public boolean isModified() {
        double curDuration = this.getCurrentDuration();
        if (Double.isNaN(this._oldDuration)) {
            return !Double.isNaN(curDuration);
        }
        return this._oldDuration != curDuration;
    }

    public void save() {
        this._oldDuration = this.getCurrentDuration();
        if (!this._isAdmin) {
            return;
        }
        if (this._dbProject == null) {
            return;
        }
        if (this._dbProject.getDBFolder() == null) {
            return;
        }
        DBObject dbObj = this._dbProject.getDBFolder().getObject();
        if (dbObj == null) {
            return;
        }
        DBObjProperty dbObjProp = dbObj.getProperty("project.flightduration.averagevalue");
        if (this._ctrlCheckDuration.isSelected()) {
            double duration = this._ctrlDuration.getComputeTime();
            if (duration > 0.0 && !Double.isNaN(duration)) {
                if (dbObjProp == null) {
                    dbObjProp = new DBObjProperty();
                    dbObjProp.setName("project.flightduration.averagevalue");
                    dbObjProp.setType("Time");
                    dbObjProp.setValue(Double.toString(duration));
                    dbObj.addProperty(dbObjProp);
                } else {
                    dbObjProp.setValue(Double.toString(duration));
                }
            } else {
                _LOG.warning("Average flight duration must be a positif number: " + duration);
            }
        } else if (dbObjProp != null) {
            dbObjProp.setAtDeleted(true);
        }
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this._ctrlLabelDuration = new JLabel(ResMsgObj.getString("DLG_AVERAGEFLIGHT_LABEL"));
        this._ctrlDuration = new DlgPanelTime();
        this._ctrlDuration.setEnabled(false);
        this._ctrlCheckDuration = new JCheckBox(ResMsgObj.getString("DLG_AVERAGEFLIGHT_SELECT"));
        this._ctrlCheckDuration.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AverageFlightDurationPanel.this._ctrlDuration.setEnabled(AverageFlightDurationPanel.this._isAdmin && AverageFlightDurationPanel.this._ctrlCheckDuration.isSelected());
                AverageFlightDurationPanel.this._ctrlLabelDuration.setEnabled(AverageFlightDurationPanel.this._isAdmin && AverageFlightDurationPanel.this._ctrlCheckDuration.isSelected());
            }
        });
        JPanel panelDuration = new JPanel(new GridBagLayout());
        panelDuration.add((Component)this._ctrlLabelDuration, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        panelDuration.add((Component)this._ctrlDuration, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(ToggleBorderLayout.simulate(this._ctrlCheckDuration, panelDuration));
    }
}

