/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.project.gui.ProjectCriticityTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ProjectCriticityPanel
extends JPanel {
    private ProjectCriticityTableModel _model;
    private JTable _ctrlTable;
    private JButton _ctrlAdd;
    private JButton _ctrlDel;
    DBProject _dbProject;
    private boolean _isAdmin = false;

    public ProjectCriticityPanel(DBProject dbProject, boolean isAdmin) {
        super(new GridBagLayout());
        this._dbProject = dbProject;
        this._isAdmin = isAdmin;
        this.build();
    }

    public void save() {
    }

    private void build() {
        this.add(this.createTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.createButtons(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private Component createTable() {
        this._model = new ProjectCriticityTableModel(this._dbProject, this._isAdmin);
        this._ctrlTable = new JTable(this._model);
        TableColumnModel modelcol = this._ctrlTable.getColumnModel();
        int w = 80;
        TableColumn tabCol0 = modelcol.getColumn(0);
        tabCol0.setMinWidth(w);
        tabCol0.setMaxWidth(w);
        tabCol0.setPreferredWidth(w);
        this._ctrlTable.setRowHeight(24);
        this._ctrlTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(2);
                if (value == null || ((String)value).isEmpty()) {
                    this.setText("-");
                }
                return this;
            }
        });
        this._ctrlTable.setDefaultEditor(String.class, new CheckCellEditor(){

            @Override
            protected boolean check(String value) {
                return ProjectCriticityPanel.checkName(value, ProjectCriticityPanel.this._ctrlTable);
            }
        });
        this._ctrlTable.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(0);
                if (value == null) {
                    this.setText("-");
                } else if (Double.isNaN((Double)value)) {
                    this.setText("-");
                }
                return this;
            }
        });
        this._ctrlTable.setDefaultEditor(Double.class, new CheckCellEditor(){

            @Override
            protected boolean check(String value) {
                return ProjectCriticityPanel.checkProbability(value, ProjectCriticityPanel.this._ctrlTable, false);
            }
        });
        this._ctrlTable.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(0);
                if (value == null) {
                    this.setText("-");
                }
                return this;
            }
        });
        this._ctrlTable.setDefaultEditor(Integer.class, new CheckCellEditor(){

            @Override
            protected boolean check(String value) {
                return ProjectCriticityPanel.checkOrder(value, ProjectCriticityPanel.this._ctrlTable);
            }
        });
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectCriticityPanel.this._ctrlDel.setEnabled(ProjectCriticityPanel.this._isAdmin && ProjectCriticityPanel.this._ctrlTable.getSelectedRowCount() != 0);
            }
        });
        return new JScrollPane(this._ctrlTable);
    }

    private Component createButtons() {
        this._ctrlAdd = new JButton(ResMsgVoc.getString("VOC_ADD"));
        this._ctrlDel = new JButton(ResMsgVoc.getString("VOC_TAKEOUT"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._ctrlAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlDel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectCriticityPanel.this.addCriticity();
            }
        });
        this._ctrlDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes = ProjectCriticityPanel.this._ctrlTable.getSelectedRows();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    ProjectCriticityPanel.this._model.del(indexes[i]);
                }
            }
        });
        this._ctrlDel.setEnabled(false);
        return panel;
    }

    private static boolean checkName(String value, JTable table) {
        if (value.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(table), ResMsgCore.getString("MSG_ERR_TEXT_EMPTY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        if (DBFactory.verifyName(value) != 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(table), ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            if (row == table.getEditingRow() || !((String)table.getValueAt(row, 0)).equalsIgnoreCase(value)) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(table), ResMsgObj.getString("DLG_CRITICITY_ERR_ALREADY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    private static boolean checkProbability(String value, JTable table, boolean opt) {
        double dval = Double.NaN;
        if ((value == null || value.isEmpty()) && opt) {
            return true;
        }
        try {
            if (value != null && !value.isEmpty() && ((dval = Double.parseDouble(value)) < 0.0 || dval > 1.0)) {
                dval = Double.NaN;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Double.isNaN(dval)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(table), ResMsgCore.getString("MSG_ERR_BAD_FIELD"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    private static boolean checkOrder(String value, JTable table) {
        int dval = -1;
        try {
            if (value != null && !value.isEmpty()) {
                dval = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (dval < 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(table), ResMsgCore.getString("MSG_ERR_BAD_FIELD"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    private boolean addCriticity() {
        Object[] options = new Object[]{ResMsgVoc.getString("VOC_VALIDATE"), ResMsgVoc.getString("VOC_CANCEL")};
        JOptionPane pane = new JOptionPane(ResMsgVoc.getString("VOC_CRITICITY"), 3, 2, null, options, options[0]);
        pane.setWantsInput(true);
        JDialog dlg = pane.createDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("DLG_CRITICITY_TITLE"));
        dlg.pack();
        dlg.setVisible(true);
        dlg.dispose();
        if (!pane.getValue().equals(options[0])) {
            return true;
        }
        String name = (String)pane.getInputValue();
        if (!ProjectCriticityPanel.checkName(name, this._ctrlTable)) {
            return false;
        }
        this._model.add(new CriticityCriterion().setName(name));
        return true;
    }

    private abstract class CheckCellEditor
    extends DefaultCellEditor {
        public CheckCellEditor() {
            super(new JTextField());
            super.setClickCountToStart(2);
        }

        protected abstract boolean check(String var1);

        @Override
        public boolean stopCellEditing() {
            String value = (String)super.getCellEditorValue();
            if (this.check(value)) {
                return super.stopCellEditing();
            }
            this.cancelCellEditing();
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }
    }
}

