/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ProjectCriticityTableModel
extends AbstractTableModel {
    public static final int CRITICITY_FIELD_NUMBER = 3;
    public static final int IDX_NAME = 0;
    public static final int IDX_PROBA = 1;
    public static final int IDX_ORDER = 2;
    public static final int IDX_LATENT = 3;
    public static final int IDX_EVIDENT = 4;
    public static final String[] __COLUMN_NAMES = new String[]{ResMsgVoc.getString("VOC_CRITICITY"), ResMsgObj.getString("DLG_CRITICITY_PROBA"), ResMsgObj.getString("DLG_CRITICITY_ORDER"), ResMsgObj.getString("DLG_CRITICITY_LSR_L"), ResMsgObj.getString("DLG_CRITICITY_LSR_E")};
    private boolean _isAdmin;
    DBProject _dbProject;

    public ProjectCriticityTableModel(DBProject dbProject, boolean isAdmin) {
        this._isAdmin = isAdmin;
        this._dbProject = dbProject;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        return __COLUMN_NAMES[col];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._dbProject.getCriticityCriterium().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        CriticityCriterion cc = this._dbProject.getCriticityCriterium().get(row);
        switch (col) {
            case 0: {
                return cc.getName();
            }
            case 1: {
                return cc.getProbability();
            }
            case 2: {
                return cc.getOrder();
            }
            case 3: {
                return cc.getLSRLatent();
            }
            case 4: {
                return cc.getLSREvident();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._isAdmin;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        CriticityCriterion cc = this._dbProject.getCriticityCriterium().get(row);
        switch (col) {
            case 0: {
                String newName = aValue.toString();
                if (cc.getName().equals(newName)) break;
                cc.setName(newName);
                this._dbProject.setModified(true);
                break;
            }
            case 1: {
                double value = Double.parseDouble(aValue.toString());
                if (value == cc.getProbability()) break;
                cc.setProbability(value);
                this._dbProject.setModified(true);
                break;
            }
            case 2: {
                int value = Integer.parseInt(aValue.toString());
                if (value == cc.getOrder()) break;
                cc.setOrder(value);
                this._dbProject.setModified(true);
                break;
            }
            case 3: {
                double value;
                double d = value = aValue == null ? Double.NaN : Double.parseDouble(aValue.toString());
                if (!(Double.isNaN(value) ? !Double.isNaN(cc.getLSRLatent()) : value != cc.getLSRLatent())) break;
                cc.setLSRLatent(value);
                this._dbProject.setModified(true);
                break;
            }
            case 4: {
                double value;
                double d = value = aValue == null ? Double.NaN : Double.parseDouble(aValue.toString());
                if (!(Double.isNaN(value) ? !Double.isNaN(cc.getLSREvident()) : value != cc.getLSREvident())) break;
                cc.setLSREvident(value);
                this._dbProject.setModified(true);
                break;
            }
        }
    }

    public void add(CriticityCriterion cc) {
        List<CriticityCriterion> ccs = this._dbProject.getCriticityCriterium();
        int idx = ccs.size();
        ccs.add(cc);
        this._dbProject.setModified(true);
        this.fireTableRowsInserted(idx, idx);
    }

    public void del(int idx) {
        this._dbProject.getCriticityCriterium().remove(idx);
        this._dbProject.setModified(true);
        this.fireTableRowsDeleted(idx, idx);
    }
}

