/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.io.DBProjectXmlConstants;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AverageAttributeHandlerRaw
implements DBProjectXmlConstants {
    private static Logger _LOG = Logger.getLogger(AverageAttributeHandlerRaw.class.getPackage().getName());
    CECFactory _cecFactory;
    DBLogs.DBLogsManager _logMng;
    private DocumentBuilderFactory _dbf = null;

    public AverageAttributeHandlerRaw(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        this._cecFactory = cecFactory;
        this._logMng = logMng;
    }

    protected DBAttrib loadAttribute(String attrPath, String attrID) {
        DBFolder dbFolder;
        long idFolder = -1L;
        if (attrID.length() != 0) {
            try {
                int idOldObj = Integer.parseInt(attrID);
                if (idOldObj != -1 && (idFolder = this._cecFactory.createUtilityDAO().convertMigrationIDAttributeToIDFolder(idOldObj)) == -1L) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObj));
                }
            }
            catch (NumberFormatException e) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Syntax of attribute ID not valid: " + attrID);
            }
        }
        if ((dbFolder = this._cecFactory.createFolderDAO().findFolder(idFolder, attrPath, "ATTRIBUTES")) == null) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN", attrPath));
        } else {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ", attrPath));
            } else {
                return (DBAttrib)dbWrap;
            }
        }
        return null;
    }

    protected DBParam loadParameter(String attrPath, String attrID) throws SQLException {
        DBFolder dbFolder;
        long idFolder = -1L;
        if (attrID.length() != 0) {
            try {
                int idOldObj = Integer.parseInt(attrID);
                if (idOldObj != -1) {
                    idFolder = this._cecFactory.createUtilityDAO().convertMigrationIDParamToIDFolder(idOldObj);
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObj));
                }
            }
            catch (NumberFormatException e) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Syntax of parameter ID not valid: " + attrID);
            }
        }
        if ((dbFolder = this._cecFactory.createFolderDAO().findFolder(idFolder, attrPath, "LAW_PARAMETERS")) == null) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgCore.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_KEY_FOLDER", idFolder, attrID));
        } else {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ", attrPath));
            } else {
                return (DBParam)dbWrap;
            }
        }
        return null;
    }

    public AverageAttributeCriterion loadCriteriumFromXML(Element xmlElt, DBAttrib attr) throws SAXException {
        if (!xmlElt.getNodeName().equals("ATTRIBUTE_DRIVE_DEFINE")) {
            throw new SAXException("An element <ATTRIBUTE_DRIVE_DEFINE> must be here !");
        }
        AttrCriterion criterion = null;
        AverageAttributeCriterion.ProbabilityChoice choice = null;
        DBParam parameter = null;
        String attrOp = xmlElt.getAttribute("OP");
        String attrData = xmlElt.getAttribute("DATA");
        AttrCriterion.Operator op = AttrCriterion.Operator.valueOf(attrOp);
        if (op == null) {
            throw new SAXException("Value of attribute 'OP' unknown : " + attrOp + " !");
        }
        criterion = new AttrCriterion(attr, op, attrData);
        String attrChoice = xmlElt.getAttribute("CHOICE");
        choice = AverageAttributeCriterion.ProbabilityChoice.valueOf(attrChoice);
        if (choice == null) {
            throw new SAXException("Value of attribute 'CHOICE' unknown : " + attrChoice + " !");
        }
        String attrPath = xmlElt.getAttribute("PARAMETER_PATH");
        if (attrPath.length() > 0) {
            String attrID = xmlElt.getAttribute("PARAMETER_ID");
            try {
                parameter = this.loadParameter(attrPath, attrID);
            }
            catch (Exception e) {
                throw new SAXException("Read parameter exception", e);
            }
        }
        if (choice == AverageAttributeCriterion.ProbabilityChoice.DEF) {
            parameter = null;
        }
        ParamRef paramRef = null;
        if (parameter != null) {
            paramRef = new ParamRef(parameter.getType(), parameter.getDBFolder());
        }
        return new AverageAttributeCriterion(criterion, choice, paramRef);
    }

    public AverageAttributeDriver loadAttributeDriveFromXML(Element elt) throws SAXException {
        if (!elt.getNodeName().equals("ATTRIBUTE_DRIVE_SELECT")) {
            throw new SAXException("An element <ATTRIBUTE_DRIVE_SELECT> must be here !");
        }
        ArrayList<AverageAttributeCriterion> criteriums = new ArrayList<AverageAttributeCriterion>();
        DBAttrib dbAttrib = this.loadAttribute(elt.getAttribute("ATTRIBUTE_PATH"), elt.getAttribute("ATTRIBUTE_ID"));
        if (dbAttrib == null) {
            return null;
        }
        NodeList childs = elt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (!xmlChildName.equals("ATTRIBUTE_DRIVE_DEFINE")) continue;
            criteriums.add(this.loadCriteriumFromXML((Element)xmlChild, dbAttrib));
        }
        return new AverageAttributeDriver(dbAttrib, criteriums);
    }

    public Collection<AverageAttributeDriver> loadFromXML(Node parent, IOType type) throws SAXException {
        ArrayList<AverageAttributeDriver> result = new ArrayList<AverageAttributeDriver>();
        if (type != IOType.EXTERN && !parent.getNodeName().equals("ATTRIBUTE_DRIVE_OPTIONS")) {
            throw new SAXException("Root document is not an element <ATTRIBUTE_DRIVE_OPTIONS>");
        }
        NodeList childs = parent.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (!xmlChildName.equals("ATTRIBUTE_DRIVE_SELECT")) continue;
            result.add(this.loadAttributeDriveFromXML((Element)xmlChild));
        }
        AverageAttributeHandlerRaw.verifyLoad(result);
        return result;
    }

    private static void verifyLoad(Collection<AverageAttributeDriver> result) throws SAXException {
    }

    public Collection<AverageAttributeDriver> loadFromXML(InputStream inputStream, IOType type) throws SAXException, IOException {
        if (this._dbf == null) {
            this._dbf = DocumentBuilderFactory.newInstance();
            this._dbf.setValidating(false);
            this._dbf.setIgnoringComments(true);
            this._dbf.setIgnoringElementContentWhitespace(true);
            this._dbf.setCoalescing(false);
            this._dbf.setExpandEntityReferences(true);
        }
        try {
            DocumentBuilder db = this._dbf.newDocumentBuilder();
            Document doc = db.parse(inputStream);
            Element root = doc.getDocumentElement();
            return this.loadFromXML(root, type);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during read file parameters", e);
            StringBuffer sb = new StringBuffer(32);
            sb.append(e.getClass().getName());
            sb.append(" : ");
            String mess = e.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            throw new IOException(sb.toString());
        }
    }

    public static enum IOType {
        DB,
        EXTERN,
        INTERN;

    }
}

