/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparable;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public abstract class DBWrap
extends DBLogsWrap
implements DBComparable<DBWrap> {
    private static Logger _LOG = Logger.getLogger(DBWrap.class.getPackage().getName());
    protected boolean _bModified;
    protected long _timeUpdate;
    protected Map<DBFolder, Long> _dependFolders;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBWrap(DBFolder folder) {
        super(folder);
        this._timeUpdate = folder == null ? 0L : (folder.getObject() == null ? 0L : folder.getObject().getTimeUpdate());
    }

    public abstract DBWrap getCopy();

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (!(src instanceof DBWrap)) {
            return;
        }
        DBWrap dbWrap = (DBWrap)src;
        this._timeUpdate = dbWrap._timeUpdate;
        if (dbWrap._dependFolders != null) {
            this._dependFolders = new LinkedHashMap<DBFolder, Long>(dbWrap._dependFolders);
        }
    }

    public long getRefID() {
        if (this._dbFolder == null) {
            return -1L;
        }
        return this._dbFolder.getID();
    }

    public String getRefPath() {
        if (this._dbFolder == null) {
            return "";
        }
        return this._dbFolder.getRefPath();
    }

    public boolean isModified() {
        return this._bModified;
    }

    public void setModified(boolean value) {
        this._bModified = value;
    }

    public long getTimeUpdate() {
        return this._timeUpdate;
    }

    @Override
    public short getFamilyFlag() {
        return -1;
    }

    protected abstract String getNature();

    protected DBObjModel getDefaultObjModel(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            this.logMsg("Le DAOFactory n'est pas un CECFactory", Level.SEVERE);
            return null;
        }
        DBObjModel model = this._dbFolder.getObject().getModel(this.getNature());
        if (model == null) {
            this.logMsg("Le DBFolder/DBObject n'a pas de modele ayant la bonne nature '" + this.getNature() + "'", Level.FINE);
        }
        return model;
    }

    protected InputStream getBinaryStream(DBObjModel model, DAOFactory cecFactory, DBLogs.DBLogsManager logMng) {
        InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
        if (istream == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
        }
        return istream;
    }

    @Override
    public boolean readFromDAO(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            _LOG.severe("Le DAOFactory n'est pas un CECFactory");
            return false;
        }
        DBLogs.DBLogsManager logMng = this.createReadLogsManager(cecFactory.getUserLogin());
        if (!this.readLogs(cecFactory)) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        DBObjModel model = this.getDefaultObjModel(cecFactory);
        if (model == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        if (!this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
            return false;
        }
        this.prepareDependTimeUpdt(cecFactory, null);
        return true;
    }

    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        return this.logMsg("Le format du modele est inconnu : '" + format + "'", Level.INFO);
    }

    @Override
    public abstract Collection<DBRelation> getUseRelations();

    protected boolean writeModelToDAO(DBObjModel oldModel) {
        DBObjModel newModel = this.writeModel(oldModel);
        if (newModel == null) {
            return false;
        }
        this._dbFolder.getObject().addModel(newModel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToDAO(DAOFactory cecFactory, DBUser dbModifyUser) {
        DBObjModel oldModel = this._dbFolder.getObject().getModel(this.getNature());
        if (!this.writeModelToDAO(oldModel)) {
            return false;
        }
        boolean result = false;
        try {
            result = super.writeToDAO(cecFactory, dbModifyUser);
            if (result) {
                this._timeUpdate = this.getDBFolder().getObject().getTimeUpdate();
                if (_LOG.isLoggable(Level.FINER)) {
                    _LOG.finer("Call writeToDAO(...): " + this.getRefPath() + " at " + this._timeUpdate);
                }
            }
        }
        finally {
            if (result || oldModel == null) {
                // empty if block
            }
        }
        return result;
    }

    protected abstract void toXML(Appendable var1, String var2) throws IOException;

    protected DBObjModel writeModel(DBObjModel model) {
        StringWriter iwriter = new StringWriter();
        try {
            DBObjectXmlUtility.appendXMLHeader(iwriter);
            this.toXML(iwriter, "");
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Soucis lors de la sauvegarde de '" + this.getNature() + "' ...", e);
            return null;
        }
        byte[] ibyte = DAOObjModel.convertToCompressedByte(new ByteArrayInputStream(iwriter.toString().getBytes(StandardCharsets.UTF_8)));
        if (ibyte == null) {
            _LOG.warning("Probleme lors de la compression du flux.");
            return null;
        }
        if (model == null) {
            model = new DBObjModel();
            model.setNature(this.getNature());
        }
        model.setFormat("ZML");
        model.setEncoding("UTF-8");
        model.setSize(ibyte.length);
        model.setStreamToSave(new ByteArrayInputStream(ibyte));
        return model;
    }

    public final DBObjModel writeDBObjModel(boolean updateIfExist) {
        DBObjModel oldModel = null;
        if (updateIfExist) {
            oldModel = this._dbFolder.getObject().getModel(this.getNature());
        }
        return this.writeModel(oldModel);
    }

    public void configureModels(DBObject dbObj) {
        dbObj.addModel(this.writeModel(null));
        if (this.getLogs().withLogs(DBLogs.DBLevel.FINEST)) {
            dbObj.addModel(this.writeDBObjLogs(false));
        }
        dbObj.getFolder().setRelations(this.getUseRelations());
    }

    private Map<DBFolder, Long> createDependTimeUpdt(DAOFactory daoFactory, Collection<DBRelation> dbRelations) {
        GenerateDepFolders generate = new GenerateDepFolders(daoFactory);
        DBFolder dbFolder = this.getDBFolder();
        if (generate.prepare(dbFolder, dbFolder, dbRelations)) {
            Set<DBFolder> dependencies = generate.getDepends(false);
            dependencies.remove(dbFolder);
            if (!dependencies.isEmpty()) {
                LinkedHashMap<DBFolder, Long> dependFolders = new LinkedHashMap<DBFolder, Long>();
                for (DBFolder dbDep : dependencies) {
                    if (dbDep.getObject() == null) continue;
                    long timeUpdate = dbDep.getObject().getTimeUpdate();
                    dependFolders.put(dbDep, timeUpdate);
                }
                return dependFolders;
            }
        } else {
            _LOG.warning("Generate dependencies folder (for Time update) with error.");
            for (GeneralError<DBFolder> err : generate.getErrors()) {
                _LOG.fine(err.toString());
            }
        }
        return null;
    }

    public void prepareDependTimeUpdt(DAOFactory daoFactory, Collection<DBRelation> dbRelations) {
        this._dependFolders = this.createDependTimeUpdt(daoFactory, dbRelations);
    }

    public void updateDependTimeUpdt(DAOFactory daoFactory, Collection<DBRelation> dbRelations) {
        if (this._dependFolders == null) {
            this._dependFolders = this.createDependTimeUpdt(daoFactory, dbRelations);
        } else {
            Map<DBFolder, Long> oldDepends = this._dependFolders;
            this._dependFolders = this.createDependTimeUpdt(daoFactory, dbRelations);
            if (this._dependFolders != null) {
                for (Map.Entry<DBFolder, Long> oldEntry : oldDepends.entrySet()) {
                    if (!this._dependFolders.containsKey(oldEntry.getKey())) continue;
                    this._dependFolders.put(oldEntry.getKey(), oldEntry.getValue());
                }
            }
        }
        daoFactory.createRelationDAO().updateRelations(this.getDBFolder(), "WORKING", dbRelations);
    }

    public boolean changeDependTimeUpdt() {
        if (this._dependFolders == null) {
            return false;
        }
        if (this._dependFolders.isEmpty()) {
            return false;
        }
        for (Map.Entry<DBFolder, Long> depTime : this._dependFolders.entrySet()) {
            if (depTime.getKey().getObject().getTimeUpdate() <= depTime.getValue()) continue;
            if (this.getJavaLog().isLoggable(Level.FINER)) {
                this.getJavaLog().finer("changeDependTimeUpdt(): " + depTime.getKey().getRefPath() + " [" + depTime.getKey().getObject().getTimeUpdate() + " > " + depTime.getValue() + "]");
            }
            return true;
        }
        return false;
    }

    public static DBWrap createOrFind(CECFactory cecFactory, DBFolder dbFolder, DBLogs.DBLogsManager logMng, Class desiredClass) {
        DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            logMng.addLog(DBLogs.DBLevel.WARNING, "L'objet m\u00e9tier () n'est pas lisible:" + dbFolder.getRefPath());
            return null;
        }
        if (!desiredClass.isInstance(dbWrap)) {
            logMng.addLog(DBLogs.DBLevel.WARNING, "L'objet m\u00e9tier n'est pas du bon type ():" + dbFolder.getRefPath());
            return null;
        }
        return dbWrap;
    }

    public void setFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
    }

    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        ArrayList<Function<DBWrap, CompareResult>> list = new ArrayList<Function<DBWrap, CompareResult>>();
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String desc1 = DBWrap.this.getDBFolder().getDescription();
                String desc2 = wrap.getDBFolder().getDescription();
                return new CompareResultString(ResMsgVoc.getString("VOC_DESCRIPTION"), desc1, desc2);
            }
        });
        return list;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        if (wrap == null) {
            return null;
        }
        DBComparaisons compare = new DBComparaisons();
        List<Function<DBWrap, CompareResult>> list = this.getFieldsToCompare(factoryWrap, forImport);
        for (Function<DBWrap, CompareResult> func : list) {
            compare.addConflict(func.apply(wrap));
        }
        return compare;
    }

    public final long getCheckSumFile(DAOFactory factory, DBLogs.DBLogsManager mng, String inputFileStr) {
        DBObject obj = this.getDBFolder().getObject();
        DBObjModel model = obj.getModel(inputFileStr);
        InputStream stream = this.getBinaryStream(model, factory, mng);
        if (stream == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("No stream for model '");
            buffer.append(inputFileStr);
            buffer.append("' (Current Folder: ");
            buffer.append(this.getDBFolder().getRefPath());
            buffer.append(") (Current Factory: ");
            buffer.append(factory.getClass().getName());
            buffer.append(")");
            _LOG.warning(buffer.toString());
            mng.addLog(DBLogs.DBLevel.ERROR, buffer.toString());
            return 0L;
        }
        return this.getCheckSumFile(mng, stream);
    }

    protected final long getCheckSumFile(DBLogs.DBLogsManager mng, InputStream stream) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            FileUtility.copyStream((InputStream)stream, (OutputStream)output);
        }
        catch (IOException error) {
            mng.addLog(DBLogs.DBLevel.ERROR, error.getMessage());
            return 0L;
        }
        CRC32 crc32 = new CRC32();
        byte[] defBytes = output.toByteArray();
        crc32.update(defBytes, 0, defBytes.length);
        return crc32.getValue();
    }
}

