/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.UtilityEdit;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public abstract class DBWrapCmdEdit
extends CThread {
    static Logger _LOG = Logger.getLogger(DBWrapCmdEdit.class.getPackage().getName());
    protected boolean _bReadOnly;
    DBFolder _dbFolder;
    CeciliaAppl _application;
    UtilityEdit _utilEdit;
    String _strTitle;

    protected DBWrapCmdEdit(CeciliaAppl appl, Component c, DBFolder folder, boolean readOnly) {
        super(c);
        this._application = appl;
        this._dbFolder = folder;
        this._bReadOnly = readOnly;
    }

    protected abstract String getLabel();

    protected abstract DBFolder.Family getFamily();

    protected abstract DBInternalFrame editWrap(DBWrap var1, boolean var2);

    protected CeciliaAppl getAppl() {
        return this._application;
    }

    protected DBFolder getFolder() {
        return this._dbFolder;
    }

    @Override
    protected String getIDCode() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.getIDCode()).append(" - ");
        if (this._dbFolder != null) {
            buffer.append(this._dbFolder.getRefPath());
        } else {
            buffer.append("???");
        }
        return buffer.toString();
    }

    protected boolean prepareDo() {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.STD) {
            StringBuilder msg = new StringBuilder();
            DBFolder.Family family = this.getFolder().getFamily();
            byte[] code = StringUtilities.convertHexaStringToByte((String)family.getKey());
            try {
                msg.append(ResMsgCore.getString("APPL_TITLE_CECILIA"));
                msg.append(" - ").append(family.toInt()).append(" - ");
                ConfigManager.getInstance().decrypt(code);
            }
            catch (Exception e) {
                this.getAppl().stopApplication();
                return false;
            }
            if (!msg.append(family.name()).toString().equals(new String(code))) {
                this.getAppl().stopApplication();
                return false;
            }
        }
        StringBuilder sb = new StringBuilder().append(this.getLabel()).append(" '").append(this.getFolder().getRefPath()).append("' ");
        this._strTitle = sb.toString();
        this._utilEdit = new UtilityEdit().canBeEdit(this.getFolder(), this._bReadOnly, this._strTitle, this.getAppl());
        return this._utilEdit != null;
    }

    protected void verifyLogsLevel(DBLogs.DBLevel maxLevel) {
        if (maxLevel.compareTo(DBLogs.DBLevel.WARNING) >= 0) {
            StringBuilder sb = new StringBuilder().append(this.getLabel());
            sb.append(" '").append(this.getFolder().getRefPath()).append("' ");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.msgFormat("MSG_ERR_VERIFY_MODEL_FRM", sb.toString()), this.getAppl().getTitle(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        if (!this.prepareDo()) {
            return;
        }
        DBWrap dbWrap = null;
        try {
            dbWrap = this.readWrap(this.getFolder());
        }
        catch (DemoLimitedException e) {
            DBFolder dbSrc = e.getDBFolderSource() == null ? this.getFolder() : e.getDBFolderSource();
            _LOG.info("DemoLimited " + e.toString(dbSrc));
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.msgFormat("DEMO_ERROR_MODEL", dbSrc.getRefPath(), this.getLabel()), this.getAppl().getTitle(), 0);
        }
        if (dbWrap == null) {
            return;
        }
        _LOG.finer("readWrap-Finnish[" + this.getFolder().getRefPath() + "]");
        boolean lock = this._utilEdit.willBeLocked();
        if (!this._utilEdit.lock(this.getFolder(), this._strTitle, this.getAppl())) {
            return;
        }
        try {
            DBInternalFrame openAccess = this.editWrap(dbWrap, this._utilEdit.readOnly());
            OpenFolder openFolder = new OpenFolder(this.getFolder()).setAccess(openAccess);
            openFolder.addFrame(openAccess.getMasterFrame());
            this.getAppl().getOpenFolders().addOpenFolder(openFolder);
            lock = false;
        }
        finally {
            if (lock) {
                this.getAppl().getOpenFolders().removeOpenFolder(this.getFolder());
                DAOObject daoObject = this.getAppl().getDAOFactory().createObjectDAO();
                if (daoObject.unlock(this.getFolder().getObject(), this.getAppl().getDBSession())) {
                    this.getAppl().refreshDAOFolder(true);
                }
            }
        }
    }

    protected DBWrap readWrap(DBFolder folder) {
        DBWrap dbWrap = this.getAppl().getDAOFactory().findOrCreateWrap(folder);
        if (dbWrap == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.msgFormat("MSG_ERR_LOAD_MODEL_FRM", folder.getRefPath(), this.getLabel()), this.getAppl().getTitle(), 0);
            return null;
        }
        return dbWrap;
    }

    protected Map<DBFolder, List<DBLogs.Log>> generateDependLogs(DBWrap dbWrap) {
        LinkedHashMap<DBFolder, List<DBLogs.Log>> _dependLogs = new LinkedHashMap<DBFolder, List<DBLogs.Log>>();
        Generate<DBWrap> deps = new Generate<DBWrap>((DAOFactory)this.getAppl().getDAOFactory()){

            @Override
            protected Recup<DBWrap> makeRecup(DBFolder.Family key) {
                return new Recup<DBWrap>(key, this);
            }

            @Override
            protected DBWrap findOrCreate(DBFolder dbDest, DBFolder.Family family) {
                return DBWrapCmdEdit.this.getAppl().getDAOFactory().findOrCreateWrap(dbDest);
            }
        };
        deps.prepare(dbWrap.getDBFolder(), dbWrap, null);
        for (DBFolder.Family key : deps.getKeys()) {
            for (DBWrap dep : deps.getValues(key)) {
                List<DBLogs.Log> logs;
                DBLogs depLogs;
                DBLogs.DBLevel depLevel;
                if (dep.equals(dbWrap) || (depLevel = (depLogs = dep.getLogs()).getMaxLevel()).compareTo(DBLogs.DBLevel.WARNING) < 0 || (logs = depLogs.getLogs(DBLogs.DBLevel.WARNING)) == null || logs.size() <= 0) continue;
                _dependLogs.put(dep.getDBFolder(), logs);
            }
        }
        return _dependLogs;
    }
}

