/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public abstract class DBWrapThreadSave
extends CThread {
    private static Logger _LOG = Logger.getLogger(DBWrapThreadSave.class.getPackage().getName());
    boolean _result;
    DBWrap _dbWrap;
    CeciliaAppl _application;
    String _strDescription;

    public DBWrapThreadSave(DBWrap dbWrap, String desc, CeciliaAppl appl, Component c) {
        super(c);
        this._dbWrap = dbWrap;
        this._strDescription = desc;
        this._application = appl;
    }

    protected abstract void setModif(boolean var1);

    protected boolean writeToDAO() {
        return this._dbWrap.writeToDAO(this._application.getDAOFactory(), this._application.getDBUser());
    }

    @Override
    public boolean realiseDo() {
        this._result = false;
        if (this._strDescription != null && this._strDescription.length() > 1023) {
            _LOG.severe("Tentative d'enregistrement d'un objet ayant une description superieur a la limite de la BdD.");
            return false;
        }
        return super.realiseDo();
    }

    @Override
    protected void firstDo() {
        this.setModif(true);
        String oldDescription = this._dbWrap.getDBFolder().getDescription();
        try {
            if (this._strDescription != null) {
                this._dbWrap.getDBFolder().setDescription(this._strDescription);
            }
            if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
                try {
                    ((DemoLimitedFactory)this._application.getDAOFactory()).verifyModelLimits(this._dbWrap);
                }
                catch (DemoLimitedException e) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.msgFormat("DEMO_ERROR_SAVE", e.getDBFolderSource().getRefPath()), this._application.getTitle(), 0);
                    throw e;
                }
            }
            this._result = this.writeToDAO();
        }
        catch (Exception exc) {
            _LOG.log(Level.INFO, "Exception during save DBWrap:" + this._dbWrap.getDBFolder().getRefPath(), exc);
        }
        finally {
            if (!this._result) {
                this._dbWrap.getDBFolder().setDescription(oldDescription);
            }
        }
        if (this._result) {
            this.setModif(false);
        }
    }

    public boolean getResult() {
        return this._result;
    }
}

