/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateAccesses;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Window;
import javax.swing.JOptionPane;

public class UtilityEdit {
    boolean _bReadOnly;
    boolean _bMustBeLocked = false;

    public boolean readOnly() {
        return this._bReadOnly;
    }

    public UtilityEdit canBeEdit(DBFolder folder, boolean readOnly, String title, CeciliaAppl appl) {
        this._bReadOnly = readOnly;
        if (folder.isEdited()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), ResMsgObj.msgFormat("MSG_OBJ_ERR_ISEDITED", title), appl.getTitle(), 0);
            return null;
        }
        GenerateAccesses verifyAccess = new GenerateAccesses(appl.getDAOFactory(), appl.getDBUser());
        verifyAccess.prepare(folder, folder, null);
        if (verifyAccess.withError()) {
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError((Window)appl.getTopWindow());
            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + title);
            dlg.setErrors(verifyAccess.getErrors());
            dlg.setModal(true);
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(appl.getTopWindow()));
            dlg.setVisible(true);
            return null;
        }
        this._bMustBeLocked = true;
        if (!appl.isReader()) {
            DBSession dbSession;
            DBObject dbObject;
            DBObject dbObj = folder.getObject();
            if (dbObj.isLocked() && !(dbObject = (DBObject)appl.getDAOFactory().createObjectDAO().find(dbObj.getID())).isLocked()) {
                appl.refreshDAOFolder(true);
                dbObj = folder.getObject();
            }
            if (dbObj.isLocked()) {
                dbSession = dbObj.getLockedSession();
                dbSession = (DBSession)appl.getDAOFactory().createSessionDAO().find(dbSession.getID());
                if (dbSession != null && !dbSession.isActive() && dbSession.getUser().equals(appl.getDBUser())) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), ResMsgObj.msgFormat("MSG_OBJ_INFO_LOCKBYUSER", title), appl.getTitle(), 0);
                    DAOObject daoObject = appl.getDAOFactory().createObjectDAO();
                    dbObj.setLocked(dbSession);
                    if (!daoObject.unlock(folder.getObject(), appl.getDBUser())) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), ResMsgObj.msgFormat("MSG_OBJ_ERR_UNLOCK", title), appl.getTitle(), 0);
                        return null;
                    }
                }
            }
            if (dbObj.isLocked()) {
                dbSession = dbObj.getLockedSession();
                StringBuilder sb = new StringBuilder(ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", title, dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
                sb.append("\n");
                sb.append(ResMsgObj.getString("INFO_OPEN_READ_ONLY"));
                if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), sb.toString(), appl.getTitle(), 2) == 2) {
                    return null;
                }
                this._bMustBeLocked = false;
                this._bReadOnly = true;
            }
            if (!this._bReadOnly && dbObj.isFreeze()) {
                StringBuilder sb = new StringBuilder(ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", title));
                sb.append("\n").append(ResMsgObj.getString("INFO_OPEN_READ_ONLY"));
                if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), sb.toString(), appl.getTitle(), 2) == 2) {
                    return null;
                }
                this._bReadOnly = true;
            }
        } else {
            this._bReadOnly = true;
        }
        return this;
    }

    public boolean willBeLocked() {
        return this._bMustBeLocked;
    }

    public boolean lock(DBFolder folder, String title, CAppl appl) {
        if (this._bMustBeLocked) {
            DAOObject daoObject = appl.getDAOFactory().createObjectDAO();
            if (!daoObject.lock(folder.getObject(), appl.getDBSession())) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(appl.getTopWindow()), ResMsgObj.msgFormat("MSG_OBJ_ERR_LOCK", title), appl.getTitle(), 0);
                appl.refreshDAOFolder(true);
                return false;
            }
            appl.refreshDAOFolder(true);
        }
        return true;
    }
}

