/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class CompareDiffText {
    public static List<Diff> startDiff(String text1, String text2) {
        List<Diff> diffs = CompareDiffText.startDiff_rec(text1, text2);
        diffs = CompareDiffText.optimizeDiffs(diffs);
        return diffs;
    }

    public static List<Diff> startDiff_rec(String text1, String text2) {
        List<Diff> list;
        List<Diff> diffs = CompareDiffText.checkForOptimisations(text1, text2);
        if (diffs != null && !diffs.isEmpty()) {
            return diffs;
        }
        String preffixStr = CompareDiffText.getPreffix(text1, text2);
        String text1ToTreated = text1.substring(preffixStr.length());
        String text2ToTreated = text2.substring(preffixStr.length());
        String suffixStr = CompareDiffText.getSuffix(text1ToTreated, text2ToTreated);
        text1ToTreated = text1ToTreated.substring(0, text1ToTreated.length() - suffixStr.length());
        text2ToTreated = text2ToTreated.substring(0, text2ToTreated.length() - suffixStr.length());
        if (text1ToTreated.trim().contains("\n") || text2ToTreated.trim().contains("\n")) {
            list = CompareDiffText.doDiffLine(text1ToTreated, text2ToTreated);
        } else {
            list = new ArrayList<Diff>();
            if (text1ToTreated.equals(text2ToTreated)) {
                list.add(new Diff(DiffType.EQUALS, text1ToTreated));
            } else {
                if (!text1ToTreated.isEmpty()) {
                    list.add(new Diff(DiffType.REMOVED, text1ToTreated));
                }
                if (!text2ToTreated.isEmpty()) {
                    list.add(new Diff(DiffType.ADDED, text2ToTreated));
                }
            }
        }
        if (preffixStr != null && !preffixStr.isEmpty()) {
            diffs.add(new Diff(DiffType.EQUALS, preffixStr));
        }
        diffs.addAll(list);
        if (suffixStr != null && !suffixStr.isEmpty()) {
            diffs.add(new Diff(DiffType.EQUALS, suffixStr));
        }
        return diffs;
    }

    private static List<Diff> checkForOptimisations(String text1, String text2) {
        ArrayList<Diff> list = new ArrayList<Diff>();
        if (text1 != null && !text1.isEmpty() && (text2 == null || text2.isEmpty())) {
            list.add(new Diff(DiffType.REMOVED, text1));
        } else if ((text1 == null || text1.isEmpty()) && text2 != null && !text2.isEmpty()) {
            list.add(new Diff(DiffType.ADDED, text2));
        } else if (text1.equals(text2)) {
            list.add(new Diff(DiffType.EQUALS, text1));
        }
        return list;
    }

    private static String getPreffix(String text1, String text2) {
        return CompareDiffText.getCommonText(text1, text2);
    }

    private static String getSuffix(String text1, String text2) {
        String text1Rev = new StringBuilder(text1).reverse().toString();
        String text2Rev = new StringBuilder(text2).reverse().toString();
        return new StringBuilder(CompareDiffText.getCommonText(text1Rev, text2Rev)).reverse().toString();
    }

    private static String getCommonText(String text1, String text2) {
        for (int i = 0; i < Math.min(text1.length(), text2.length()); ++i) {
            char charTxt2;
            char charTxt1 = text1.charAt(i);
            if (charTxt1 == (charTxt2 = text2.charAt(i))) continue;
            return text1.substring(0, i);
        }
        return text1.length() > text2.length() ? text2 : text1;
    }

    private static List<Diff> doDiffLine(String text1ToTreat, String text2ToTreat) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        if (text1ToTreat.length() == 0) {
            diffs.add(new Diff(DiffType.ADDED, text2ToTreat));
            return diffs;
        }
        if (text2ToTreat.length() == 0) {
            diffs.add(new Diff(DiffType.REMOVED, text1ToTreat));
            return diffs;
        }
        String[] splitedText1 = text1ToTreat.split("\n");
        String[] splitedText2 = text2ToTreat.split("\n");
        int maxSize = Math.max(splitedText1.length, splitedText2.length);
        int currentIdxText1 = 0;
        int currentIdxText2 = 0;
        String startingEoL1 = CompareDiffText.getNbrEoL(text1ToTreat, currentIdxText1);
        String startingEoL2 = CompareDiffText.getNbrEoL(text2ToTreat, currentIdxText2);
        currentIdxText1 += startingEoL1.length();
        currentIdxText2 += startingEoL2.length();
        diffs.addAll(CompareDiffText.addEoLs(startingEoL1, startingEoL2));
        for (int i = 0; i < maxSize; ++i) {
            String line1 = null;
            String line2 = null;
            if (i < splitedText1.length) {
                line1 = splitedText1[i];
                currentIdxText1 += line1.length();
            }
            if (i < splitedText2.length) {
                line2 = splitedText2[i];
                currentIdxText2 += line2.length();
            }
            if (line1 != null && line2 != null) {
                diffs.addAll(CompareDiffText.startDiff_rec(line1, line2));
            } else if (line1 == null && line2 != null) {
                diffs.add(new Diff(DiffType.ADDED, line2));
            } else if (line1 != null && line2 == null) {
                diffs.add(new Diff(DiffType.REMOVED, line1));
            }
            String eols1 = CompareDiffText.getNbrEoL(text1ToTreat, currentIdxText1);
            currentIdxText1 += eols1.length();
            String eols2 = CompareDiffText.getNbrEoL(text2ToTreat, currentIdxText2);
            currentIdxText2 += eols2.length();
            diffs.addAll(CompareDiffText.addEoLs(eols1, eols2));
        }
        return diffs;
    }

    private static String getNbrEoL(String wholeText, int currentIdx) {
        char charac;
        StringBuilder sb = new StringBuilder();
        for (int idx = currentIdx; idx < wholeText.length() && (charac = wholeText.charAt(idx)) == '\n'; ++idx) {
            sb.append(charac);
        }
        return sb.toString();
    }

    private static List<Diff> optimizeDiffs(List<Diff> diffs) {
        if (diffs.size() <= 1) {
            return diffs;
        }
        ArrayList<Diff> optimizedDiffs = new ArrayList<Diff>();
        Diff oldDiff = null;
        for (int i = 0; i < diffs.size(); ++i) {
            Diff diff = diffs.get(i);
            if (diff.getType() == DiffType.EQUALS) {
                if (oldDiff != null) {
                    oldDiff = new Diff(DiffType.EQUALS, oldDiff.getText() + diff.getText());
                    continue;
                }
                oldDiff = diff;
                continue;
            }
            if (oldDiff != null) {
                optimizedDiffs.add(oldDiff);
                oldDiff = null;
            }
            optimizedDiffs.add(diff);
        }
        if (oldDiff != null) {
            optimizedDiffs.add(oldDiff);
        }
        return optimizedDiffs;
    }

    private static List<Diff> addEoLs(String startingEoL1, String startingEoL2) {
        ArrayList<Diff> list = new ArrayList<Diff>();
        int lngth1 = startingEoL1.length();
        int lngth2 = startingEoL2.length();
        if (lngth1 == 0 && lngth2 == 0) {
            return list;
        }
        if (lngth1 > lngth2) {
            if (lngth2 != 0) {
                list.add(new Diff(DiffType.EQUALS, startingEoL2));
            }
            list.add(new Diff(DiffType.REMOVED, startingEoL1.substring(lngth2)));
        } else if (lngth2 > lngth1) {
            if (lngth1 != 0) {
                list.add(new Diff(DiffType.EQUALS, startingEoL1));
            }
            list.add(new Diff(DiffType.ADDED, startingEoL2.substring(lngth1)));
        } else {
            list.add(new Diff(DiffType.EQUALS, startingEoL1));
        }
        return list;
    }

    public static class Diff {
        private DiffType _type;
        private String _text;

        public Diff(DiffType type, String text) {
            this._type = type;
            this._text = text;
        }

        public DiffType getType() {
            return this._type;
        }

        public String getText() {
            return this._text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Diff diff = (Diff)o;
            return this._type == diff._type && Objects.equals(this._text, diff._text);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this._type, this._text});
        }

        public String toString() {
            return "Diff{_type=" + this._type + ", _text='" + this._text + "'}";
        }
    }

    public static enum DiffType {
        EQUALS,
        ADDED,
        REMOVED;

    }
}

