/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io;

import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public abstract class AbstractCmdImport
extends CCmd {
    public static final String PROP_IMPORT_AUTOCORRECTNAME = "cecilia.import.Xml6AutoCorrectName";
    public static final String PROP_EGL_NO_UPDATE = "cecilia.ft.import.NoUpdateEGL";
    protected JFrame _ctrlOwner;
    protected File[] _importFiles;

    public AbstractCmdImport(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
        this._ctrlOwner = owner;
    }

    protected boolean withFiles() {
        return false;
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected boolean prepareDo() {
        JFileChooser dlg = new JFileChooser();
        FileFilterExtention altFilter = this.createFileFilter().verifyRead(true);
        dlg.addChoosableFileFilter(altFilter);
        dlg.setFileFilter(altFilter);
        dlg.setCurrentDirectory(new File(PlugableUtility.getStrOpt(this.getAppl().getPlugable(), "plugable.option.path", ".")));
        dlg.setDialogTitle(this.getTitle());
        dlg.setMultiSelectionEnabled(this.withFiles());
        if (dlg.showOpenDialog(this._ctrlOwner) == 0) {
            if (this.withFiles()) {
                this._importFiles = dlg.getSelectedFiles();
            } else {
                File file = dlg.getSelectedFile();
                if (file != null) {
                    this._importFiles = new File[]{file};
                }
            }
            if (this._importFiles != null && this._importFiles.length > 0) {
                this.getAppl().getPlugable().setOption("plugable.option.path", this._importFiles[0].getParent());
                return true;
            }
            this._importFiles = null;
        }
        return false;
    }

    protected abstract String getTitle();

    protected abstract FileFilterExtention createFileFilter();
}

