/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Linker;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.Date;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSA51Handler
extends SAXExtendedHandler
implements SA51Constant {
    private final SA51Handler _handler;
    private static Date _dateLastUpdateCecilia = new Date(1472594400000L);
    private DBLogs _logs;
    protected final int INTEGER_TYPE = 0;
    protected final int DOUBLE_TYPE = 1;

    public AbstractSA51Handler(SA51Handler handler) {
        this._handler = handler;
        this._logs = new DBLogs();
    }

    public SA51Handler getHandler() {
        return this._handler;
    }

    public long getCounter() {
        return this._handler.getCounter();
    }

    public long incrementCounter() {
        return this._handler.incrementCounter();
    }

    public SA51Linker getLinker() {
        return this._handler.getLinker();
    }

    public CECFactory getCeciFactory() {
        return this._handler.getCECFactory();
    }

    public String getLogin() {
        return this._handler.getLogin();
    }

    public static Date getLastUpdateDate() {
        return _dateLastUpdateCecilia;
    }

    public DBLogs getLogs() {
        return this._logs;
    }

    public DBFolder createNewFolder(String name, int flags, boolean withDate, DBFolder parent) {
        return this.createNewFolder(name, flags, withDate, null, parent);
    }

    public DBFolder createNewFolder(String name, int flags, boolean withDate, String desc, DBFolder parent) {
        DBFolder folder = new DBFolder(this.incrementCounter());
        folder.setName(name);
        folder.setFlags(flags);
        if (withDate) {
            folder.setDateCreate(AbstractSA51Handler.getLastUpdateDate());
            folder.setDateModify(AbstractSA51Handler.getLastUpdateDate());
        }
        folder.setDescription(desc);
        SA51Utils.linkDBFolder(parent, folder);
        return folder;
    }

    public DBFolder createNewFolder(String name, int flags, Date createDate, Date createModify, String desc, DBFolder parent) {
        DBFolder folder = this.createNewFolder(name, flags, false, desc, parent);
        folder.setDateCreate(createDate);
        folder.setDateModify(createModify);
        return folder;
    }

    protected void addDefaultLog(DBLogsWrap dbWrap) {
        DBLogs logs = new DBLogs();
        DBLogs.Log log = logs.addLog(this.getHandler().getCurrentDate(), this.getLogin(), DBLogs.DBLevel.FINE, ResMsgSA51.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getHandler().getFilePathForLog()));
        dbWrap.getLogs().addLog(log);
    }

    protected String getAttribute(Map<String, String> attrs, String keyAttr) {
        if (attrs == null) {
            return null;
        }
        String value = attrs.get(keyAttr);
        if (value == null) {
            return null;
        }
        return value;
    }

    protected Number getNumericalAttribute(Map<String, String> attrs, String keyAttr, int typeNumerical) {
        String value = this.getAttribute(attrs, keyAttr);
        if (value == null || value.isEmpty()) {
            return -1;
        }
        try {
            switch (typeNumerical) {
                case 0: {
                    return Integer.parseInt(value);
                }
                case 1: {
                    return Double.parseDouble(value);
                }
            }
            assert (false);
            return null;
        }
        catch (NumberFormatException err) {
            return -1;
        }
    }

    protected Param getParameter(CECFactory cecFactory, String idRef, String tagName, String attrName) throws SAXException {
        if (idRef == null) {
            return null;
        }
        SA51Utils.Pair p = SA51Utils.createVarWithVer(idRef);
        if (p == null) {
            return null;
        }
        String parameterName = this.getValidName(p.getName(), DBFolder.Family.ATTRIBUTE, tagName, attrName);
        DBFolder folderRes = SA51Utils.goToChild(cecFactory.createFolderDAO().getRootID("LAW_PARAMETERS"), "Default", parameterName, p.getVersion());
        if (folderRes == null) {
            return null;
        }
        return new ParamRef(null, folderRes);
    }

    public DBFolder getFolderBTP(DBFolder root, String btpRef) throws SAXException {
        String[] allFolders = btpRef.substring(btpRef.indexOf(47) + 1).split("/");
        DBFolder folder = root;
        for (String s : allFolders) {
            if (folder == null) {
                return null;
            }
            s = this.getValidName(s, DBFolder.Family.BTP_MODEL, "EVENT", "BTP_REF");
            folder = folder.findChild(s);
        }
        return folder;
    }

    public String getValidBTPPath(String originalPath) throws SAXException {
        String result = originalPath.substring(1);
        String[] split = result.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        for (String subPath : split) {
            subPath = this.getValidName(subPath, DBFolder.Family.BTP_MODEL, "EVENT", "BTP_REF");
            sb.append(subPath).append('/');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String[] createFoldersSubtree(String path) throws SAXException {
        if (!path.contains(";")) {
            return null;
        }
        String[] paths = path.split(";");
        if (paths.length != 3) {
            return null;
        }
        if (!(paths[0].contains(" ") && paths[1].contains(" ") && paths[2].contains(" "))) {
            return null;
        }
        String projectName = paths[0].substring(0, paths[0].lastIndexOf(32));
        String systemName = paths[1].substring(0, paths[1].lastIndexOf(32));
        String treeName = paths[2].substring(0, paths[2].lastIndexOf(32));
        String treeVersion = paths[2].substring(paths[2].lastIndexOf(32) + 1 + 1, paths[2].length() - 1);
        String[] tab = new String[]{projectName, systemName, treeName, treeVersion};
        for (int i = 0; i < 3; ++i) {
            tab[i] = this.getValidName(tab[i], DBFolder.Family.PROJECT, "SUBTREE", "NAME");
        }
        return tab;
    }

    protected final String getValidName(String originalName, DBFolder.Family familyName, String tagName, String attrName) throws SAXException {
        String result = originalName;
        if (!DBFactory.verifyName(result, familyName)) {
            if (Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName")) {
                if (!DBFactory.verifyName(result = DBFactory.convertName(result, familyName), familyName)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", tagName, attrName, result), this.getLocator()));
                }
            } else {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", tagName, attrName, result), this.getLocator()));
            }
        }
        return result;
    }

    protected final String getValidDesc(String originalName) {
        String result = originalName;
        if (result != null && (result = result.trim()).length() > 1023) {
            this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_WARNING_COMMENT_TOO_LONG", result), this.getLocator()));
            result = result.substring(0, 1023);
            this.getLogs().addLog(this.getHandler().getCurrentDate(), this.getLogin(), DBLogs.DBLevel.WARNING, ResMsgSA51.getString("MSG_LOG_COMMENT_TOO_LONG"));
        }
        return result;
    }

    public void warning(SAXParseException e) {
        SA51Utils._LOG.warning(this.getClass().getName() + ": " + e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        SA51Utils._LOG.severe(this.getClass().getName() + ": " + e.getMessage());
        throw e;
    }
}

