/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51LawHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class SA51CCFHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private SA51LawHandler _lawHandler;
    private String _nameCCF;
    private List<Double> _factorsCCF = new ArrayList<Double>();
    private Law _law;
    private CCF.CCFType _ccfModel;
    private DBFolder _ccfFolder = this.getCeciFactory().createFolderDAO().getRootID("CCF_MODELS");
    private String _comment;
    public static Map<String, CCF.CCFType> CCF_MODELS = new LinkedHashMap<String, CCF.CCFType>();

    public SA51CCFHandler(SA51Handler handler) {
        super(handler);
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._lawHandler != null) {
            this._lawHandler.startAction(name, attrs, false);
        } else if ("CCF".equals(name)) {
            this._nameCCF = this.getValidName(this.getAttribute(attrs, "NAME"), DBFolder.Family.CCF_MODEL, name, "NAME");
            this._comment = this.getValidDesc(this.getAttribute(attrs, "DESCRIPTION"));
        } else if ("VALUE_PARAMETER".equals(name)) {
            this._factorsCCF.add(Double.parseDouble(this.getAttribute(attrs, "VALUE")));
        } else if (SA51Utils.INDEX_LAWS.containsKey(name)) {
            this._lawHandler = new SA51LawHandler(name, this.getHandler());
            this._lawHandler.startAction(name, attrs, false);
        } else if (CCF_MODELS.keySet().contains(name)) {
            this._ccfModel = CCF_MODELS.get(name);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._lawHandler != null && this._lawHandler.endAction(name, attrs, txt)) {
            this._law = this._lawHandler.getLaw().getCopy();
            if (this._lawHandler.getModifier() != null) {
                this._law.setModifierLaw(this._lawHandler.getModifier());
            }
            this._lawHandler = null;
        }
        if ("CCF".equals(name)) {
            DBFolder dbFolder = this.createNewFolder(this._nameCCF, DBFolder.createFlagsModel(DBFolder.Family.CCF_MODEL, (short)0, (short)0), true, null, this._ccfFolder);
            DBFolder folderVersionCCF = this.createNewFolder("1", DBFolder.createFlagsVersion(DBFolder.Family.CCF_MODEL, (short)0, (short)0), true, this._comment == null || this._comment.isEmpty() ? null : this._comment, dbFolder);
            CCF ccf = new CCF(folderVersionCCF);
            double[] tab = new double[this._factorsCCF.size()];
            int i = 0;
            for (Double value : this._factorsCCF) {
                tab[i++] = value;
            }
            this._factorsCCF.clear();
            ccf.setFactors((double[])tab.clone());
            ccf.setLaw(this._law.getCopy());
            this._law = null;
            ccf.setType(this._ccfModel);
            for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
                ccf.getLogs().addLog(log);
            }
            this.addDefaultLog(ccf);
            DBObject objCCF = new DBObject(folderVersionCCF.getID()).setFolder(folderVersionCCF);
            folderVersionCCF.setObject(objCCF);
            DBObjModel dbObjModel = ccf.writeDBObjModel(false);
            objCCF.addModel(new DBObjModelBytes(dbObjModel));
            DBObjModel dbObjLogs = ccf.writeDBObjLogs(false);
            objCCF.addModel(new DBObjModelBytes(dbObjLogs));
            this.getLinker().addNewObject(this._nameCCF, SA51Handler.TypeObject.CCF, folderVersionCCF);
            this.getCeciFactory().createObjectDAO().putWrap(objCCF, ccf);
        }
        return "CCF_LIST".equals(name);
    }

    static {
        CCF_MODELS.put("CCF_ALPHA_MODEL", CCF.CCFType.ALPHA);
        CCF_MODELS.put("CCF_BETA_MODEL", CCF.CCFType.BETA);
        CCF_MODELS.put("CCF_MGL_MODEL", CCF.CCFType.MGL);
    }
}

