/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51EventHandler;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51DSFHandler
extends AbstractSA51Handler
implements SA51Constant {
    private SA51EventHandler _currentEvent;
    private FTConfig _currentConf;
    private DAOFolder _daoFolder;
    private Date _creationDate;
    private List<SA51Handler.IdentifiantObject> _DSFNotLinked = new ArrayList<SA51Handler.IdentifiantObject>();
    private List<SA51EventHandler.Attribute> _listAttributes;
    private Param _isInspected;
    private Param _inFlightTested;
    private DBFolder _systemFolder;
    private DBFolder _dsfFolder;
    private DBFolder _dsfVersionFolder;
    private String _linkSubtree;
    private boolean _isDSF;
    private String _btpRef;
    private String _comment;

    public SA51DSFHandler(DBFolder root, SA51Handler handler) {
        super(handler);
        this._daoFolder = this.getCeciFactory().createFolderDAO();
        this._systemFolder = root;
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._currentEvent != null) {
            this._currentEvent.startAction(name, attrs, startAction);
        } else if ("IDENTIFICATION".equals(name)) {
            String nameTree = this.getAttribute(attrs, "NAME");
            String dateCreation = this.getAttribute(attrs, "CREATION_DATE");
            String dateUpdate = this.getAttribute(attrs, "UPDATE_DATE");
            String version = this.getAttribute(attrs, "VERSION");
            String release = this.getAttribute(attrs, "RELEASE");
            this._dsfFolder = this._systemFolder.findChild(nameTree);
            if (this._dsfFolder == null) {
                this._dsfFolder = this.createNewFolder(nameTree, DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)3, (short)0), true, this._systemFolder);
            }
            this._dsfFolder.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)3, (short)0));
            this._dsfFolder.setDateCreate(this._creationDate);
            this._dsfFolder.setDateModify(SA51DSFHandler.getLastUpdateDate());
            this._dsfVersionFolder = this._dsfFolder.findChild(version + "." + release);
            if (this._dsfVersionFolder == null) {
                this._dsfVersionFolder = this.createNewFolder(version + "." + release, DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)3, (short)0), false, this._dsfFolder);
            }
            this._dsfVersionFolder.setDateCreate(SA51Utils.convertDate(dateCreation));
            this._dsfVersionFolder.setDateModify(SA51Utils.convertDate(dateUpdate));
            this._dsfVersionFolder.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)3, (short)0));
            this.getLinker().addNewObject(nameTree, SA51Handler.TypeObject.CCF, this._dsfVersionFolder);
        } else if ("EVENT".equals(name)) {
            this._currentEvent = new SA51EventHandler(this.getAttribute(attrs, "NAME"), this.getHandler());
            this._currentEvent.startAction(name, attrs, true);
        } else if ("DSF".equals(name)) {
            this._creationDate = SA51Utils.convertDate(this.getAttribute(attrs, "CREATION_DATE"));
        } else if ("CONFIG_DSF".equals(name)) {
            this._currentConf = new FTConfig();
            this._currentConf.setName(this.getAttribute(attrs, "NAME"));
        } else if ("DSF_ITEM".equals(name)) {
            String attrName = this.getAttribute(attrs, "NAME");
            int attrValue = this.getNumericalAttribute(attrs, "VALUE", 0).intValue();
            if (attrValue == 0) {
                return;
            }
            if (attrValue == 1) {
                String idDSF;
                String string = idDSF = attrName.contains("/") ? SA51DSFHandler.convertPathDSFToNormalPath(attrName) : attrName;
                if (idDSF != null) {
                    SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.DSF, idDSF, this._currentConf);
                    this._DSFNotLinked.add(idObj);
                    this.getLinker().addNewLinkToDo(idObj);
                } else {
                    SA51Utils._LOG.log(Level.SEVERE, ResMsgSA51.msgFormat("MSG_ERR_SYNTAX_LINK", attrName, this.getHandler().getLocator().getLineNumber(), this.getHandler().getLocator().getColumnNumber(), name));
                }
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._currentEvent != null && this._currentEvent.endAction(name, attrs, txt)) {
            this._comment = this.getValidDesc(this._currentEvent.getLabel());
            this._linkSubtree = this._currentEvent.getSubtreeLink();
            this._isDSF = this._currentEvent.isDSF();
            this._btpRef = this._currentEvent.getBTPRef();
            this._listAttributes = this._currentEvent.getAttrs();
            this._isInspected = this._currentEvent.getInspected();
            this._inFlightTested = this._currentEvent.getInFlightTest();
            this._currentEvent = null;
            return false;
        }
        if ("CONFIG_DSF".equals(name)) {
            return true;
        }
        if ("DSF".equals(name)) {
            DBObject object = this._dsfVersionFolder.getObject();
            if (object == null) {
                Object obj;
                DSFEquation ftEquation = new DSFEquation(this._dsfVersionFolder);
                if (this._linkSubtree != null && !this._linkSubtree.isEmpty()) {
                    String[] strFolders;
                    DBFolder parentFolder = this.getCeciFactory().createFolderDAO().getRootID("PROJECTS");
                    for (String s : strFolders = this.createFoldersSubtree(this._linkSubtree)) {
                        DBFolder tmp = parentFolder.findChild(s);
                        if (tmp == null) {
                            tmp = new DBFolder(this.incrementCounter());
                            if (strFolders[0].equals(s)) {
                                tmp.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, (short)0));
                                DBProject project = new DBProject(tmp);
                                DBObject objectProject = new DBObject(tmp.getID());
                                objectProject.setFolder(tmp);
                                tmp.setObject(objectProject);
                                DBObjModel dbObjModel = project.writeDBObjModel(false);
                                objectProject.addModel(new DBObjModelBytes(dbObjModel));
                                this.getCeciFactory().createObjectDAO().putWrap(objectProject, project);
                            } else if (strFolders[1].equals(s)) {
                                tmp.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)0, (short)0));
                            } else if (strFolders[2].equals(s)) {
                                tmp.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, this._isDSF ? (short)3 : 2, (short)0));
                            } else if (strFolders[3].equals(s)) {
                                tmp.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, this._isDSF ? (short)3 : 2, (short)0));
                            }
                            tmp.setName(s);
                            SA51Utils.linkDBFolder(parentFolder, tmp);
                        }
                        if (tmp.getDateCreate() == null) {
                            tmp.setDateCreate(SA51DSFHandler.getLastUpdateDate());
                        }
                        if (tmp.getDateModify() == null) {
                            tmp.setDateModify(SA51DSFHandler.getLastUpdateDate());
                        }
                        parentFolder = tmp;
                    }
                    DBObject obj2 = parentFolder.getObject();
                    FTEquationAbstract tfEqua = (FTEquationAbstract)this.getCeciFactory().createObjectDAO().getWrap(obj2);
                    if (tfEqua == null) {
                        tfEqua = new FTEquation(parentFolder);
                    }
                    ftEquation.setSubTree(tfEqua);
                    this.getLinker().addNewObject(SA51Utils.getFullPath(this._dsfVersionFolder, "PROJECTS"), SA51Handler.TypeObject.DSF, this._dsfVersionFolder);
                    SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(null, this._linkSubtree, parentFolder);
                    idObj.setIsDSF(this._isDSF);
                    idObj.setTree(ftEquation);
                    idObj.setEventName(this._dsfFolder.getName());
                    this.getLinker().addSubtreeDSF(idObj);
                }
                if (this._btpRef != null && !this._btpRef.isEmpty()) {
                    DBFolder foldBTP = this.getFolderBTP(this._daoFolder.getRootID("LAW_MODELS"), this._btpRef);
                    if (foldBTP == null) {
                        SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.BTP, this._btpRef, ftEquation.getEvent());
                        idObj.setTree(ftEquation);
                        this.getLinker().addNewLinkToDo(idObj);
                    } else {
                        obj = foldBTP.getObject();
                        DBModelLaw dbLaw = (DBModelLaw)this.getCeciFactory().createObjectDAO().getWrap((DBObject)obj);
                        ftEquation.getEvent().setModelLaw(dbLaw);
                        ftEquation.getDBFolder().setDescription(this._comment);
                    }
                }
                ArrayList<DBAttrib.Value> values = new ArrayList<DBAttrib.Value>();
                for (SA51EventHandler.Attribute attr : this._listAttributes) {
                    SA51Utils.Pair p = SA51Utils.createVarWithVer(attr.getName());
                    if (p == null) {
                        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", "ATTRIBUTE_INSTANCE", "NAME", attr.getName()), this.getLocator()));
                        continue;
                    }
                    DBFolder attrVers = SA51Utils.goToChild(this._daoFolder.getRootID("ATTRIBUTES"), "Default", p.getName(), p.getVersion());
                    if (attrVers == null || attrVers.getObject() == null) {
                        this.getLinker().addNewLinkToDo(new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.ATTRIBUTE, p.getName() + p.getVersion(), ftEquation.getEvent(), attr.getValue()));
                        continue;
                    }
                    DBAttrib dbAttr = (DBAttrib)this.getCeciFactory().createObjectDAO().getWrap(attrVers.getObject());
                    if (dbAttr == null) {
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_READ", attrVers.getRefPath(), ftEquation.getEvent().getLabel()), this.getLocator()));
                        continue;
                    }
                    String attrValue = SA51Utils.checkValue(attr.getValue(), dbAttr.getType());
                    DBAttrib.Value v = dbAttr.createInstance(attrValue);
                    if (v == null) {
                        String definition = new StringBuilder(128).append("'").append(attrVers.getRefPath()).append("' = ").append(attr.getValue()).toString();
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_VALUE", definition, ftEquation.getEvent().getLabel()), this.getLocator()));
                        continue;
                    }
                    values.add(v);
                }
                ftEquation.getEvent().setAttributes(values);
                if (this._inFlightTested != null) {
                    ftEquation.getEvent().setInflightTested(this._inFlightTested);
                } else if (this._isInspected != null) {
                    ftEquation.getEvent().setInspected(this._isInspected);
                }
                this.addDefaultLog(ftEquation);
                obj = new DBObject(this._dsfVersionFolder.getID()).setFolder(this._dsfVersionFolder);
                this._dsfVersionFolder.setObject((DBObject)obj);
                DBObjModel dbObjModel = ftEquation.writeDBObjModel(false);
                ((DBObject)obj).addModel(new DBObjModelBytes(dbObjModel));
                DBObjModel dbObjLogs = ftEquation.writeDBObjLogs(false);
                ((DBObject)obj).addModel(new DBObjModelBytes(dbObjLogs));
                this.getCeciFactory().createObjectDAO().putWrap((DBObject)obj, ftEquation);
            }
            return true;
        }
        return false;
    }

    public List<SA51Handler.IdentifiantObject> getDSFNotLinked() {
        return this._DSFNotLinked;
    }

    public static boolean isVersion(String s) {
        String regex = "[0-9]+\\.[0-9]+";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static String convertPathDSFToNormalPath(String dsfPath) {
        StringBuilder sb = new StringBuilder();
        String[] splitPaths = dsfPath.split("/");
        if (DBFactory.verifyName(splitPaths[0]) != 0 || DBFactory.verifyName(splitPaths[1]) != 0) {
            return null;
        }
        if (!splitPaths[2].contains(" ")) {
            return null;
        }
        String[] nameWithVers = splitPaths[2].split(" ");
        if (DBFactory.verifyName(nameWithVers[0]) != 0 || !nameWithVers[1].matches("\\(\\d+\\.\\d+\\)")) {
            return null;
        }
        sb.append('/').append(dsfPath.substring(0, dsfPath.indexOf(32))).append('/').append(dsfPath.substring(dsfPath.indexOf(40) + 1, dsfPath.indexOf(41)));
        return sb.toString();
    }
}

