/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51LawHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51EventHandler
extends AbstractSA51Handler
implements SA51Constant {
    private SA51LawHandler _lawHandler;
    private Law _law;
    private String _name;
    private List<String> _children = new ArrayList<String>();
    private FTDefinition.Type _type;
    private String _comment;
    private int _atLeast;
    private String _state;
    private Param _inspected;
    private Param _isInFlightTested;
    private boolean _generic = false;
    private String _genericExtention;
    private String _currCCF;
    private List<Attribute> _attributes = new ArrayList<Attribute>();
    private String _btpRef;
    private String _subtreeLink;
    private String _isUnlink;
    private boolean _isDSF;
    private String _attribute;
    private String _value;
    public static Map<String, FTDefinition.Type> INDEX_GATES = new LinkedHashMap<String, FTDefinition.Type>();

    public String getAttrName() {
        return this._attribute;
    }

    public String getAttrVal() {
        return this._value;
    }

    public boolean isLeaf() {
        return this._children.isEmpty();
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return this._comment;
    }

    public Law getLaw() {
        return this._law;
    }

    public List<String> getChildren() {
        return this._children;
    }

    public FTDefinition.Type getType() {
        return this._type;
    }

    public int getAtLeast() {
        return this._atLeast;
    }

    public String getState() {
        return this._state;
    }

    public Param getInspected() {
        return this._inspected;
    }

    public Param getInFlightTest() {
        return this._isInFlightTested;
    }

    public boolean getGenericity() {
        return this._generic;
    }

    public String getGenericExtention() {
        return this._genericExtention == null ? "" : this._genericExtention;
    }

    public String getCCFEvent() {
        return this._currCCF;
    }

    public List<Attribute> getAttrs() {
        return this._attributes;
    }

    public String getBTPRef() {
        return this._btpRef;
    }

    public String getSubtreeLink() {
        return this._subtreeLink;
    }

    public String getIsUnlink() {
        return this._isUnlink;
    }

    public boolean isDSF() {
        return this._isDSF;
    }

    public SA51EventHandler(String name, SA51Handler handler) {
        super(handler);
        this._name = name;
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._lawHandler != null) {
            this._lawHandler.startAction(name, attrs, true);
        } else if (SA51Utils.INDEX_LAWS.containsKey(name)) {
            this._lawHandler = new SA51LawHandler(name, this.getHandler());
            this._lawHandler.startAction(name, attrs, startAction);
        } else if ("OPERATOR".equals(name)) {
            String gateType = this.getAttribute(attrs, "NAME");
            this._type = INDEX_GATES.get(gateType);
            if (gateType.equals("N")) {
                this._atLeast = Integer.parseInt(this.getAttribute(attrs, "VALUE"));
            }
        } else if ("GENERICITY".equals(name)) {
            this._generic = Boolean.parseBoolean(this.getAttribute(attrs, "IS_GENERIC"));
            this._genericExtention = this.getAttribute(attrs, "NAME");
        } else if ("ATTRIBUTE_INSTANCE".equals(name)) {
            Attribute attr = new Attribute(this.getAttribute(attrs, "NAME"), this.getAttribute(attrs, "VALUE"));
            this._attributes.add(attr);
        } else if ("EVENT".equals(name)) {
            this._currCCF = this.getAttribute(attrs, "CCF_REF");
            this._generic = false;
            this._inspected = null;
            this._isInFlightTested = null;
            this._comment = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            this._state = this.getAttribute(attrs, "STATE");
            this._btpRef = this.getAttribute(attrs, "BTP_REF");
            String inspected = this.getAttribute(attrs, "ISINSPECTED");
            if (inspected != null) {
                try {
                    double d = Double.parseDouble(inspected);
                    this._inspected = new ParamValue(null, d);
                }
                catch (Exception e) {
                    this._inspected = this.getParameter(this.getCeciFactory(), inspected, name, "ISINSPECTED");
                    if (this._inspected == null) {
                        this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_PARAMETER", inspected), this.getLocator()));
                    }
                }
            } else {
                String expected = this.getAttribute(attrs, "ISINFLIGHTTESTED");
                if (expected != null) {
                    try {
                        double d = Double.parseDouble(expected);
                        this._isInFlightTested = new ParamValue(null, d);
                    }
                    catch (Exception e) {
                        this._isInFlightTested = this.getParameter(this.getCeciFactory(), expected, name, "ISINFLIGHTTESTED");
                        if (this._isInFlightTested == null) {
                            this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_PARAMETER", expected), this.getLocator()));
                        }
                    }
                }
            }
        } else if ("SUBTREE".equals(name)) {
            this._subtreeLink = this.getAttribute(attrs, "NAME");
            this._isUnlink = this.getAttribute(attrs, "ISUNLINKSUBTREE");
            this._isDSF = this.getAttribute(attrs, "DSF") != null ? Boolean.parseBoolean(this.getAttribute(attrs, "DSF")) : false;
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._lawHandler != null && this._lawHandler.endAction(name, attrs, txt)) {
            this._law = this._lawHandler.getLaw();
            Law modifier = this._lawHandler.getModifier();
            if (modifier != null) {
                this._law.setModifierLaw(modifier);
            }
            return false;
        }
        if ("CHILD".equals(name)) {
            this._children.add(txt);
            return false;
        }
        return "EVENT".equals(name);
    }

    static {
        INDEX_GATES.put("AND", FTDefinition.Type.AND);
        INDEX_GATES.put("NAND", FTDefinition.Type.NAND);
        INDEX_GATES.put("OU", FTDefinition.Type.OR);
        INDEX_GATES.put("NOR", FTDefinition.Type.NOR);
        INDEX_GATES.put("XOR", FTDefinition.Type.XOR);
        INDEX_GATES.put("NXOR", FTDefinition.Type.NXOR);
        INDEX_GATES.put("NOT", FTDefinition.Type.NOT);
        INDEX_GATES.put("ITE", FTDefinition.Type.ITE);
        INDEX_GATES.put("N", FTDefinition.Type.KOFN);
    }

    public class Attribute {
        private String _nameAttr;
        private String _valueAttr;

        public String getName() {
            return this._nameAttr;
        }

        public String getValue() {
            return this._valueAttr;
        }

        public Attribute(String name, String value) {
            this._nameAttr = name;
            this._valueAttr = value;
        }

        public String toString() {
            return this._nameAttr + " with value: " + this._valueAttr;
        }
    }
}

