/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class SA51LawHandler
extends AbstractSA51Handler
implements SA51Constant {
    private String _lawName;
    private List<Param> _listParams;
    private Law _modifier;
    private CLawManager _lawManager = new CLawManager(null);
    private LawManager _paramLawManager = this._lawManager.getParameterManager();
    private LawManager _modifLawManager = this._lawManager.getModifierManager();

    public SA51LawHandler(String s, SA51Handler handler) {
        super(handler);
        this._listParams = new ArrayList<Param>();
        this._lawName = s;
    }

    public Law getLaw() {
        int lawIndx = SA51Utils.INDEX_LAWS.get(this._lawName);
        Law law = new Law(lawIndx, this._lawManager);
        int i = 0;
        for (Param p : this._listParams) {
            law.setParamAt(i, p);
            ++i;
        }
        this._listParams.clear();
        return law;
    }

    public Law getModifier() {
        return this._modifier;
    }

    public List<Param> getListParam() {
        return this._listParams;
    }

    public String getLawName() {
        return this._lawName;
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if ("VALUE_PARAMETER".equals(name)) {
            ParamValue param = new ParamValue(null, this.getNumericalAttribute(attrs, "VALUE", 1).doubleValue());
            this._listParams.add(param);
        } else if ("LOGNORMAL".equals(name)) {
            Law law = new Law(0, this._paramLawManager);
            law.setParamAt(0, new ParamValue(null, this.getNumericalAttribute(attrs, "MEAN", 1).doubleValue()));
            law.setParamAt(1, new ParamValue(null, this.getNumericalAttribute(attrs, "ERROR", 1).doubleValue()));
            ParamLaw param = new ParamLaw(null, law);
            this._listParams.add(param);
        } else if ("UNIFORM".equals(name)) {
            Law law = new Law(1, this._paramLawManager);
            law.setParamAt(0, new ParamValue(null, this.getNumericalAttribute(attrs, "MIN", 1).doubleValue()));
            law.setParamAt(1, new ParamValue(null, this.getNumericalAttribute(attrs, "MAX", 1).doubleValue()));
            ParamLaw param = new ParamLaw(null, law);
            this._listParams.add(param);
        } else if ("BOUND".equals(name)) {
            Law law = new Law(0, this._modifLawManager);
            law.setParamAt(0, new ParamValue(null, this.getNumericalAttribute(attrs, "BEGIN", 1).doubleValue()));
            law.setParamAt(1, new ParamValue(null, this.getNumericalAttribute(attrs, "DURATION", 1).doubleValue()));
            this._modifier = law;
        } else if ("PARAMETER_REF".equals(name)) {
            ParamRef paramRef = (ParamRef)this.getParameter(this.getCeciFactory(), this.getAttribute(attrs, "VALUE"), name, "VALUE");
            this._listParams.add(paramRef);
        } else if ("EXT_LINK_PARAM".equals(name)) {
            DBFolder fmeaFolder = SA51LawHandler.getExternalRefFolder(this.getCeciFactory(), this.getAttribute(attrs, "FMEA_PATH"));
            ParamFMEA paramFMEA = new ParamFMEA(null, fmeaFolder);
            paramFMEA.setDefineAttribute(this.getAttribute(attrs, "FMEA_ATTRIBUTE_ID"));
            paramFMEA.setDefineEntity(this.getAttribute(attrs, "FMEA_ENTITY_ID"));
            paramFMEA.setNameAttribute(this.getAttribute(attrs, "FMEA_ATTRIBUTE_NAME"));
            paramFMEA.setNameEntity(this.getAttribute(attrs, "FMEA_ENTITY_NAME"));
            paramFMEA.setValueAttribute(this.getNumericalAttribute(attrs, "FMEA_ATTRIBUTE_VALUE", 1).doubleValue());
            paramFMEA.setValueEntity(this.getAttribute(attrs, "FMEA_ENTITY_VALUE"));
            this._listParams.add(paramFMEA);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        return SA51Utils.INDEX_LAWS.get(name) != null;
    }

    public static DBFolder getExternalRefFolder(CECFactory _cecFactory, String s) {
        String[] split = s.split("/");
        DBFolder dbFold = _cecFactory.createFolderDAO().getRootID("PROJECTS");
        for (String path : split) {
            dbFold = dbFold.findChild(path);
            assert (dbFold != null) : "A partir de ce moment, on a DEJA instancie les FMEA. Le FMEA_PATH NE doit PAS pointer sur un DBFolder NULL.";
        }
        return dbFold;
    }
}

