/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ftp10.FtpConstant;
import com.dassault.cecilia.io.ftp10.FtpException;
import com.dassault.cecilia.io.ftp10.FtpGenericModelTableReader;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public abstract class FtpAbsTableReader
implements FtpConstant {
    private static String PACKAGE_PATH = FtpAbsTableReader.class.getPackage().getName().replace('.', File.separatorChar);
    private final FtpHandler _handler;
    private final Table _table;
    protected final List<String> _varsNames;
    private DBLogs _logs;
    private int _currentRow;

    public FtpAbsTableReader(FtpHandler handler, Database base) throws IOException {
        Table t = base.getTable(this.getIDTable());
        if (t == null) {
            t = base.getTable("FT " + this.getIDTable());
        }
        this._table = t;
        this._handler = handler;
        this._varsNames = new ArrayList<String>();
        this._currentRow = 0;
    }

    protected abstract void readLine(Row var1) throws FtpException;

    protected abstract String getIDTable();

    public void readTable() throws FtpException {
        if (this._table == null) {
            return;
        }
        for (Row row : this._table) {
            this._logs = new DBLogs();
            this.incrRow();
            this.readLine(row);
        }
    }

    protected final CeciliaFactory getFactory() {
        return this._handler.getFactory();
    }

    protected final Date getCurrentDate() {
        return this._handler.getCurrentDate();
    }

    protected final DBLogs getLogs() {
        return this._logs;
    }

    protected final void checkConflict(String nameVar) throws FtpException {
        if (this._varsNames.contains(nameVar)) {
            String messError = this.createMessWithLocator(ResMsgFtp.msgFormat("FTP_ERROR_SAME_NAMES", nameVar));
            this.displayMessage(Level.SEVERE, messError);
            throw new FtpException(messError);
        }
        this._varsNames.add(nameVar);
    }

    protected final void addLog(DBLogs.DBLevel level, String message) {
        this.getLogs().addLog(this.getCurrentDate(), this.getLogin(), level, message);
    }

    protected final String createMessWithLocator(String mess) {
        return ResMsgFtp.msgFormat("FTP_LOCATOR", mess, this.getIDTable(), this._currentRow);
    }

    protected final void displayMessage(Level level, String message) {
        this._handler.logMessage(level, message);
    }

    protected final String getLogin() {
        return this._handler.getLogin();
    }

    protected final void incrRow() {
        ++this._currentRow;
    }

    protected final DBFolder createNewDBFolder(DBFolder parent, String name, String descr, int flags) {
        List<DBFolder> children = parent.getChildren();
        if (children != null) {
            for (DBFolder child : parent.getChildren()) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        DBFolder folder = new DBFolder(this._handler.getCounterIncr());
        folder.setName(name);
        folder.setDescription(descr);
        folder.setDateCreate(this._handler.getCreateDate());
        folder.setDateModify(this._handler.getUpdateDate());
        folder.setFlags(flags);
        this.linkDBFolder(parent, folder);
        return folder;
    }

    protected final void linkDBFolder(DBFolder parent, DBFolder child) {
        if (parent.getChildren() == null) {
            parent.setChildren(new ArrayList<DBFolder>());
        }
        parent.getChildren().add(child);
        child.setParent(parent);
    }

    protected String getFilePathForLog() {
        String filePath = this._handler.getFilePath();
        if (Boolean.getBoolean("PROP_JUNIT_FTP")) {
            int pos = filePath.indexOf(PACKAGE_PATH);
            if (pos >= 0) {
                filePath = filePath.substring(pos);
            }
            filePath = filePath.replace('\\', '/');
        }
        return filePath;
    }

    protected void addObjectFromFolder(DBFolder folder, DBWrap wrap, DBLogs logs, String msgLog) {
        List<DBLogs.Log> listLogs;
        DBObject obj = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(obj);
        wrap.setFolder(folder);
        this.addDefaultProperty(obj, "1", this.getLogin());
        wrap.getLogs().addLog(this.getCurrentDate(), this.getLogin(), DBLogs.DBLevel.FINE, msgLog);
        if (logs != null && (listLogs = logs.getLogs(DBLogs.DBLevel.FINEST)) != null && !listLogs.isEmpty()) {
            for (DBLogs.Log log : listLogs) {
                wrap.getLogs().addLog(log);
            }
        }
        DBObjModel dbObjModel = wrap.writeDBObjModel(false);
        obj.addModel(new DBObjModelBytes(dbObjModel));
        DBObjModel dbObjLogsModel = wrap.writeDBObjLogs(false);
        obj.addModel(new DBObjModelBytes(dbObjLogsModel));
        this.getFactory().createObjectDAO().putWrap(obj, wrap.getCopy());
    }

    private void addDefaultProperty(DBObject dbObject, String release, String owner) {
        DBObjProperty dbProperty;
        if (release != null && !release.isEmpty()) {
            dbProperty = new DBObjProperty().setName("object.release").setType("Long").setValue(release);
            dbObject.addProperty(dbProperty);
        }
        if (owner != null && !owner.isEmpty()) {
            dbProperty = new DBObjProperty().setName("object.creator").setType("String").setValue(owner);
            dbObject.addProperty(dbProperty);
        }
    }

    protected Law createLaw(String varName, Row row) {
        String lawStr = this.getLawValue(row);
        Law law = null;
        Param[] params = new Param[3];
        if (lawStr == null) {
            String warnMess = ResMsgFtp.msgFormat("FTP_WARN_LAW_UNKNOWN", varName);
            this.displayMessage(Level.INFO, warnMess);
            this.addLog(DBLogs.DBLevel.INFO, warnMess);
        } else if (lawStr.equalsIgnoreCase("Rate")) {
            params[0] = this.createParam(0, row, TypeParam.RATE);
            params[2] = this.createParam(1, row, TypeParam.RATE);
            if (params[2] instanceof ParamValue && ((ParamValue)params[2]).getValue() == 0.0) {
                law = this.getFactory().getLawManager().createLaw(0);
            } else {
                params[1] = params[0];
                params[0] = new ParamValue(TypeParam.PROBABILITY, 0.0);
                law = this.getFactory().getLawManager().createLaw(2);
            }
        } else if (lawStr.equalsIgnoreCase("Dormant")) {
            law = this.getFactory().getLawManager().createLaw(9);
            params[0] = this.createParam(0, row, TypeParam.RATE);
            params[1] = this.createParam(1, row, TypeParam.DELAY);
            params[2] = this.createParam(2, row, TypeParam.DELAY);
        } else if (lawStr.equalsIgnoreCase("Fixed")) {
            law = this.getFactory().getLawManager().createLaw(1);
            params[0] = this.createParam(0, row, TypeParam.PROBABILITY);
            Param intens = this.createParam(1, row, TypeParam.RATE);
            if (intens != null && (intens instanceof ParamLaw || intens instanceof ParamValue && (Double)intens.getValue() != 0.0)) {
                String warnMess = ResMsgFtp.msgFormat("FTP_WARN_CST_LAW_TWO_PARAMS", varName);
                this.addLog(DBLogs.DBLevel.WARNING, warnMess);
                this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
            }
        } else if (lawStr.equalsIgnoreCase("Time at Risk")) {
            law = this.getFactory().getLawManager().createLaw(8);
            params[0] = this.createParam(0, row, TypeParam.RATE);
            params[1] = this.createParam(1, row, TypeParam.DELAY);
            params[2] = new ParamValue(TypeParam.PROBABILITY, 0.0);
        } else if (lawStr.equalsIgnoreCase("Weib")) {
            law = this.getFactory().getLawManager().createLaw(4);
            params[0] = this.createParam(0, row, TypeParam.FACTOR);
            params[1] = this.createParam(1, row, TypeParam.FACTOR);
            params[2] = this.createParam(2, row, TypeParam.PROBABILITY);
        }
        if (law != null) {
            for (int i = 0; i < law.getNbrParam(); ++i) {
                law.setParamAt(i, params[i]);
            }
        }
        return law;
    }

    protected Param createParam(int idx, Row row, TypeParam cecType) {
        Param paramDistrib;
        Param param = null;
        double paramValue = this.getParamAt(row, idx * 2);
        String genericParamStr = row.getString("Generic Parameters");
        if (genericParamStr != null && !genericParamStr.isEmpty()) {
            ParamRef paramGeneric = null;
            for (String genericParamValue : genericParamStr.split("\n")) {
                paramGeneric = this.getGenericParam(genericParamValue, cecType, paramValue);
                if (paramGeneric == null) continue;
                param = paramGeneric;
                break;
            }
        }
        if (param == null) {
            param = new ParamValue(cecType, paramValue);
        }
        if ((paramDistrib = this.createLawDistrib(this.getModelDistribution(row, idx), cecType, param, this.getParamAt(row, idx * 2 + 1))) != null) {
            return paramDistrib;
        }
        return param;
    }

    protected Param createLawDistrib(String modelDistrib, TypeParam cecType, Param param1, Double param2Value) {
        if (modelDistrib == null) {
            return null;
        }
        if (modelDistrib.isEmpty()) {
            return null;
        }
        if (param2Value == null) {
            return null;
        }
        if (param2Value == 0.0) {
            return null;
        }
        ParamLaw paramDistrib = null;
        if (modelDistrib.equalsIgnoreCase("Uniform")) {
            Law law = this.getFactory().getLawManager().getParameterManager().createLaw(1);
            law.setParamAt(0, param1);
            law.setParamAt(1, new ParamValue(cecType, param2Value));
            paramDistrib = new ParamLaw(cecType, law);
        } else if (modelDistrib.equalsIgnoreCase("Lognormal")) {
            Law law = this.getFactory().getLawManager().getParameterManager().createLaw(0);
            law.setParamAt(0, param1);
            law.setParamAt(1, new ParamValue(TypeParam.FACTOR, param2Value));
            paramDistrib = new ParamLaw(cecType, law);
        } else if (modelDistrib.equalsIgnoreCase("Normal")) {
            Law law = this.getFactory().getLawManager().getParameterManager().createLaw(2);
            law.setParamAt(0, param1);
            law.setParamAt(1, new ParamValue(TypeParam.FACTOR, param2Value));
            paramDistrib = new ParamLaw(cecType, law);
        }
        return paramDistrib;
    }

    protected final ParamRef getGenericParam(String genericParam, TypeParam type, double value) {
        DBFolder genericParamFolder = this.getFactory().createFolderDAO().getRootID("LAW_PARAMETERS");
        DBFolder faultTreeParamFolder = genericParamFolder.findChild("FTParameters");
        if (faultTreeParamFolder == null) {
            this.displayMessage(Level.SEVERE, ResMsgFtp.msgFormat("FTP_ERROR_NO_PARAMETERS_TABLE", genericParam));
            return null;
        }
        DBFolder genericModelFolder = faultTreeParamFolder.findChild(genericParam);
        if (genericModelFolder == null) {
            genericModelFolder = faultTreeParamFolder.findChild(DBFactory.convertName(genericParam, DBFolder.Family.PARAMETER));
        }
        if (genericModelFolder == null) {
            this.displayMessage(Level.SEVERE, ResMsgFtp.msgFormat("FTP_ERROR_PARAM_NOT_FOUND", genericParam));
            return null;
        }
        DBFolder genericVersFolder = genericModelFolder.findChild("1");
        DBWrap wrap = this.getFactory().findOrCreateWrap(genericVersFolder);
        if (wrap == null) {
            this.displayMessage(Level.SEVERE, ResMsgFtp.msgFormat("FTP_ERROR_PARAM_NOT_FOUND", genericParam));
            return null;
        }
        assert (wrap instanceof DBParam);
        DBParam dbParam = (DBParam)wrap;
        if ((Double)dbParam.getValue().getValue() != value) {
            return null;
        }
        return new ParamRef(type, genericVersFolder);
    }

    protected final String getValidName(String originalName, DBFolder.Family family) throws FtpException {
        String result = new String(originalName);
        if (!DBFactory.verifyName(originalName, family)) {
            if (Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName")) {
                if (!DBFactory.verifyName(result = DBFactory.convertName(result, family), family)) {
                    String messErr = ResMsgFtp.msgFormat("FTP_ERROR_NOT_CORRECT_NAME", originalName);
                    this.displayMessage(Level.SEVERE, messErr);
                    throw new FtpException(messErr);
                }
                String warnMess = ResMsgFtp.msgFormat("FTP_WARN_BAD_FORMAT_PARAM", originalName, result);
                this.displayMessage(Level.WARNING, warnMess);
                this.addLog(DBLogs.DBLevel.WARNING, warnMess);
            } else {
                String messErr = ResMsgFtp.msgFormat("FTP_ERROR_ILLEGAL_CHAR", originalName, DBFolderResources.getTypeModel(family, (short)2));
                this.displayMessage(Level.SEVERE, messErr);
                throw new FtpException(messErr);
            }
        }
        return result;
    }

    protected final String getValidDesc(String originalDesc, String nameVar) {
        String result = originalDesc;
        if (result != null && !DBFactory.verifyDescription(result = result.trim())) {
            String warnMess = ResMsgFtp.msgFormat("FTP_WARN_COMMENT_TOO_LONG", nameVar);
            this.addLog(DBLogs.DBLevel.WARNING, warnMess);
            this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
            result = result.substring(0, 1023);
        }
        return result;
    }

    protected double getParamAt(Row row, int idx) {
        switch (idx) {
            case 0: {
                return row.getDouble("Failure Model Parameter 0");
            }
            case 1: {
                return row.getDouble("Failure Model Parameter 1");
            }
            case 2: {
                return row.getDouble("Failure Model Parameter 2");
            }
            case 3: {
                return row.getDouble("Failure Model Parameter 3");
            }
            case 4: {
                return row.getDouble("Failure Model Parameter 4");
            }
            case 5: {
                return row.getDouble("Failure Model Parameter 5");
            }
        }
        return Double.NaN;
    }

    protected DBModelLaw getModelLaw(Row row) {
        String genericModelOn = row.getString("Use Generic Model");
        if (!genericModelOn.equals("On")) {
            return null;
        }
        String genericName = row.getString("Generic Model Name");
        DBFolder tmpFolder = this.getFactory().createFolderDAO().getRootID("LAW_MODELS");
        ArrayList<String> listFields = new ArrayList<String>();
        listFields.addAll(FtpGenericModelTableReader.FT_MODELLAWS_ID);
        listFields.add(genericName);
        listFields.add("1");
        Iterator iteratorField = listFields.iterator();
        while (iteratorField.hasNext()) {
            if ((tmpFolder = tmpFolder.findChild((String)iteratorField.next())) != null) continue;
            this.displayMessage(Level.SEVERE, this.createMessWithLocator("Can't find the law '" + genericName + "'."));
            this.addLog(DBLogs.DBLevel.ERROR, "Can't find the law '" + genericName + "'.");
            return null;
        }
        IWrap wrap = this.getFactory().createObjectDAO().getWrap(tmpFolder.getObject());
        assert (wrap instanceof DBModelLaw);
        DBModelLaw modelLaw = (DBModelLaw)wrap;
        return modelLaw;
    }

    protected String getModelDistribution(Row row, int idx) {
        if (idx == 0) {
            return row.getString("Failure Model Distribution 0");
        }
        if (idx == 1) {
            return row.getString("Failure Model Distribution 1");
        }
        return row.getString("Failure Model Distribution 2");
    }

    protected String getLawValue(Row row) {
        return row.getString("Failure Model Type");
    }
}

