/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ftp10.FtpAbsTableReader;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class FtpCCFTableReader
extends FtpAbsTableReader {
    public FtpCCFTableReader(FtpHandler handler, Database base) throws IOException {
        super(handler, base);
    }

    @Override
    public void readLine(Row row) {
        String name = row.getString("Name");
        if (name == null) {
            return;
        }
        String typeCCF = row.getString("Type");
        if (typeCCF == null) {
            this.displayMessage(Level.SEVERE, this.createMessWithLocator(ResMsgFtp.msgFormat("FTP_ERROR_CCF_NULL_TYPE", name)));
            return;
        }
        String descr = this.getValidDesc(row.getString("Description"), name);
        DBFolder ccfRoot = this.getFactory().createFolderDAO().getRootID("CCF_MODELS");
        DBFolder modelFolder = this.createNewDBFolder(ccfRoot, name, null, DBFolder.createFlagsModel(DBFolder.Family.CCF_MODEL, (short)0, (short)0));
        DBFolder versFolder = this.createNewDBFolder(modelFolder, "1", descr, DBFolder.createFlagsVersion(DBFolder.Family.CCF_MODEL, (short)0, (short)0));
        CCF ccf = new CCF(versFolder);
        CCF.CCFType type = this.getTypeCCF(typeCCF);
        ccf.setType(type);
        double[] factors = this.createFactors(row, type);
        ccf.setFactors(factors);
        ccf.setLaw(this.createLaw(name, row));
        this.addObjectFromFolder(versFolder, ccf, this.getLogs(), ResMsgFtp.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getFilePathForLog()));
    }

    private CCF.CCFType getTypeCCF(String ccfTypeName) {
        switch (ccfTypeName) {
            case "Alpha": {
                return CCF.CCFType.ALPHA;
            }
            case "Beta": {
                return CCF.CCFType.BETA;
            }
            case "MGL": {
                return CCF.CCFType.MGL;
            }
        }
        String warnMess = ResMsgFtp.msgFormat("FTP_ERROR_CCF_UNKNOWN_TYPE", ccfTypeName);
        this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
        this.addLog(DBLogs.DBLevel.WARNING, ResMsgFtp.msgFormat("FTP_ERROR_CCF_UNKNOWN_TYPE", ccfTypeName));
        return CCF.CCFType.ALPHA;
    }

    private double[] createFactors(Row row, CCF.CCFType type) {
        if (type == CCF.CCFType.ALPHA || type == CCF.CCFType.MGL) {
            ArrayList<Double> listDouble = new ArrayList<Double>();
            for (String field : ALL_FACTORS) {
                double value = row.getDouble(field);
                listDouble.add(value);
            }
            double[] arrayDouble = new double[listDouble.size()];
            for (int i = 0; i < listDouble.size(); ++i) {
                arrayDouble[i] = (Double)listDouble.get(i);
            }
            return arrayDouble;
        }
        double[] param = new double[]{row.getDouble("Factor 0")};
        return param;
    }

    @Override
    protected Law createLaw(String varName, Row row) {
        DBModelLaw genericLaw = this.getModelLaw(row);
        if (genericLaw != null) {
            return genericLaw.getLaw();
        }
        return super.createLaw(varName, row);
    }

    @Override
    public String getIDTable() {
        return "Common Cause Failures";
    }
}

