/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.error.DlgDisplayMsg;
import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.ftp10.FtpCCFTableReader;
import com.dassault.cecilia.io.ftp10.FtpDatesReader;
import com.dassault.cecilia.io.ftp10.FtpEventTableReader;
import com.dassault.cecilia.io.ftp10.FtpException;
import com.dassault.cecilia.io.ftp10.FtpGateTableReader;
import com.dassault.cecilia.io.ftp10.FtpGenericModelTableReader;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.PropertyMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FtpHandler {
    public static Logger _LOG = Logger.getLogger(FtpHandler.class.getPackage().getName());
    private final CeciliaFactory _cecFactory;
    private final File _mdbFile;
    private final DBFolder _root;
    private final CAppl _appl;
    private final String _login;
    private final List<Msg> _msgs;
    private static final Date _currentDate = new Date(Boolean.getBoolean("PROP_JUNIT_FTP") ? 1472594500000L : System.currentTimeMillis());
    private Date _updateDate;
    private Date _createDate;
    private int _cpt;

    public FtpHandler(CAppl appl, File mdbFile, DBFolder root) {
        this(appl, mdbFile, root, appl.getDBUser().getLogin());
    }

    public FtpHandler(CAppl appl, File mdbFile, DBFolder root, String login) {
        this._appl = appl;
        this._cecFactory = ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO ? new DemoLimitedFactory(appl, new DAOImportXmlFactory()) : new CeciliaFactory(appl, new DAOImportXmlFactory());
        this._mdbFile = mdbFile;
        this._cpt = 1;
        this._root = root;
        this._login = login;
        this._msgs = new ArrayList<Msg>();
    }

    public final int getCounterIncr() {
        return this._cpt++;
    }

    public final CeciliaFactory getFactory() {
        return this._cecFactory;
    }

    public final void logMessage(Level level, String mess) {
        _LOG.log(level, mess);
        MsgType type = MsgType.FATAL;
        if (level == Level.INFO) {
            type = MsgType.INFO;
        } else if (level == Level.WARNING) {
            type = MsgType.WARNING;
        } else if (level == Level.SEVERE) {
            type = MsgType.ERROR;
        }
        this._msgs.add(new Msg(mess, type));
    }

    public final Date getCurrentDate() {
        return _currentDate;
    }

    public final Date getCreateDate() {
        return this._createDate;
    }

    public final Date getUpdateDate() {
        return this._updateDate;
    }

    public final String getLogin() {
        return this._login;
    }

    public final String getFilePath() {
        return this._mdbFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readFile() {
        Database base = null;
        try {
            PropertyMap map;
            base = new DatabaseBuilder(this._mdbFile).setReadOnly(true).open();
            if (_LOG.isLoggable(Level.FINEST) && (map = base.getDatabaseProperties()) != null) {
                StringBuilder sb = new StringBuilder();
                for (PropertyMap.Property prop : map) {
                    sb.append(prop.getName());
                    sb.append('(');
                    sb.append(prop.getType());
                    sb.append(") = ");
                    sb.append(prop.getValue());
                    sb.append("\n");
                }
                _LOG.log(Level.FINEST, sb.toString());
            }
            FtpDatesReader datesReader = new FtpDatesReader(base);
            datesReader.readTable();
            Date creationDate = datesReader.getCreationDate();
            Date updateDate = datesReader.getUpdateDate();
            Date date = this._createDate = creationDate != null ? creationDate : _currentDate;
            this._updateDate = updateDate != null ? updateDate : (this._createDate != null ? this._createDate : _currentDate);
            FtpGenericModelTableReader genericModelReader = new FtpGenericModelTableReader(this, base);
            genericModelReader.readTable();
            FtpCCFTableReader ccfReader2 = new FtpCCFTableReader(this, base);
            ccfReader2.readTable();
            FtpEventTableReader eventsReader = new FtpEventTableReader(this, base);
            eventsReader.readTable();
            Map<String, FTVariable> mapNameToEvent = eventsReader.getMapNameToFTVar();
            Map<FTVariable, DBLogs> mapVarToDBLogs = eventsReader.getMapVarToLogs();
            FtpGateTableReader gatesReader = new FtpGateTableReader(this, this._root, base, mapNameToEvent, mapVarToDBLogs);
            gatesReader.readTable();
            gatesReader.generateRoots();
            if (this._msgs.size() > 0 && this._appl.getDAOFactory() != null) {
                DlgDisplayMsg dlg = new DlgDisplayMsg(this._appl.getTopWindow(), false).setMsgs(this._msgs);
                dlg.setTitle(ResMsgCecilia.getString("MENU_IMPORT_FTP") + ": " + this._mdbFile);
                dlg.setModal(true);
                dlg.setLocationRelativeTo(this._appl.getTopWindow());
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    boolean ccfReader2 = false;
                    return ccfReader2;
                }
            }
            boolean dlg = true;
            return dlg;
        }
        catch (FtpException ftpException) {
            JOptionPane.showMessageDialog(this._appl.getTopWindow(), ftpException.getMessage(), ResMsgFtp.getString("FTP_ERROR_DLG_TITLE"), 0);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this._appl.getTopWindow(), ResMsgFtp.getString("FTP_ERROR_EXCEPTION"), ResMsgFtp.getString("FTP_ERROR_DLG_TITLE"), 0);
            _LOG.log(Level.SEVERE, ResMsgFtp.getString("FTP_ERROR_EXCEPTION"), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (base != null) {
                try {
                    base.close();
                }
                catch (Exception e) {
                    _LOG.log(Level.SEVERE, e.getMessage());
                }
            }
        }
    }
}

