/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.io.imports.AbstractCmdImportPrepare;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class CmdImportPrepareOcas51
extends AbstractCmdImportPrepare {
    static Logger _LOG = Logger.getLogger(CmdImportPrepareOcas51.class.getPackage().getName());
    private static Date _dateLastUpdateCecilia = new Date(1472594400000L);
    private String _version;
    private Date _creationDate;
    private String _owner;
    private String _comment;

    public CmdImportPrepareOcas51(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_EXP_CECILIA5_1"), ".exp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DAOFactory readFile(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            OCas51Handler handler = new OCas51Handler(file, this.getAppl());
            InputStream exportIdStream = null;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            LinkedHashMap<String, InputStream> mapPathToIconStream = new LinkedHashMap<String, InputStream>();
            boolean withExport = false;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                String entryName = entry.getName();
                if (entryName.equals("export-id")) {
                    exportIdStream = stream;
                    continue;
                }
                if (entryName.toLowerCase().endsWith(".png") || entryName.toLowerCase().endsWith(".gif") || entryName.toLowerCase().endsWith(".jpg")) {
                    mapPathToIconStream.put(entryName, stream);
                    continue;
                }
                if (entryName.equals("export.xml")) {
                    int len;
                    withExport = true;
                    byte[] buffer = new byte[1024];
                    while ((len = stream.read(buffer)) > -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                    continue;
                }
                if (entry.isDirectory()) continue;
                _LOG.warning("The file " + entry.getName() + " will not be treated.");
            }
            if (!withExport) {
                _LOG.severe("No data to import (no export.xml file)");
                throw new Exception(ResMsgCore.getString("ERROR_OCAS_IMPORT_EMPTY_IMPORT"));
            }
            handler.setCurrentMode(OCas51Handler.Mode.INSTANCIATION);
            this.readExportID(exportIdStream, file.getName());
            OCas51Utils.treatIcons(mapPathToIconStream, handler, this._creationDate);
            this.readXML(new ByteArrayInputStream(outputStream.toByteArray()), handler);
            handler.setCurrentMode(OCas51Handler.Mode.LINKING);
            this.readXML(new ByteArrayInputStream(outputStream.toByteArray()), handler);
            CECFactory cECFactory = handler.getCECFactory();
            return cECFactory;
        }
        catch (Exception e) {
            _LOG.log(Level.FINE, "Error while the parsing of the XML file", e);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), e.getMessage());
            DAOFactory dAOFactory = null;
            return dAOFactory;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_OCAS51");
    }

    private final void readExportID(InputStream stream, String pathName) throws ParseException {
        Scanner scanner = new Scanner(stream);
        scanner.useDelimiter("\n");
        StringBuilder comment = null;
        boolean inComment = false;
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.contains("ocasVersion")) {
                this._version = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                continue;
            }
            if (line.contains("creationDate")) {
                String dateStr = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy hh:mm a");
                try {
                    this._creationDate = dateFormat.parse(dateStr);
                }
                catch (ParseException err) {
                    _LOG.warning("The date " + dateStr + " is not parseable by 'MM/dd/yy hh:mm a'. Trying with 'MM/dd/yy hh:mm'");
                    dateFormat = new SimpleDateFormat("MM/dd/yy hh:mm");
                    try {
                        this._creationDate = dateFormat.parse(dateStr);
                    }
                    catch (ParseException errV2) {
                        _LOG.severe("Can not read the date " + dateStr + ". Unknown date : Replaced by " + _dateLastUpdateCecilia.toString());
                        this._creationDate = _dateLastUpdateCecilia;
                    }
                }
                continue;
            }
            if (line.contains("creationOwner")) {
                this._owner = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                continue;
            }
            if (line.contains("<comment>")) {
                comment = new StringBuilder();
                inComment = true;
                continue;
            }
            if (line.contains("</comment>")) {
                this._comment = comment.toString();
                continue;
            }
            if (!inComment) continue;
            comment.append(line);
            comment.append('\n');
        }
        scanner.close();
        StringBuilder sb = new StringBuilder().append('\n').append("Name of the file: ").append(pathName).append('\n').append("Version of the file: ").append(this._version).append('\n').append("Creation date: ").append(this._creationDate).append('\n').append("Creator: ").append(this._owner).append('\n').append("Comments: ").append(this._comment);
        _LOG.log(Level.FINEST, sb.toString());
    }

    private void readXML(InputStream stream, SAXExtendedHandler parser) throws IOException {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(stream, (DefaultHandler)parser);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = parser.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }
}

