/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.io.imports.MapImport;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.EventQueue;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.table.TableCellRenderer;

public class CmdImportRealise
extends CCmd {
    private static Logger _LOG = Logger.getLogger(CmdImportRealise.class.getPackage().getName());
    JFrame _ctrlOwner;
    DAOObjModel _daoObjModel = null;
    MapImport _mapImport = null;

    public CmdImportRealise(CeciliaAppl appl, JFrame owner, MapImport mapImport) {
        super(appl, owner);
        this._ctrlOwner = owner;
        this._daoObjModel = this.getAppl().getDAOFactory().createObjModelDAO();
        this._mapImport = mapImport;
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    @Override
    protected void firstDo() {
        _LOG.finest("Realise-Import | Beg");
        boolean resultRealise = false;
        try {
            resultRealise = this._mapImport.realiseImport();
        }
        finally {
            if (!this._mapImport.unlockLocalFolder(resultRealise)) {
                _LOG.warning("Probleme lors du deverrouillage des dossiers");
            }
        }
        this.getAppl().getDAOFactory().createObjectDAO().clearWraps();
        this.getAppl().refreshDAOFolder(true);
        if (this._mapImport.withWarnning()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CmdImportRealise.this.displayErrors(CmdImportRealise.this._mapImport.getErrors());
                }
            });
        }
        if (!this._mapImport.withError() && this._mapImport.isChoiceImportPrefs()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        DBPreference pref = CmdImportRealise.this.getAppl().getDAOFactory().createPreferenceDAO().find(CmdImportRealise.this.getAppl().getDBUser(), "Default");
                        CmdImportRealise.this.getAppl().getPlugable().loadPreferencies(new StringReader(pref.getValue()));
                        CmdImportRealise.this.getAppl().getTopWindow().getDlgPreferencies().refreshPanels();
                    }
                    catch (Exception e) {
                        _LOG.log(Level.SEVERE, "Probleme lors de la MaJ des preferences de '" + CmdImportRealise.this.getAppl().getDBUser().getName() + "'", e);
                    }
                }
            });
        }
        _LOG.finest("Realise-Import | End");
    }

    private void displayErrors(List<GeneralError<DBFolder>> errors) {
        JFrame win = this._ctrlOwner;
        DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win){

            @Override
            protected TableCellRenderer getSourceRenderer() {
                return new FolderRenderer().setDisplayPath(true);
            }
        };
        dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_IMPORT"));
        dlg.setErrors(errors);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._ctrlOwner));
        dlg.setVisible(true);
    }
}

