/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.io.imports.MapImport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterInputStream;

public class UtilityConvertID {
    private static Logger _LOG = Logger.getLogger(MapImport.class.getPackage().getName());
    static final Pattern PATTERN_REFID = Pattern.compile("(refID|FMEA_ID)=[\"']([0-9]{1,10})[\"']");

    public static void convertXMLStream(DAOObjModel daoObjModel, DBObjModel importObjMod, DBObjModel localObjMod, Set<Long> relationSources, Map<Long, Long> mapID, boolean excludeID) {
        BufferedReader reader = null;
        InputStream stream = daoObjModel.getBinaryStream(importObjMod);
        if (stream == null) {
            _LOG.severe("Le flux d'importation n'a pas \u00e9t\u00e9 initialis\u00e9 correctement lors de la lecture des donn\u00e9es : " + importObjMod);
            return;
        }
        reader = importObjMod.getFormat().equals("XML") ? new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader((InputStream)new InflaterInputStream(stream), StandardCharsets.UTF_8));
        StringWriter writer = new StringWriter((int)importObjMod.getSize());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("refID") != -1 || line.indexOf("FMEA_ID=") != -1) {
                    line = UtilityConvertID.convertXMLLine(line, relationSources, mapID, excludeID);
                }
                writer.append(line).append("\n");
            }
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme lors de la lecture d'un flux d'importation : " + importObjMod, e);
        }
        byte[] bytes = DAOObjModel.convertToCompressedByte(new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8)));
        localObjMod.setStreamToSave(new ByteArrayInputStream(bytes));
        localObjMod.setSize(bytes.length);
        localObjMod.setFormat("ZML");
    }

    public static boolean findRefIDs(DAOObjModel daoObjModel, DBObjModel importObjMod, Map<Long, String> relationSources) {
        BufferedReader reader = null;
        InputStream stream = daoObjModel.getBinaryStream(importObjMod);
        if (stream == null) {
            _LOG.severe("Le flux d'importation n'a pas \u00e9t\u00e9 initialis\u00e9 correctement lors de la lecture des donn\u00e9es : " + importObjMod);
            return false;
        }
        reader = importObjMod.getFormat().equals("XML") ? new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader((InputStream)new InflaterInputStream(stream), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("refID") == -1 && line.indexOf("FMEA_ID=") == -1) continue;
                UtilityConvertID.findRefIDs(line, relationSources);
            }
            return true;
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme lors de la lecture d'un flux d'importation : " + importObjMod, e);
            return false;
        }
    }

    private static void findRefIDs(String line, Map<Long, String> relationSources) {
        StringBuilder buffer = new StringBuilder(line.length());
        Matcher matcher = PATTERN_REFID.matcher(line);
        int pos = 0;
        while (matcher.find(pos)) {
            buffer.append(line.substring(pos, matcher.start()));
            String valID = matcher.group(2);
            Long importID = Long.decode(valID);
            relationSources.put(importID, line);
            pos = matcher.end();
        }
    }

    public static String convertXMLLine(String line, Set<Long> relationSources, Map<Long, Long> mapID, boolean exclude) {
        StringBuilder buffer = new StringBuilder(line.length());
        Matcher matcher = PATTERN_REFID.matcher(line);
        int pos = 0;
        while (matcher.find(pos)) {
            buffer.append(line.substring(pos, matcher.start()));
            String keyID = matcher.group(1);
            String valID = matcher.group(2);
            Long importID = Long.decode(valID);
            Long localID = mapID.get(importID);
            if (localID == null && exclude) {
                localID = importID;
            }
            if (localID == null) {
                _LOG.warning("convertXMLLine with bad refID : " + importID);
                buffer.append(keyID).append("='-1'");
            } else {
                buffer.append(keyID).append("='").append(localID).append("'");
                relationSources.add(localID);
            }
            pos = matcher.end();
        }
        buffer.append(line.substring(pos));
        return buffer.toString();
    }
}

