/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.io.imports.MapImport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public abstract class DlgImportAbstract
extends JDialogCecilia {
    protected MapImport _mapImport;
    boolean _bCreate = false;
    JScrollPane _scrollPanel;
    private JComponent _ctrlTable;
    JLabel _lblError;
    JLabel _lblImport;
    JLabel _lblConflict;
    JComboBox _ctrlFilterConflict;
    JButton _ctrlNavNext;
    JButton _ctrlNavPrev;
    JButton _ctrlSelectLocal;
    JButton _ctrlSelectImport;
    protected static final int COL_FOLDER = 0;
    protected static final int COL_ERROR = 1;
    protected static final int COL_IMPORT = 2;
    protected static final int COL_LOCAL = 3;
    protected static final int COL_MSG = 4;
    private static final Border noFocusBorder = new EmptyBorder(2, 2, 2, 2);

    public DlgImportAbstract(Window owner, MapImport mapImport) {
        super(owner);
        this._mapImport = mapImport;
        this._scrollPanel = new JScrollPane();
        this._scrollPanel.setPreferredSize(new Dimension(600, 400));
        this._scrollPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.createHeader(), "North");
        centerPanel.add((Component)this._scrollPanel, "Center");
        Component footer = this.createFooter();
        if (footer != null) {
            centerPanel.add(footer, "South");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.pack();
    }

    @Override
    protected boolean verifyParameters() {
        int result;
        if (this._mapImport.getNbrImport() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("ERR_IMPORT_NOIMPORT"), this.getTitle(), 0);
            return false;
        }
        if (this._mapImport.getNbrError() > 0 && (result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("ERR_IMPORT_ERROR"), this.getTitle(), 0)) != 0) {
            return false;
        }
        this._mapImport.getErrors().clear();
        if (!this._mapImport.lockLocalFolders()) {
            if (this._mapImport.withWarnning()) {
                GeneralError<DBFolder> error = this._mapImport.getErrors().get(0);
                StringBuilder sb = new StringBuilder();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), sb.append(error.getMsg()).append(" : ").append(error.getSource().getRefPath()).toString(), this.getTitle(), error.getType().getCode());
            }
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        if (!this._bCreate) {
            this.create();
        }
        super.setVisible(b);
    }

    private synchronized void create() {
        if (this._bCreate) {
            return;
        }
        this._bCreate = true;
        this.init();
        this._lblError.setText(ResMsgObj.msgFormat("LBL_IMPORT_NBR_ERROR", this._mapImport.getNbrError()));
        this._lblImport.setText(ResMsgObj.msgFormat("LBL_IMPORT_NBR_IMPORT", this._mapImport.getNbrImport()));
        this._lblConflict.setText(ResMsgObj.msgFormat("LBL_IMPORT_NBR_CONFLICT", this._mapImport.getNbrConflict(), this._mapImport.getNbrTrueConflict()));
        if (this._mapImport.getNbrError() > 0) {
            this._ctrlFilterConflict.setSelectedItem((Object)FilterChoice.ERRORS);
        } else if (this._mapImport.getNbrTrueConflict() > 0) {
            this._ctrlFilterConflict.setSelectedItem((Object)FilterChoice.TRUECONFLICTS);
        } else {
            this._ctrlFilterConflict.setSelectedItem((Object)FilterChoice.ALL);
        }
        this._ctrlTable = this.createTreeTable();
        this._scrollPanel.setViewportView(this._ctrlTable);
    }

    protected Component createFooter() {
        return null;
    }

    protected Component createHeader() {
        this._lblError = new JLabel(ResMsgObj.msgFormat("LBL_IMPORT_NBR_ERROR", 0));
        this._lblImport = new JLabel(ResMsgObj.msgFormat("LBL_IMPORT_NBR_IMPORT", 0));
        this._lblConflict = new JLabel(ResMsgObj.msgFormat("LBL_IMPORT_NBR_IMPORT", 0, 0));
        this._ctrlFilterConflict = new JComboBox<FilterChoice>(FilterChoice.values());
        this._ctrlFilterConflict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgImportAbstract.this.changeFilter();
            }
        });
        this._ctrlFilterConflict.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FilterChoice) {
                    this.setText(((FilterChoice)((Object)value)).getLabel());
                }
                return this;
            }
        });
        this._ctrlNavNext = new JButton(ResIcoCore.getImageIcon("BUT_DOWN"));
        this._ctrlNavNext.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_NAV_NEXT"));
        this._ctrlNavNext.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlNavNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgImportAbstract.this.goNext();
            }
        });
        this._ctrlNavPrev = new JButton(ResIcoCore.getImageIcon("BUT_UP"));
        this._ctrlNavPrev.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_NAV_PREVIOUS"));
        this._ctrlNavPrev.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlNavPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgImportAbstract.this.goPrev();
            }
        });
        this._ctrlSelectImport = new JButton(ResIcoCore.getImageIcon("IE_IMPORT"));
        this._ctrlSelectImport.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_SELECT_IMPORT"));
        this._ctrlSelectImport.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlSelectImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgImportAbstract.this.doSelectChoice(true);
            }
        });
        this._ctrlSelectLocal = new JButton(ResIcoCore.getImageIcon("LOCAL"));
        this._ctrlSelectLocal.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_SELECT_LOCAL"));
        this._ctrlSelectLocal.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlSelectLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgImportAbstract.this.doSelectChoice(false);
            }
        });
        JPanel header = new JPanel(new GridBagLayout());
        int idx = 0;
        header.add((Component)this._lblError, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._lblImport, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)new JLabel(""), new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add((Component)this._lblConflict, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)new JLabel("Filter"), new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._ctrlFilterConflict, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)new JLabel(""), new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add((Component)this._ctrlNavNext, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._ctrlNavPrev, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._ctrlSelectImport, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._ctrlSelectLocal, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        return header;
    }

    protected abstract JComponent createTreeTable();

    protected abstract void changeFilter();

    protected abstract void goNext();

    protected abstract void goPrev();

    protected abstract List<DBFolder> getSelectedFolders();

    private void doSelectChoice(boolean choiceImport) {
        List<DBFolder> selectFolders = this.getSelectedFolders();
        this._mapImport.selectChoice(selectFolders, choiceImport);
        this.updateLabelImport();
        this._ctrlTable.repaint();
    }

    protected void updateLabelImport() {
        this._lblImport.setText(ResMsgObj.msgFormat("LBL_IMPORT_NBR_IMPORT", this._mapImport.getNbrImport()));
    }

    protected static enum FilterChoice {
        ERRORS(ResMsgObj.getString("LBL_IMPORT_CHOICE_ERRORS")),
        TRUECONFLICTS(ResMsgObj.getString("LBL_IMPORT_CHOICE_TRUECONFLICTS")),
        CONFLICTS(ResMsgObj.getString("LBL_IMPORT_CHOICE_CONFLICTS")),
        ALL(ResMsgObj.getString("LBL_IMPORT_CHOICE_ALL"));

        String _lbl;

        private FilterChoice(String lbl) {
            this._lbl = lbl;
        }

        String getLabel() {
            return this._lbl;
        }
    }

    class CheckImportEditor
    extends DefaultCellEditor {
        public CheckImportEditor(JTable table, int col) {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
            checkBox.setIcon(ResIcoCore.getImageIcon("UNSELECT_PI"));
            switch (col) {
                case 2: {
                    checkBox.setSelectedIcon(ResIcoCore.getImageIcon("IE_IMPORT"));
                    break;
                }
                case 3: {
                    checkBox.setSelectedIcon(ResIcoCore.getImageIcon("LOCAL"));
                    break;
                }
                case 1: {
                    checkBox.setSelectedIcon(ResIcoCore.getImageIcon("ACCESS_NO"));
                }
            }
            checkBox.setBorder(noFocusBorder);
            checkBox.setBackground(table.getBackground());
            checkBox.setForeground(table.getForeground());
        }
    }

    protected class CheckImportRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckImportRenderer(int col) {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(false);
            this.setBorder(noFocusBorder);
            this.setIcon(ResIcoCore.getImageIcon("UNSELECT_PI"));
            switch (col) {
                case 2: {
                    this.setSelectedIcon(ResIcoCore.getImageIcon("IE_IMPORT"));
                    this.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_SELECT_IMPORT"));
                    break;
                }
                case 3: {
                    this.setSelectedIcon(ResIcoCore.getImageIcon("LOCAL"));
                    this.setToolTipText(ResMsgObj.getString("LBL_IMPORT_TOOLTIP_SELECT_LOCAL"));
                    break;
                }
                case 1: {
                    this.setSelectedIcon(ResIcoCore.getImageIcon("ACCESS_NO"));
                }
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(table.isCellEditable(row, column));
            return this;
        }
    }
}

