/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTable;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTableModel;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisonsPanel;
import com.dassault.cecilia.io.imports.ChoiceImport;
import com.dassault.cecilia.io.imports.MapImport;
import com.dassault.cecilia.io.imports.gui.DlgImportAbstract;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DlgImportTree
extends DlgImportAbstract {
    ImportTreeTableModel _modelTTable;
    FolderTreeTable _ctrlTTable;

    public DlgImportTree(Window owner, MapImport mapImport) {
        super(owner, mapImport);
    }

    @Override
    protected JComponent createTreeTable() {
        DAOFolder daoFolder = this._mapImport.getDAOImport().createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID("ROOT");
        this._modelTTable = new ImportTreeTableModel(daoFolder, dbRoot);
        this._ctrlTTable = new ImportTreeTable(this.getOwner(), this._modelTTable, this._mapImport.getMapConflicts());
        TableColumnModel colModel = this._ctrlTTable.getColumnModel();
        block5: for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn tcol = colModel.getColumn(i);
            FolderTreeTableModel.IDCol colID = this._modelTTable.convertColIndexToColID(i);
            switch (colID) {
                case SPECIFIC1: {
                    tcol.setCellRenderer(new DlgImportAbstract.CheckImportRenderer(2));
                    tcol.setCellEditor(new DlgImportAbstract.CheckImportEditor(this._ctrlTTable, 2));
                    continue block5;
                }
                case SPECIFIC2: {
                    tcol.setCellRenderer(new DlgImportAbstract.CheckImportRenderer(3));
                    tcol.setCellEditor(new DlgImportAbstract.CheckImportEditor(this._ctrlTTable, 3));
                    continue block5;
                }
                case SPECIFIC4: {
                    tcol.setCellRenderer(new DlgImportAbstract.CheckImportRenderer(1));
                    tcol.setCellEditor(new DlgImportAbstract.CheckImportEditor(this._ctrlTTable, 1));
                }
            }
        }
        this._ctrlTTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DlgImportTree.this.updateLabelImport();
            }
        });
        this._ctrlTTable.getTree().setRootVisible(false);
        this._ctrlTTable.setPreferredScrollableViewportSize(new Dimension(500, 400));
        DBFolderTreeNode.expandTree(this._ctrlTTable.getTree(), this._modelTTable, dbRoot.getChildren(), -1);
        this._ctrlTTable.getTree().setSelectionRow(-1);
        return this._ctrlTTable;
    }

    @Override
    protected void changeFilter() {
        if (this._modelTTable == null) {
            return;
        }
        DBFolder dbRoot = this._mapImport.getRootImport();
        this._modelTTable.setFolderRoot(dbRoot);
        DBFolderTreeNode.expandTree(this._ctrlTTable.getTree(), this._modelTTable, dbRoot.getChildren(), -1);
        this._ctrlTTable.getTree().setSelectionRow(-1);
    }

    @Override
    protected void goNext() {
        TreeNode next;
        TreeNode current = null;
        int row = this._ctrlTTable.getSelectedRow();
        if (row != -1) {
            current = (TreeNode)this._ctrlTTable.getObjectAtRow(row);
        }
        if (current == null) {
            current = this._modelTTable.getRoot();
        }
        if ((next = this.findNext(current)) != null) {
            this.selectTreeNode(next);
        }
    }

    private TreeNode findInDepth(TreeNode current, boolean first) {
        while (current != null) {
            if (current.isLeaf()) {
                return current;
            }
            if (current.getChildCount() <= 0) break;
            if (first) {
                current = current.getChildAt(0);
                continue;
            }
            current = current.getChildAt(current.getChildCount() - 1);
        }
        return current;
    }

    private TreeNode findNext(TreeNode begin) {
        TreeNode current = begin;
        if (current.isLeaf() || current.getChildCount() == 0) {
            boolean stop = false;
            while (!stop) {
                TreeNode parent = current.getParent();
                if (parent == null) {
                    current = null;
                    stop = true;
                    continue;
                }
                int idx = parent.getIndex(current);
                if (idx >= 0 && idx + 1 < parent.getChildCount()) {
                    current = parent.getChildAt(idx + 1);
                    stop = true;
                    continue;
                }
                current = parent;
            }
            if (current == null) {
                return null;
            }
        }
        if ((current = this.findInDepth(current, true)).isLeaf()) {
            return current;
        }
        return null;
    }

    @Override
    protected void goPrev() {
        TreeNode prev;
        TreeNode current = null;
        int row = this._ctrlTTable.getSelectedRow();
        if (row != -1) {
            current = (TreeNode)this._ctrlTTable.getObjectAtRow(row);
        }
        if (current != null && !current.isLeaf()) {
            boolean stop = false;
            while (!stop) {
                TreeNode parent = current.getParent();
                if (parent == null) {
                    current = null;
                    stop = true;
                    continue;
                }
                int idx = parent.getIndex(current);
                if (idx > 0) {
                    current = parent.getChildAt(idx - 1);
                    stop = true;
                    continue;
                }
                current = parent;
            }
        }
        if (current == null) {
            current = this._modelTTable.getRoot();
        }
        if ((prev = this.findPrev(current)) != null) {
            this.selectTreeNode(prev);
        }
    }

    private TreeNode findPrev(TreeNode begin) {
        TreeNode current = begin;
        if (current.isLeaf() || current.getChildCount() == 0) {
            boolean stop = false;
            while (!stop) {
                TreeNode parent = current.getParent();
                if (parent == null) {
                    current = null;
                    stop = true;
                    continue;
                }
                int idx = parent.getIndex(current);
                if (idx > 0) {
                    current = parent.getChildAt(idx - 1);
                    stop = true;
                    continue;
                }
                current = parent;
            }
            if (current == null) {
                return null;
            }
        }
        if ((current = this.findInDepth(current, false)).isLeaf()) {
            return current;
        }
        return null;
    }

    private void selectTreeNode(TreeNode next) {
        Object[] pathNodes = this._modelTTable.getPathToRoot(next);
        if (pathNodes != null && pathNodes.length > 0) {
            int newRow;
            TreePath treePath = new TreePath(pathNodes);
            TreePath treeParentPath = treePath.getParentPath();
            JTree tree = this._ctrlTTable.getTree();
            if (!tree.isExpanded(treeParentPath)) {
                this._ctrlTTable.expandPath(treeParentPath);
            }
            if ((newRow = tree.getRowForPath(treePath)) != -1) {
                int rowHeight = this._ctrlTTable.getRowHeight();
                Rectangle rectRow = new Rectangle(1, newRow * rowHeight, 2, rowHeight);
                this._ctrlTTable.scrollRectToVisible(rectRow);
                this._ctrlTTable.clearSelection();
                this._ctrlTTable.addRowSelectionInterval(newRow, newRow);
            }
        }
    }

    @Override
    protected List<DBFolder> getSelectedFolders() {
        int[] rows = this._ctrlTTable.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        ArrayList<DBFolder> result = new ArrayList<DBFolder>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            result.add(((DBFolderTreeNode)this._ctrlTTable.getObjectAtRow(rows[i])).getDBFolder());
        }
        return result;
    }

    class ImportTreeTableModel
    extends FolderTreeTableModel {
        public ImportTreeTableModel(DAOFolder daoFolder, DBFolder root) {
            super(daoFolder, root);
        }

        private boolean acceptFolder_rec(DBFolder dbFolder) {
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                return false;
            }
            for (int i = children.size() - 1; i >= 0; --i) {
                if (!this.acceptFolder(children.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptFolder(DBFolder dbFolder) {
            if (dbFolder.isSystem() && dbFolder.getChildren().size() == 0) {
                return false;
            }
            if (dbFolder.isSystem()) {
                return this.acceptFolder_rec(dbFolder);
            }
            switch ((DlgImportAbstract.FilterChoice)((Object)DlgImportTree.this._ctrlFilterConflict.getSelectedItem())) {
                case ERRORS: {
                    return (dbFolder.getExternalFlag() & ChoiceImport.MASK_ERROR) != 0L;
                }
                case CONFLICTS: {
                    return (dbFolder.getExternalFlag() & ChoiceImport.MASK_CONFLICT) != 0L;
                }
                case TRUECONFLICTS: {
                    return (dbFolder.getExternalFlag() & ChoiceImport.MASK_CONFLICT_TRUE) != 0L;
                }
            }
            return super.acceptFolder(dbFolder);
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public FolderTreeTableModel.IDCol convertColIndexToColID(int column) {
            switch (column) {
                case 0: {
                    return FolderTreeTableModel.IDCol.NAME;
                }
                case 1: {
                    return FolderTreeTableModel.IDCol.SPECIFIC4;
                }
                case 2: {
                    return FolderTreeTableModel.IDCol.SPECIFIC1;
                }
                case 3: {
                    return FolderTreeTableModel.IDCol.SPECIFIC2;
                }
                case 4: {
                    return FolderTreeTableModel.IDCol.SPECIFIC3;
                }
            }
            return FolderTreeTableModel.IDCol.ERROR;
        }

        @Override
        protected String getColumnName(FolderTreeTableModel.IDCol colID) {
            switch (colID) {
                case SPECIFIC1: {
                    return ResMsgVoc.getString("VOC_IMPORT");
                }
                case SPECIFIC2: {
                    return ResMsgVoc.getString("VOC_DATABASE");
                }
                case SPECIFIC3: {
                    return ResMsgVoc.getString("VOC_INFORMATIONS");
                }
                case SPECIFIC4: {
                    return ResMsgVoc.getString("VOC_ERROR");
                }
            }
            return super.getColumnName(colID);
        }

        @Override
        protected Class getColumnClass(FolderTreeTableModel.IDCol colID) {
            switch (colID) {
                case SPECIFIC1: {
                    return Boolean.class;
                }
                case SPECIFIC2: {
                    return Boolean.class;
                }
                case SPECIFIC3: {
                    return String.class;
                }
                case SPECIFIC4: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(colID);
        }

        @Override
        protected Object getValueAt(DBFolderTreeNode node, FolderTreeTableModel.IDCol colID) {
            DBFolder dbFolder = node.getDBFolder();
            switch (colID) {
                case SPECIFIC1: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTree.this._mapImport.getChoice(dbFolder).isCheckImport();
                }
                case SPECIFIC2: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTree.this._mapImport.getChoice(dbFolder).isCheckBase();
                }
                case SPECIFIC3: {
                    String msg;
                    if (dbFolder.isSystem()) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    if (DlgImportTree.this._mapImport.isWithConflict(dbFolder)) {
                        sb.append("[Conflict] ");
                    }
                    if ((msg = DlgImportTree.this._mapImport.getChoice(dbFolder).getMsg()) != null) {
                        sb.append(msg);
                    }
                    return sb.toString();
                }
                case SPECIFIC4: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTree.this._mapImport.getChoice(dbFolder).isCheckError();
                }
            }
            return super.getValueAt(node, colID);
        }

        @Override
        public boolean isCellEditable(DBFolderTreeNode node, int row, int column) {
            DBFolder dbFolder = node.getDBFolder();
            FolderTreeTableModel.IDCol colID = DlgImportTree.this._modelTTable.convertColIndexToColID(column);
            switch (colID) {
                case SPECIFIC1: 
                case SPECIFIC2: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    ChoiceImport choice = DlgImportTree.this._mapImport.getChoice(dbFolder);
                    if (choice.isCheckError()) {
                        return false;
                    }
                    if (choice.isFreeze()) {
                        return false;
                    }
                    if (choice.isReadOnly()) {
                        return false;
                    }
                    return choice.isConflict();
                }
                case SPECIFIC4: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    ChoiceImport choice = DlgImportTree.this._mapImport.getChoice(dbFolder);
                    return choice.isCheckError();
                }
                case SPECIFIC3: {
                    return false;
                }
            }
            return super.isCellEditable(node, row, column);
        }

        @Override
        public void setValueAt(Object aValue, DBFolderTreeNode node, int row, int column) {
            FolderTreeTableModel.IDCol colID = DlgImportTree.this._modelTTable.convertColIndexToColID(column);
            if (colID == FolderTreeTableModel.IDCol.SPECIFIC4) {
                return;
            }
            if (colID == FolderTreeTableModel.IDCol.SPECIFIC1 || colID == FolderTreeTableModel.IDCol.SPECIFIC2) {
                DBFolder dbFolder = node.getDBFolder();
                if (!dbFolder.isSystem()) {
                    boolean value = (Boolean)aValue;
                    if (colID != FolderTreeTableModel.IDCol.SPECIFIC1) {
                        value = !value;
                    }
                    DlgImportTree.this._mapImport.selectChoice(Collections.singleton(dbFolder), value);
                    DlgImportTree.this._ctrlTTable.getModel().fireTableRowsUpdated(row, row);
                }
            } else {
                super.setValueAt(aValue, node, row, column);
            }
        }
    }

    public static class ImportTreeTable
    extends FolderTreeTable {
        private final Map<DBFolder, DBComparaisons> _map;
        private final Window _window;
        private CeciliaAction _compareAction;
        private DBComparaisons _currentCompare;

        public ImportTreeTable(Window window, FolderTreeTableModel treeTableModel, Map<DBFolder, DBComparaisons> map) {
            super(treeTableModel);
            this._window = window;
            this._map = map;
            this.init();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.updateActionFromMouseEvent(e);
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        this.doCompare();
                    }
                }
            });
            this.getSelectionModel().addListSelectionListener(e -> this.updateActionFromSelection(e));
        }

        private void init() {
            this._compareAction = new CeciliaAction(ResMsgVoc.getString("VOC_COMPARISON")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.doCompare();
                }
            };
            this._compareAction.setIcon(ResIcoCore.getImageIcon("COMPARISON_FRAME"));
            this._compareAction.setEnabled(false);
            JPopupMenu menu = new JPopupMenu();
            menu.add(this._compareAction);
            this.setComponentPopupMenu(menu);
        }

        @Override
        protected int definePreferredWidth(FolderTreeTableModel.IDCol colID) {
            switch (colID) {
                case NAME: {
                    return 250;
                }
                case SPECIFIC1: 
                case SPECIFIC2: 
                case SPECIFIC4: {
                    return 80;
                }
                case SPECIFIC3: {
                    return 250;
                }
            }
            return super.definePreferredWidth(colID);
        }

        private void updateActionFromMouseEvent(MouseEvent e) {
            this.updateAction(this.rowAtPoint(e.getPoint()), this.columnAtPoint(e.getPoint()));
        }

        private void updateActionFromSelection(ListSelectionEvent e) {
            this.updateAction(this.getSelectedRow(), this.getSelectedColumn());
        }

        private void updateAction(int selectedTableRow, int selectedTableCol) {
            int selectedRow = this.convertRowIndexToModel(selectedTableRow);
            ImportTreeTableModel model = (ImportTreeTableModel)this._model;
            int selectedCol = this.convertColumnIndexToModel(selectedTableCol);
            if (FolderTreeTableModel.IDCol.SPECIFIC3 != model.convertColIndexToColID(selectedCol)) {
                this._compareAction.setEnabled(false);
                this._currentCompare = null;
                return;
            }
            TreePath treePath = this.getTree().getPathForRow(selectedRow);
            DBFolder folder = ((DBFolderTreeNode)treePath.getLastPathComponent()).getDBFolder();
            this._currentCompare = this._map.get(folder);
            this._compareAction.setEnabled(this._currentCompare != null && this._currentCompare.withConflicts());
        }

        private void doCompare() {
            if (this._currentCompare != null && this._currentCompare.withConflicts()) {
                DBComparaisonsPanel.DBComparaisonsDlg dlg = new DBComparaisonsPanel.DBComparaisonsDlg(this._window);
                dlg.setComparisons(this._currentCompare, "Base", "Imported");
                dlg.setVisible(true);
            }
        }
    }
}

