/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ocas51.OCas51ContentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51ProjectHandler;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51ArchitectureHandler
extends OCas51ContentHandler {
    private AltaSynchro _currentSynchro;
    private OCas51ContentHandler _contentHandler;

    public OCas51ArchitectureHandler(OCas51Handler handler, CECFactory factory, OCas51ProjectHandler modelHandler) {
        super(handler, factory, modelHandler);
    }

    @Override
    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._contentHandler != null) {
            this._contentHandler.startAction(name, attrs, startAction);
            return;
        }
        super.startAction(name, attrs, startAction);
        switch (name) {
            case "CONTENT": {
                this._contentHandler = new OCas51ContentHandler(this.getHandler(), this.getCECFactory(), this.getEquipmentHandler());
                this._contentHandler.startAction(name, attrs, startAction);
            }
            case "ARCHITECTURE": {
                String assertionStr = this.getStrFromAttributes(attrs, "ASSERTION", false);
                if (assertionStr == null || assertionStr.isEmpty()) break;
                this.getEquipment().setCode(assertionStr);
                break;
            }
            case "SYNCHRO": {
                String nameSynchro = this.getStrFromAttributes(attrs, "NAME", true);
                String lawSynchro = this.getStrFromAttributes(attrs, "LAW", true);
                int idSynchro = this.getIntValFromAttributes(attrs, "TYPE", true);
                this._currentSynchro = new AltaSynchro(nameSynchro);
                if (lawSynchro != null && !lawSynchro.isEmpty()) {
                    Law law = this.getlawFromStrValue(this.getCECFactory(), lawSynchro);
                    if (law == null) {
                        if (lawSynchro.contains("/")) {
                            lawSynchro = OCas51Utils.revisePathFromBTP(lawSynchro);
                            DBModelLaw modelLaw = OCas51Utils.getModelLawFromStrValue(this.getCECFactory(), lawSynchro);
                            if (modelLaw == null) {
                                DBFolder rootBtpFolder = this.getCECFactory().createFolderDAO().getRootID("LAW_MODELS");
                                DBFolder folder = this.createFolderFromPath(DBFolder.Family.BTP_MODEL, rootBtpFolder, lawSynchro);
                                modelLaw = this.getDefaultModelLaw(folder);
                                this.displayLogs(ResMsgOcas51.msgFormat("MSG_WARNING_BTP_CREATED", lawSynchro));
                            }
                            this._currentSynchro.setModelLaw(modelLaw);
                        } else {
                            String warn = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_LAW", lawSynchro);
                            this.getEquipmentHandler().addWarningToLogs(warn);
                            this.displayLogs(warn);
                            law = this.getCECFactory().getLawManager().createLaw(-1);
                        }
                    }
                    this._currentSynchro.setOccurrence(law);
                }
                this._currentSynchro.setType(OCas51Utils.getTypeSynchFromID(idSynchro));
                break;
            }
            case "TRANSITION": {
                assert (this._currentSynchro != null);
                String nameTransition = this.getStrFromAttributes(attrs, "NAME", true);
                this._currentSynchro.addTransition(nameTransition);
                break;
            }
        }
    }

    @Override
    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._contentHandler != null) {
            if (this._contentHandler.endAction(name, attrs, txt)) {
                this._contentHandler = null;
            }
            return false;
        }
        super.endAction(name, attrs, txt);
        switch (name) {
            case "ARCHITECTURE": {
                return true;
            }
            case "SYNCHRO": {
                assert (this._currentSynchro != null);
                List<AltaSynchro> listSynch = this.getEquipment().getSynchros();
                if (listSynch == null) {
                    listSynch = new ArrayList<AltaSynchro>();
                }
                if (listSynch.contains(this._currentSynchro)) break;
                listSynch.add(this._currentSynchro);
                this.getEquipment().setSynchros(listSynch);
            }
        }
        return false;
    }
}

