/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.mbsa.component.io.LawParserOcas51;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51AttributeHandler;
import com.dassault.cecilia.io.ocas51.OCas51ComponentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Constant;
import com.dassault.cecilia.io.ocas51.OCas51EquipmentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Linker;
import com.dassault.cecilia.io.ocas51.OCas51OperatorHandler;
import com.dassault.cecilia.io.ocas51.OCas51ParameterHandler;
import com.dassault.cecilia.io.ocas51.OCas51ProjectHandler;
import com.dassault.cecilia.io.ocas51.OCas51TypeHandler;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51Handler
extends SAXExtendedHandler
implements OCas51Constant {
    private static String PACKAGE_PATH = OCas51Handler.class.getPackage().getName().replace('.', File.separatorChar);
    private final CECFactory _cecFactory;
    private final OCas51Linker _linker;
    private final File _file;
    private String _login;
    private int _cpt;
    private Date _currentDate = new Date(Boolean.getBoolean("cecilia.junit.ocas51") ? 1472594500000L : System.currentTimeMillis());
    private LawParser _lawParser;
    private Mode _currentMode;
    private AbstractOcas51Handler _currentHandler;
    private boolean _linkedOP = false;

    public OCas51Handler(File f, CAppl appl) {
        this(f, appl, appl.getDBUser().getLogin());
    }

    public OCas51Handler(File f, CAppl appl, String login) {
        this._file = f;
        this._cecFactory = ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO ? new DemoLimitedFactory(appl, new DAOImportXmlFactory()) : new CeciliaFactory(appl, new DAOImportXmlFactory());
        this._cpt = 1;
        this._linker = new OCas51Linker(this);
        this._login = login;
        this._lawParser = new LawParserOcas51(this._cecFactory.getLawManager(), this._cecFactory);
    }

    public final void setCurrentMode(Mode currentMode) {
        this._currentMode = currentMode;
    }

    public final Mode getCurrentMode() {
        return this._currentMode;
    }

    public final CECFactory getCECFactory() {
        return this._cecFactory;
    }

    public final String getLogin() {
        return this._login;
    }

    public final Date getCurrentDate() {
        return this._currentDate;
    }

    public final String getFilePath() {
        return this._file.getAbsolutePath();
    }

    public final LawParser getLawParser() {
        return this._lawParser;
    }

    protected String getFilePathForLog() {
        String filePath = this.getFilePath();
        if (Boolean.getBoolean("cecilia.junit.ocas51")) {
            int pos = filePath.indexOf(PACKAGE_PATH);
            if (pos >= 0) {
                filePath = filePath.substring(pos);
            }
            filePath = filePath.replace('\\', '/');
        }
        return filePath;
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (!this._linkedOP && name.equals("COMPONENT_FAMILY")) {
            this.getLinker().linkElements(OCas51Linker.TypeObject.OPERATOR);
            this._linkedOP = true;
        }
        if (this._currentHandler != null) {
            this._currentHandler.startAction(name, attrs, true);
        } else if (HANDLER_TAG_LIST.contains(name) && this.canGoIntoTag(name)) {
            this._currentHandler = this.getHandler(name);
            if (this._currentHandler != null) {
                this._currentHandler.startAction(name, attrs, true);
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._currentHandler != null && this._currentHandler.endAction(name, attrs, txt)) {
            this._currentHandler = null;
        } else if ("EXPORT".equals(name)) {
            if (this.getCptAndIncrement() == 1) {
                throw new SAXException(ResMsgOcas51.getString("MSG_ERROR_EMPTY_EXPORT"));
            }
            return true;
        }
        return false;
    }

    public int getCptAndIncrement() {
        return this._cpt++;
    }

    public OCas51Linker getLinker() {
        return this._linker;
    }

    public AbstractOcas51Handler getHandler(String tag) {
        switch (tag) {
            case "COMPONENT_FAMILY": {
                return new OCas51ComponentHandler(this, this.getCECFactory());
            }
            case "DEFINE_ATTRIBUTE": {
                return new OCas51AttributeHandler(this, this.getCECFactory());
            }
            case "DEFINE_PARAMETER": {
                return new OCas51ParameterHandler(this, this.getCECFactory());
            }
            case "EQUIPMENT_FAMILY": {
                return new OCas51EquipmentHandler(this, this.getCECFactory());
            }
            case "OPERATOR_FAMILY": {
                return new OCas51OperatorHandler(this, this.getCECFactory());
            }
            case "PROJECT": {
                return new OCas51ProjectHandler(this, this.getCECFactory());
            }
            case "TYPE_FAMILY": {
                return new OCas51TypeHandler(this, this.getCECFactory());
            }
        }
        assert (false) : "Tag inconnu ne se trouvant pas dans la DTD :" + tag;
        return null;
    }

    public final boolean canGoIntoTag(String name) {
        if (this.getCurrentMode() == Mode.LINKING) {
            return name.equals("EQUIPMENT_FAMILY");
        }
        return true;
    }

    public static enum Mode {
        INSTANCIATION,
        LINKING;

    }
}

