/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.operator.OperatorDictionary;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.OCas51Constant;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class OCas51Linker
implements OCas51Constant {
    private final List<IdentifiantType> _listEvents;
    private final List<IdentifiantType> _listObjects;
    private final CECFactory _cecFactoryLinker;

    public OCas51Linker(OCas51Handler oCas51Handler) {
        this._cecFactoryLinker = oCas51Handler.getCECFactory();
        this._listEvents = new ArrayList<IdentifiantType>();
        this._listObjects = new ArrayList<IdentifiantType>();
    }

    public final void addNewLinkToDo(IdentifiantType idObj) {
        this._listEvents.add(idObj);
    }

    public final void addNewObject(String name, TypeObject type, DBFolder folder) {
        IdentifiantType idObj = new IdentifiantType(name, type, folder);
        this._listObjects.add(idObj);
    }

    public final void linkElements(TypeObject type) {
        for (IdentifiantType idObj : this._listEvents) {
            TypeObject typeObj = idObj.getType();
            if (typeObj != type) continue;
            String objName = idObj.getName();
            switch (typeObj) {
                case OPERATOR: {
                    AltaOperator operator = (AltaOperator)idObj.getWrap();
                    OCas51Linker.linkOperator(this._cecFactoryLinker, operator);
                    DBObject obj = operator.getDBFolder().getObject();
                    DBObjModel dbObjModel = operator.writeDBObjModel(false);
                    obj.delModel(obj.getModel("operator"));
                    obj.addModel(new DBObjModelBytes(dbObjModel));
                    operator.getDBFolder().setObject(obj);
                    this._cecFactoryLinker.createObjectDAO().putWrap(obj, operator);
                    break;
                }
                case DBENUM: {
                    IdentifiantType idObjWanted = this.getObj(typeObj, objName);
                    if (idObjWanted == null) break;
                    DBRecord record = (DBRecord)idObj.getWrap();
                    int fieldAt = idObj.getIdxField();
                    DBRecordField.Direction direction = idObj.getDirection();
                    String crossField = idObj.getCrossedField();
                    DBObject objWanted = idObjWanted.getFolder().getObject();
                    DBEnum enumWanted = (DBEnum)this._cecFactoryLinker.createObjectDAO().getWrap(objWanted);
                    DBRecordField oldField = record.removeField(fieldAt);
                    String name = oldField.getName();
                    DBRecordField field = new DBRecordField(name, enumWanted);
                    field.setDirection(direction);
                    field.setCrossField(crossField);
                    record.addField(field, fieldAt);
                    DBObject obj = record.getDBFolder().getObject();
                    DBObjModel dbObjModel = record.writeDBObjModel(false);
                    obj.delModel(obj.getModel("type.structured"));
                    obj.addModel(new DBObjModelBytes(dbObjModel));
                    record.getDBFolder().setObject(obj);
                    this._cecFactoryLinker.createObjectDAO().putWrap(obj, record);
                    OCas51Utils._LOG.finer("The field '" + field + "' of the DBEnum '" + record.getRefPath() + "' has been correctly linked.");
                    break;
                }
            }
        }
    }

    private final IdentifiantType getObj(TypeObject type, String objName) {
        for (IdentifiantType idObj : this._listObjects) {
            String path = this.getPathForV4(objName);
            if (idObj.getType() != type || !idObj.getName().equals(path)) continue;
            return idObj;
        }
        return null;
    }

    private final String getPathForV4(String objName) {
        String result = objName;
        assert (result.contains("/"));
        String[] paths = objName.split("/");
        if (paths.length == 3) {
            return result;
        }
        if (paths.length == 2) {
            String familyFolderString = paths[0];
            StringBuilder sb = new StringBuilder();
            sb.append(familyFolderString).append('/').append(result);
            return sb.toString();
        }
        return result;
    }

    public AltaLink copyLinkWithoutLogs(AltaLink link, CopyUtility util) {
        AltaSub fromSub = link.getFromSub();
        AltaFlow fromFlow = link.getFromFlow();
        if (fromSub != null) {
            AltaSub tmpSub = (AltaSub)util.getRef((Object)fromSub);
            if (tmpSub != null) {
                fromSub = tmpSub;
            }
        } else {
            AltaFlow tmpFlow = (AltaFlow)util.getRef((Object)fromFlow);
            if (tmpFlow != null) {
                fromFlow = tmpFlow;
            }
        }
        AltaSub toSub = link.getToSub();
        AltaFlow toFlow = link.getToFlow();
        if (toSub != null) {
            AltaSub tmpSub = (AltaSub)util.getRef((Object)toSub);
            if (tmpSub != null) {
                toSub = tmpSub;
            }
        } else {
            AltaFlow tmpFlow = (AltaFlow)util.getRef((Object)toFlow);
            if (tmpFlow != null) {
                toFlow = tmpFlow;
            }
        }
        AltaLink copy = new AltaLink(fromSub, fromFlow, toSub, toFlow);
        copy.setFromField(link.getFromField());
        copy.setToField(link.getToField());
        copy.setID(link.getID());
        return copy;
    }

    public static void linkOperator(CECFactory factory, AltaNode node) {
        OperatorDictionary opDic = factory.getOperatorDictionary();
        Set<String> names = opDic.findOperators(node.getCode());
        List<AltaOperatorRef> operatorsInNode = node.getUsedOperator();
        if (operatorsInNode.size() != 0) {
            for (int i = operatorsInNode.size() - 1; i >= 0; --i) {
                AltaOperatorRef operatorId = operatorsInNode.get(i);
                if (names.remove(operatorId.getName())) continue;
                operatorsInNode.remove(operatorId);
            }
        }
        if (names.size() != 0) {
            for (String name : names) {
                Set<DBFolder> folders = opDic.getOperatorsWithName(name);
                DBFolder select = null;
                boolean bMultiValue = false;
                if (folders.size() >= 1) {
                    DBFolder model;
                    if (folders.size() > 1) {
                        bMultiValue = true;
                    }
                    if ((model = folders.iterator().next()).isModel()) {
                        List<DBFolder> children = model.getChildren();
                        if (children == null) {
                            children = factory.createFolderDAO().findChildren(model);
                        }
                        if (children != null && !children.isEmpty()) {
                            if (children.size() > 1) {
                                bMultiValue = true;
                            }
                            select = children.get(children.size() - 1);
                        }
                    }
                }
                if (select == null) {
                    OCas51Utils._LOG.log(Level.WARNING, "Utilisation d'un operateur inconnu '" + name + "' au sein de '" + node.getDBFolder().getRefPath() + "'");
                    continue;
                }
                if (bMultiValue) {
                    OCas51Utils._LOG.log(Level.WARNING, "+sieurs operateurs portent ce meme nom '" + name + "'\nUn choix arbitraire a selectionne l'operateur '" + select.getRefPath() + "'");
                }
                AltaOperatorRef operatorId = new AltaOperatorRef(name, select);
                operatorsInNode.add(operatorId);
            }
        }
    }

    public static class IdentifiantType {
        private final String _name;
        private final TypeObject _typeObject;
        private DBFolder _folder;
        private DBWrap _wrap;
        private DBRecordField.Direction _direction;
        private String _crossedField;
        private int _indexField;

        private IdentifiantType(String name, TypeObject type) {
            this._name = name;
            this._typeObject = type;
        }

        public IdentifiantType(String name, TypeObject type, DBFolder folder) {
            this(name, type);
            this._folder = folder;
        }

        public IdentifiantType(String name, TypeObject type, DBWrap wrap) {
            this(name, type);
            this._wrap = wrap;
        }

        public final String getName() {
            return this._name;
        }

        public final TypeObject getType() {
            return this._typeObject;
        }

        public final DBFolder getFolder() {
            return this._folder;
        }

        public final DBWrap getWrap() {
            return this._wrap;
        }

        public final void setDirection(DBRecordField.Direction direction) {
            this._direction = direction;
        }

        public final DBRecordField.Direction getDirection() {
            return this._direction;
        }

        public final void setCrossedField(String crossedField) {
            this._crossedField = crossedField;
        }

        public final String getCrossedField() {
            return this._crossedField;
        }

        public final int getIdxField() {
            return this._indexField;
        }

        public final void setIdxField(int index) {
            this._indexField = index;
        }
    }

    public static enum TypeObject {
        DBENUM,
        OPERATOR;

    }
}

