/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Linker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51OperatorHandler
extends AbstractOcas51Handler {
    private DBFolder _operatorFamilyFolder;
    private DBFolder _operatorSubFamilyFolder;
    private boolean _isInSubFamilyFolder;
    private boolean _isInOperator;
    private String _law;
    private List<AltaFlow> _listFlows;

    public OCas51OperatorHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "OPERATOR_SUB_FAMILY": {
                this._isInSubFamilyFolder = true;
                break;
            }
            case "OPERANDE": {
                String nameOperande = this.getStrFromAttributes(attrs, "NAME", true);
                String typeOperande = this.getStrFromAttributes(attrs, "TYPE", true);
                AltaType type = this.getTypeFromStr(typeOperande, this.getCECFactory(), !this._isInSubFamilyFolder);
                AltaFlow flow = new AltaFlow(nameOperande, type);
                this._listFlows.add(flow);
                break;
            }
            case "OPERATOR": {
                this._isInOperator = true;
                this._law = this.getStrFromAttributes(attrs, "LAW", true);
                this._listFlows = new ArrayList<AltaFlow>();
                break;
            }
            case "IDENTIFICATION": {
                String nameObj = this.getValidName(this.getStrFromAttributes(attrs, "NAME", true), DBFolder.Family.OPERATOR, name, "NAME");
                if (this._isInOperator) {
                    assert (this._operatorFamilyFolder != null);
                    if (!this._isInSubFamilyFolder) {
                        assert (this._operatorSubFamilyFolder == null || this._operatorSubFamilyFolder.getName().equals(this._operatorFamilyFolder.getName()));
                        if (this._operatorSubFamilyFolder == null) {
                            this._operatorSubFamilyFolder = this.createNewFolder(this._operatorFamilyFolder.getName(), DBFolder.createFlagsFolder(DBFolder.Family.OPERATOR, (short)0, (short)0), true, this._operatorFamilyFolder);
                        }
                    }
                    String version = this.checkValidVers(this.getStrFromAttributes(attrs, "VERSION", false), name, "VERSION");
                    String ownerStr = this.getStrFromAttributes(attrs, "OWNER", true);
                    String releaseStr = this.getStrFromAttributes(attrs, "RELEASE", false);
                    DBFolder folderModelOperator = this._operatorSubFamilyFolder.findChild(nameObj);
                    if (folderModelOperator == null) {
                        folderModelOperator = this.createNewFolder(nameObj, DBFolder.createFlagsModel(DBFolder.Family.OPERATOR, (short)0, (short)0), true, this._operatorSubFamilyFolder);
                    }
                    assert (folderModelOperator != null && folderModelOperator.findChild(version) == null);
                    Date dateCreation = this.getDateFromAttributes(attrs, "CREATION_DATE", true);
                    Date dateUpdate = this.getDateFromAttributes(attrs, "UPDATE_DATE", true);
                    String comment = this.getValidDesc(this.getStrFromAttributes(attrs, "COMMENT", false), true);
                    String idExternLaeticia = this.getStrFromAttributes(attrs, "IDEXTERN_LAETITIA", false);
                    boolean isFrozen = this.getBooleanFromAttributes(attrs, "FREEZE", true);
                    DBFolder folderVersionOperator = this.createNewFolder(version, DBFolder.createFlagsVersion(DBFolder.Family.OPERATOR, (short)0, (short)0), dateCreation == null ? this.getLastUpdateDate() : dateCreation, dateUpdate == null ? this.getLastUpdateDate() : dateUpdate, comment, folderModelOperator);
                    AltaOperator operator = new AltaOperator(folderVersionOperator);
                    operator.setCode(this._law);
                    AltaFlow flowToRemove = null;
                    for (AltaFlow flow : this._listFlows) {
                        if (!flow.getName().equals(operator.getName())) continue;
                        flowToRemove = flow;
                        operator.setType(flow.getType());
                        break;
                    }
                    this._listFlows.remove(flowToRemove);
                    operator.setFlows(this._listFlows);
                    this.addObjectFromFolder(folderVersionOperator, operator, releaseStr, ownerStr, idExternLaeticia, isFrozen);
                    if (this._law == null || this._law.isEmpty()) break;
                    this.getLinker().addNewLinkToDo(new OCas51Linker.IdentifiantType(nameObj, OCas51Linker.TypeObject.OPERATOR, operator));
                    break;
                }
                if (this._isInSubFamilyFolder) {
                    assert (this._operatorFamilyFolder != null);
                    this._operatorSubFamilyFolder = this.createNewFolder(nameObj, DBFolder.createFlagsFolder(DBFolder.Family.OPERATOR, (short)0, (short)0), true, this._operatorFamilyFolder);
                    break;
                }
                this._operatorFamilyFolder = this.createNewFolder(nameObj, DBFolder.createFlagsFolder(DBFolder.Family.OPERATOR, (short)0, (short)0), true, this.getCECFactory().createFolderDAO().getRootID("OPERATOR_FAMILIES"));
                break;
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "OPERATOR_FAMILY": {
                return true;
            }
            case "OPERATOR_SUB_FAMILY": {
                this._isInSubFamilyFolder = false;
                break;
            }
            case "OPERATOR": {
                this._isInOperator = false;
            }
        }
        return false;
    }
}

