/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.OCas51ArchitectureHandler;
import com.dassault.cecilia.io.ocas51.OCas51EquipmentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51ProjectHandler
extends OCas51EquipmentHandler {
    private Map<AltaType, AltaColor.ColorMap> _mapTypeToColors;
    private Map<String, Color> _mapValueTypeToColor;
    private AltaType _currentType;

    public OCas51ProjectHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
    }

    @Override
    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._currentHandler != null) {
            this._currentHandler.startAction(name, attrs, startAction);
            return;
        }
        super.startAction(name, attrs, startAction);
        switch (name) {
            case "ARCHITECTURE": {
                this._currentHandler = new OCas51ArchitectureHandler(this.getHandler(), this.getCECFactory(), this);
                this._currentHandler.startAction(name, attrs, startAction);
                break;
            }
            case "COLOR": {
                if (!this._isInObject) {
                    this.createModel();
                    this._isInObject = true;
                    this._isInSubFamilyFolder = false;
                }
                assert (this._currentType == null && this._mapValueTypeToColor == null);
                if (this._mapTypeToColors == null) {
                    this._mapTypeToColors = new LinkedHashMap<AltaType, AltaColor.ColorMap>();
                }
                String colorType = this.getStrFromAttributes(attrs, "NAME", true);
                this._currentType = this.getTypeFromStr(colorType, this.getCECFactory(), !this._isInSubFamilyFolder);
                if (this._currentType == null) {
                    this.addWarningToLogs(ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_TYPE", colorType));
                    this._currentType = null;
                }
                if (this._mapTypeToColors.keySet().contains(this._currentType)) {
                    this._currentType = null;
                }
                this._mapValueTypeToColor = new LinkedHashMap<String, Color>();
                break;
            }
            case "COLOR_VALUE": {
                if (this._currentType == null) break;
                assert (this._currentType != null && this._mapTypeToColors != null && this._mapValueTypeToColor != null);
                int redColor = this.getIntValFromAttributes(attrs, "RED", true);
                int greenColor = this.getIntValFromAttributes(attrs, "GREEN", true);
                int blueColor = this.getIntValFromAttributes(attrs, "BLUE", true);
                String valueType = this.getStrFromAttributes(attrs, "NAME", true);
                Color color = new Color(redColor, greenColor, blueColor);
                this._mapValueTypeToColor.put(valueType, color);
                break;
            }
            case "INIT_FILE": {
                String nameInitFile = this.getStrFromAttributes(attrs, "NAME", true);
                this.getCurrentModel().getConfigs().add(new AltaConfig().setName(nameInitFile));
                break;
            }
            case "INIT_STATE": {
                String nameInitState = this.getStrFromAttributes(attrs, "NAME", true);
                assert (nameInitState.contains("="));
                String[] nameInitStateSplit = nameInitState.split("=");
                assert (nameInitStateSplit.length == 2);
                String state1 = nameInitStateSplit[0].trim();
                String state2 = nameInitStateSplit[1].trim();
                this.getCurrentModel().getConfigs().get(this.getCurrentModel().getConfigs().size() - 1).getStates().put(state1, state2);
                break;
            }
            case "SYSTEM": {
                this._isInSubFamilyFolder = true;
                break;
            }
            case "MODEL": {
                this._isInObject = true;
                this.createModel();
            }
        }
    }

    @Override
    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._currentHandler != null) {
            if (this._currentHandler.endAction(name, attrs, txt)) {
                this._currentHandler = null;
            }
            return false;
        }
        super.endAction(name, attrs, txt);
        switch (name) {
            case "COLOR": {
                if (this._currentType != null) {
                    assert (this._mapValueTypeToColor != null && this._currentType != null && this._mapTypeToColors != null);
                    int size = this._mapValueTypeToColor.size();
                    AltaColor.ColorMap clrMap = new AltaColor.ColorMap(this._currentType, size);
                    for (Map.Entry<String, Color> entry : this._mapValueTypeToColor.entrySet()) {
                        clrMap.putColor(entry.getKey(), entry.getValue());
                    }
                    this._mapTypeToColors.put(this._currentType, clrMap);
                    this._currentType = null;
                }
                this._mapValueTypeToColor = null;
                break;
            }
            case "PROJECT": {
                return true;
            }
            case "SYSTEM": {
                this._isInSubFamilyFolder = false;
                this._subFamilyFolder = null;
                break;
            }
            case "MODEL": {
                this._isInObject = false;
            }
        }
        return false;
    }

    @Override
    protected void initializeObject() {
        this._currentComponent = new AltaSystem(null);
    }

    private void createModel() {
        this.initializeObject();
        this.getCurrentModel().getConfigs().clear();
        this.getCurrentModel().getContent().getSheets().clear();
    }

    private AltaSystem getCurrentModel() {
        return (AltaSystem)this.getCurrentComponent();
    }

    @Override
    protected String getDBFolderName() {
        return "PROJECTS";
    }

    @Override
    protected DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    @Override
    protected short getSubFamily() {
        return 1;
    }

    @Override
    protected void addObjectFromFolder(DBFolder folder, DBWrap wrap, String releaseStr, String ownerStr, String idExternLaeticia, boolean isFrozen) {
        if (this._mapTypeToColors != null && !this._mapTypeToColors.isEmpty()) {
            AltaColor color = new AltaColor();
            color.setColors(this._mapTypeToColors);
            this.getCurrentModel().setColors(color);
        }
        super.addObjectFromFolder(folder, wrap, releaseStr, ownerStr, idExternLaeticia, isFrozen);
    }

    @Override
    protected DBFolder createRootFolder(String name, String comment, String releaseStr, String ownerStr, String idExternLaeticia, boolean isFrozen) {
        DBFolder folder = super.createRootFolder(name, comment, releaseStr, ownerStr, idExternLaeticia, isFrozen);
        folder.setFlags(DBFolder.createFlagsFolder(this.getFamily(), (short)8, (short)0));
        DBProject project = new DBProject(folder);
        super.addObjectFromFolder(folder, project, releaseStr, ownerStr, idExternLaeticia, isFrozen);
        return folder;
    }
}

