/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class OCas51Utils {
    public static final int DIFFERENCE_SIZE_51_TO_6 = 6;
    static Logger _LOG = Logger.getLogger(OCas51Utils.class.getPackage().getName());
    private static final int TYPE_CCF = 0;
    private static final int TYPE_DIFF = 1;
    private static final int TYPE_SYNCHRO = 2;
    public static final Map<String, Integer> getIDLawFromStrLaw = new LinkedHashMap<String, Integer>();

    public static final AltaType getTypeFromStr(String value, DBFolder folderRoot, CECFactory factory, boolean isInVersion4) {
        if (value.indexOf(123) == 0 && value.indexOf(125) == value.length() - 1) {
            return new AltaTypeEnum(value);
        }
        if (value.indexOf(91) == 0 && value.indexOf(93) == value.length() - 1) {
            return new AltaTypeBound(value);
        }
        if (value.equals("bool")) {
            return AltaTypeBool.getInstance();
        }
        if (value.equals("int")) {
            return AltaTypeInt.getInstance();
        }
        if (value.equals("float")) {
            return AltaTypeFloat.getInstance();
        }
        if (value.contains("/")) {
            String[] pathsToFolder = new String[4];
            if (!isInVersion4) {
                paths = value.split("/");
                object = paths[2];
                pathsToFolder[0] = paths[0];
                pathsToFolder[1] = paths[1];
                pathsToFolder[2] = object.substring(0, object.indexOf(59));
                pathsToFolder[3] = object.substring(object.indexOf(59) + 1, object.length());
            } else {
                paths = value.split("/");
                object = paths[1];
                pathsToFolder[0] = paths[0];
                pathsToFolder[1] = paths[0];
                pathsToFolder[2] = object.substring(0, object.indexOf(59));
                pathsToFolder[3] = object.substring(object.indexOf(59) + 1, object.length());
            }
            DBFolder tmpFolder = folderRoot;
            for (String path : pathsToFolder) {
                if ((tmpFolder = tmpFolder.findChild(path)) != null) continue;
                return null;
            }
            DBObject obj = tmpFolder.getObject();
            return (AltaType)((Object)factory.createObjectDAO().getWrap(obj));
        }
        assert (false);
        return null;
    }

    public static void linkDBFolder(DBFolder father, DBFolder son) {
        assert (father != null && son != null);
        if (father.equals(son)) {
            return;
        }
        if (father.findChild(son.getName()) != null && son.getParent() == father) {
            return;
        }
        List<DBFolder> children = father.getChildren();
        if (children == null) {
            children = new ArrayList<DBFolder>();
        }
        children.add(son);
        father.setChildren(children);
        son.setParent(father);
    }

    public static void treatIcons(Map<String, InputStream> mapStreamIcon, OCas51Handler handler, Date timeNow) {
        if (mapStreamIcon.isEmpty()) {
            return;
        }
        DBFolder iconRootFolder = handler.getCECFactory().createFolderDAO().getRootID("IMAGE_FAMILIES");
        for (Map.Entry<String, InputStream> entry : mapStreamIcon.entrySet()) {
            OCas51Utils.treatOneIcon(entry.getKey(), entry.getValue(), handler, iconRootFolder, timeNow);
        }
    }

    private static void treatOneIcon(String path, InputStream stream, OCas51Handler handler, DBFolder rootIconsFolder, Date timeNow) {
        String[] paths = path.split("/");
        String nameSubFamilyFolder = paths[1];
        DBFolder subFolderIcon = rootIconsFolder.findChild(nameSubFamilyFolder);
        if (subFolderIcon == null) {
            subFolderIcon = new DBFolder(handler.getCptAndIncrement());
            subFolderIcon.setDateCreate(timeNow);
            subFolderIcon.setDateModify(timeNow);
            subFolderIcon.setName(DBFactory.convertName(nameSubFamilyFolder, DBFolder.Family.IMAG));
            subFolderIcon.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.IMAG, (short)0, (short)0));
            OCas51Utils.linkDBFolder(rootIconsFolder, subFolderIcon);
        }
        String nameIconModelFolder = paths[2];
        assert (subFolderIcon != null && subFolderIcon.findChild(nameIconModelFolder) == null);
        DBFolder iconModelFolder = new DBFolder(handler.getCptAndIncrement());
        iconModelFolder.setDateCreate(timeNow);
        iconModelFolder.setDateModify(timeNow);
        iconModelFolder.setName(DBFactory.convertName(nameIconModelFolder, DBFolder.Family.IMAG));
        iconModelFolder.setFlags(DBFolder.createFlagsModel(DBFolder.Family.IMAG, (short)0, (short)0));
        OCas51Utils.linkDBFolder(subFolderIcon, iconModelFolder);
        assert (iconModelFolder != null && iconModelFolder.findChild("1") == null);
        DBFolder iconVersFolder = new DBFolder(handler.getCptAndIncrement());
        iconVersFolder.setDateCreate(timeNow);
        iconVersFolder.setDateModify(timeNow);
        iconVersFolder.setName("1");
        iconVersFolder.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.IMAG, (short)0, (short)0));
        OCas51Utils.linkDBFolder(iconModelFolder, iconVersFolder);
        String format = OCas51Utils.findFileExtention(paths[2]);
        byte[] bytesStream = OCas51Utils.getByteArrayFromInputStream(stream);
        DBObjModelBytes model = new DBObjModelBytes(bytesStream);
        model.setNature("image");
        model.setFormat(format.toUpperCase());
        model.setSize(bytesStream.length);
        DBObject object = new DBObject(iconVersFolder.getID()).setFolder(iconVersFolder);
        object.addModel(model);
        iconVersFolder.setObject(object);
        DBIcon icon = new DBIcon(iconVersFolder);
        handler.getCECFactory().createObjectDAO().putWrap(object, icon);
    }

    private static final String findFileExtention(String pathFile) {
        int pos = pathFile.lastIndexOf(".");
        if (pos == -1) {
            return null;
        }
        String extention = pathFile.substring(pos + 1);
        if (extention.isEmpty()) {
            return null;
        }
        return extention;
    }

    private static final byte[] getByteArrayFromInputStream(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (Exception err) {
            return null;
        }
    }

    public static final String revisePathFromBTP(String path) {
        String[] paths;
        if (path == null) {
            throw new NullPointerException();
        }
        if (((String)path).isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        if ((paths = ((String)path).split("/")).length == 5) {
            path = (String)path + "/1";
        }
        return path;
    }

    public static final DBModelLaw getModelLawFromStrValue(CECFactory cecFactory, String fullPath) {
        DBFolder rootBTPFolder;
        assert (cecFactory != null);
        if (fullPath == null || fullPath.isEmpty()) {
            return null;
        }
        String[] paths = fullPath.split("/");
        DBFolder tmpFolder = rootBTPFolder = cecFactory.createFolderDAO().getRootID("LAW_MODELS");
        for (String path : paths) {
            if ((tmpFolder = tmpFolder.findChild(path)) != null) continue;
            return null;
        }
        DBObject obj = tmpFolder.getObject();
        DBModelLaw modelLaw = (DBModelLaw)cecFactory.createObjectDAO().getWrap(obj);
        return modelLaw;
    }

    public static final AltaSynchro.Type getTypeSynchFromID(int id) {
        switch (id) {
            case 0: {
                return AltaSynchro.Type.CCF;
            }
            case 1: {
                return AltaSynchro.Type.DIFF;
            }
            case 2: {
                return AltaSynchro.Type.MEC;
            }
        }
        assert (false) : "Ne dois normalement jamais se produire.";
        return null;
    }

    public static final IWrap getWrapFromStrFolder(CECFactory factory, String root, Locator locator, String ... nameFolder) throws SAXParseException {
        DBFolder rootComponentFolder;
        assert (nameFolder.length == 4);
        DBFolder tmpFolder = rootComponentFolder = factory.createFolderDAO().getRootID(root);
        assert (tmpFolder != null);
        for (String folderName : nameFolder) {
            if ((tmpFolder = tmpFolder.findChild(folderName)) != null) continue;
            return null;
        }
        DBObject obj = tmpFolder.getObject();
        assert (obj != null);
        IWrap comp = factory.createObjectDAO().getWrap(obj);
        assert (comp != null);
        return comp;
    }

    public static final String createPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paths.length - 1; ++i) {
            sb.append(paths[i]).append('/');
        }
        sb.setLength(sb.length() - 1);
        sb.append(';').append(paths[3]);
        return sb.toString();
    }

    static {
        getIDLawFromStrLaw.put("exponential", 0);
        getIDLawFromStrLaw.put("constant", 1);
        getIDLawFromStrLaw.put("GLM", 2);
        getIDLawFromStrLaw.put("GLMa", 3);
        getIDLawFromStrLaw.put("Weibull", 4);
        getIDLawFromStrLaw.put("periodic_test", 5);
        getIDLawFromStrLaw.put("XXX", 6);
        getIDLawFromStrLaw.put("NRD", 7);
        getIDLawFromStrLaw.put("CMT", 8);
        getIDLawFromStrLaw.put("dormant", 9);
        getIDLawFromStrLaw.put("Dirac", 10);
    }
}

