/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.trees.UtilityImportTreeAbstract;
import com.dassault.cecilia.io.trees.arborarb.FormatArbConvert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UtilityImportTreeArb
extends UtilityImportTreeAbstract {
    private static Logger _LOG = Logger.getLogger(UtilityImportTreeArb.class.getPackage().getName());
    PlugableAppl _appl;

    public UtilityImportTreeArb(PlugableAppl appl) {
        super(appl.getDAOFactory(), appl.getDBUser());
        this._appl = appl;
    }

    protected DBFolder doImportFile(File importFile, DBFolder dstFolder, String strName, DBConflict dbConflict) {
        if (dstFolder == null) {
            throw new NullPointerException();
        }
        CECFactory cecFactory = (CECFactory)this._appl.getDAOFactory();
        DBFolder dbFTVersion = null;
        DBFolder dbFTModel = dstFolder.findChild(strName);
        if (dbFTModel != null) {
            dbFTVersion = this.verifyVersionTargetWhenConflict(importFile, dbFTModel, dbConflict, DAGImportChoice.FAULT_TREE);
            if (dbFTVersion == null) {
                return null;
            }
        } else {
            if (cecFactory.createFolderDAO().getAccessRight(dstFolder, this.getDBUser()) != DBAccess.Right.WRITE) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_WRITE", dstFolder.getRefPath()));
                return null;
            }
            dbConflict = null;
        }
        DBFolder dbVersion = null;
        dbVersion = dbConflict == null ? this.createWithoutConflict(dstFolder, strName, false) : this.createWithConflict(dbConflict, dbFTModel, dbFTVersion, false);
        if (dbVersion == null) {
            return null;
        }
        FTEquation ftEquation = new FTEquation(dbVersion);
        if (dbVersion.getID() >= 0L) {
            ftEquation.readLogs(cecFactory);
        }
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this._appl.getDBUser().getLogin(), ftEquation.getLogs());
        logMng.addLog(DBLogs.DBLevel.FINE, "Import from '" + importFile.getAbsolutePath() + "'");
        FormatArbConvert ftConvert = new FormatArbConvert(cecFactory, logMng);
        boolean result = false;
        try {
            FileInputStream input = new FileInputStream(importFile);
            result = ftConvert.read(new InputStreamReader(input));
        }
        catch (FileNotFoundException e) {
            _LOG.log(Level.FINE, "Probleme lors de l'import d'un arbre au format arb", e);
        }
        if (!result) {
            for (DBLogs.Log log : ftEquation.getLogs().getLogs(DBLogs.DBLevel.WARNING)) {
                if (log.getLevel() == DBLogs.DBLevel.ERROR) {
                    this.addError(importFile, MsgType.ERROR, log.getMessage());
                    result = false;
                    continue;
                }
                this.addError(importFile, MsgType.WARNING, log.getMessage());
            }
            return null;
        }
        ftEquation.setVariables(ftConvert.getVariables(), logMng, false);
        ftEquation.getComputeParameters().setTime(ftConvert.getMissionTime());
        DBFolder dbResult = this.finalizeImportFile(importFile, dbVersion, dbConflict, ftEquation);
        if (dbResult != null) {
            dstFolder.setMustBeUpdated(true);
        }
        return dbResult;
    }
}

