/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.io.trees.cafta.CaftaConstant;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCaftaReader
implements CaftaConstant {
    private final File _fileToTreat;
    private final List<CaftaException> _listWarnings;
    private final Map<String, List<CaftaException>> _mapFTVarToWarnings;
    protected Date _date;
    private static final SimpleDateFormat FORMATTER1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
    private static final SimpleDateFormat FORMATTER2 = new SimpleDateFormat("MM/dd/yyyy hh:mm");

    public AbstractCaftaReader(File fileToTreat) {
        this._fileToTreat = fileToTreat;
        this._listWarnings = new ArrayList<CaftaException>();
        this._mapFTVarToWarnings = new LinkedHashMap<String, List<CaftaException>>();
    }

    public final Date getDate() {
        assert (this._date != null);
        return this._date;
    }

    protected final File getFileToTreat() {
        return this._fileToTreat;
    }

    public final void treatFile() throws CaftaException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(this.getFileToTreat()));
            String line = ((LineNumberReader)reader).readLine();
            assert (line.equals(this.getHeaderLine()));
            line = ((LineNumberReader)reader).readLine();
            String[] split = line.split("\t");
            String dateStr = split[split.length - 1];
            this._date = this.getDateCreation(dateStr, ((LineNumberReader)reader).getLineNumber());
            ((LineNumberReader)reader).readLine();
            List<String> headers = this.createListHeader(((LineNumberReader)reader).readLine(), ((LineNumberReader)reader).getLineNumber());
            ((LineNumberReader)reader).readLine();
            this.readFile(headers, (LineNumberReader)reader);
        }
        catch (IOException err) {
            throw new CaftaException(this.getOriginException(), err, reader != null ? ((LineNumberReader)reader).getLineNumber() : -1);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException err) {
                    throw new CaftaException(this.getOriginException(), err, -1);
                }
            }
        }
    }

    protected abstract void readFile(List<String> var1, LineNumberReader var2) throws IOException, CaftaException;

    protected abstract String getHeaderLine();

    protected abstract List<String> missingHeaders(List<String> var1);

    protected abstract CaftaException.OriginTypeFile getOriginException();

    protected final List<String> createListHeader(String line, int idxLine) throws CaftaException {
        assert (line.contains("\t"));
        String[] headers = line.split("\t");
        ArrayList<String> listHeaders = new ArrayList<String>();
        for (String header : headers) {
            listHeaders.add(header.trim());
        }
        List<String> missingHeader = this.missingHeaders(listHeaders);
        if (missingHeader != null && !missingHeader.isEmpty()) {
            throw new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_ERROR_MISSING_HEADER", missingHeader), idxLine);
        }
        return listHeaders;
    }

    protected final String getStrFromArray(FTVariable var, String[] lineSplited, int indexString, int line, List<String> headers, boolean isNeeded) {
        assert (lineSplited != null && lineSplited.length != 0);
        assert (indexString != -1) : "On a correctement v\u00e9rifi\u00e9 le header, il ne doit pas y avoir de -1";
        String value = lineSplited[indexString];
        if (isNeeded && (value == null || value.isEmpty())) {
            ArrayList<CaftaException> warn = new ArrayList<CaftaException>();
            if (var == null) {
                warn.add(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_NULL_NAME", new Object[0]), line));
                this.putNewWarnings(var, warn);
            } else {
                warn.add(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_NULL_VALUE", headers.get(indexString), var), line));
                this.putNewWarnings(var, warn);
            }
        }
        return value;
    }

    protected final Date getDateCreation(String date, int line) throws CaftaException {
        try {
            return FORMATTER1.parse(date);
        }
        catch (ParseException err) {
            try {
                return FORMATTER2.parse(date);
            }
            catch (ParseException err1) {
                throw new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_UNPARSABLE_DATE", date), line);
            }
        }
    }

    protected final int getIdxHeader(List<String> header, String ... possibleNames) {
        String possibleName;
        int index = -1;
        String[] stringArray = possibleNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (index = header.indexOf(possibleName = stringArray[i])) == -1; ++i) {
        }
        return index;
    }

    protected final void addWarning(CaftaException error) {
        this._listWarnings.add(error);
    }

    protected final List<CaftaException> getWarnings() {
        return this._listWarnings;
    }

    protected final void putNewWarnings(FTVariable ftVar, List<CaftaException> warnings) {
        if (this._mapFTVarToWarnings.get(ftVar.getName()) != null) {
            this._mapFTVarToWarnings.get(ftVar.getName()).addAll(warnings);
        } else {
            this._mapFTVarToWarnings.put(ftVar.getName(), warnings);
        }
    }

    public final Map<String, List<CaftaException>> getMapWarnings() {
        return this._mapFTVarToWarnings;
    }
}

