/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.io.trees.cafta.AbstractCaftaReader;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaHandler;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CaftaBasicEventReader
extends AbstractCaftaReader {
    private final CLawManager _lawManager;
    private final List<FTVariable> _listEvents;
    public static Map<String, Integer> INDEX_LAWS = new LinkedHashMap<String, Integer>();
    private static final Map<String, Double> VALUE_UNITS = new LinkedHashMap<String, Double>();

    public CaftaBasicEventReader(File fileToTreat, CECFactory factory) {
        super(fileToTreat);
        this._lawManager = factory.getLawManager();
        this._listEvents = new ArrayList<FTVariable>();
    }

    @Override
    protected void readFile(List<String> header, LineNumberReader reader) throws IOException, CaftaException {
        String line;
        if (header.indexOf("Description") != header.size() - 1) {
            throw new CaftaException(this.getOriginException(), ResMsgCafta.getString("CAFTA_IMPORT_ERROR_DESCRIPTION_MISSPLACED"), -1);
        }
        while ((line = reader.readLine()) != null) {
            String descriptionEvent;
            String calculationEvent;
            String exposureUnitEvent;
            double exposureEvent;
            String rateUnitEvent;
            if (line.trim().isEmpty()) {
                CaftaHandler._LOG.log(Level.FINEST, ResMsgCafta.getString("CAFTA_IMPORT_END_BASIC_EVENTS"));
                return;
            }
            String[] splitLine = line.split("\t");
            int lineIdx = reader.getLineNumber();
            FTVariable currentData = new FTVariable();
            FTEvent event = new FTEvent();
            event.setVariable(currentData);
            currentData.setEvent(event);
            String nameEvent = this.getStrFromArray(null, splitLine, this.getIdxHeader(header, "Basic Event", "B.E. Name"), lineIdx, header, true);
            if (nameEvent == null || nameEvent.isEmpty()) continue;
            if (nameEvent.contains("'")) {
                throw new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_ERROR_QUOTE_IN_EVENT", nameEvent), lineIdx);
            }
            currentData.setName(nameEvent);
            double rateEvent = this.getDoubleFromArray(currentData, splitLine, this.getIdxHeader(header, "Rate", "rate"), lineIdx, header, true);
            if (rateEvent == -1.0 || (rateUnitEvent = this.getStrFromArray(currentData, splitLine, header.indexOf("U"), lineIdx, header, true)) == null || rateUnitEvent.isEmpty() || (exposureEvent = this.getDoubleFromArray(currentData, splitLine, this.getIdxHeader(header, "Exposure", "exposure", "Factor"), lineIdx, header, true).doubleValue()) == -1.0 || (exposureUnitEvent = this.getStrFromArray(currentData, splitLine, header.lastIndexOf("U"), lineIdx, header, true)) == null || exposureUnitEvent.isEmpty() || (calculationEvent = this.getStrFromArray(currentData, splitLine, this.getIdxHeader(header, "Calc", "C"), lineIdx, header, true)) == null || calculationEvent.isEmpty() || (descriptionEvent = this.getDescription(splitLine, header.indexOf("Description"), lineIdx)) == null || descriptionEvent.isEmpty()) continue;
            rateEvent = this.convertToHours(rateEvent, rateUnitEvent);
            exposureEvent = this.convertToHours(exposureEvent, exposureUnitEvent);
            Law law = null;
            if (!INDEX_LAWS.containsKey(calculationEvent)) {
                this.addWarning(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_WRONG_LAW_ID_VALUE", calculationEvent, nameEvent), lineIdx));
                law = this._lawManager.createLaw(-1);
            } else {
                law = this.getLaw(calculationEvent, rateEvent, exposureEvent);
            }
            event.setOccurrence(law);
            currentData.setLabel(descriptionEvent);
            this.putNewWarnings(currentData, new ArrayList<CaftaException>(this.getWarnings()));
            this.getWarnings().clear();
            this._listEvents.add(currentData);
        }
    }

    @Override
    protected String getHeaderLine() {
        return "Basic Event and Type Code Data Report";
    }

    @Override
    protected List<String> missingHeaders(List<String> headers) {
        ArrayList<String> missingHeaders1 = new ArrayList<String>(LIST_HEADERS_BASIC_EVENTS1);
        ArrayList<String> missingHeaders2 = new ArrayList<String>(LIST_HEADERS_BASIC_EVENTS2);
        for (String header : headers) {
            if (header.equals("rate")) {
                header = "Rate";
            } else if (header.equals("exposure")) {
                header = "Exposure";
            }
            missingHeaders1.remove(header);
            missingHeaders2.remove(header);
        }
        if (missingHeaders1.isEmpty() || missingHeaders1.size() < missingHeaders2.size()) {
            return missingHeaders1;
        }
        if (missingHeaders2.isEmpty() || missingHeaders2.size() < missingHeaders1.size()) {
            return missingHeaders2;
        }
        ArrayList<String> returnResult = new ArrayList<String>();
        for (String missingHeader : missingHeaders1) {
            if (missingHeader.equals("Basic Event")) {
                returnResult.add("Basic Event ou B.E. Name");
                continue;
            }
            if (missingHeader.equals("Exposure")) {
                returnResult.add("Exposure ou Factor");
                continue;
            }
            if (missingHeader.equals("Calc")) {
                returnResult.add("Calc ou C");
                continue;
            }
            returnResult.add(missingHeader);
        }
        return returnResult;
    }

    @Override
    protected CaftaException.OriginTypeFile getOriginException() {
        return CaftaException.OriginTypeFile.BASIC_EVNTS;
    }

    public final List<FTVariable> getListEvents() {
        return this._listEvents;
    }

    protected final Double getDoubleFromArray(FTVariable var, String[] lineSplited, int indexString, int line, List<String> header, boolean isNeeded) {
        String doubleStr = this.getStrFromArray(var, lineSplited, indexString, line, header, isNeeded);
        if (doubleStr.isEmpty()) {
            return -1.0;
        }
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException err) {
            ArrayList<CaftaException> list = new ArrayList<CaftaException>();
            list.add(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_UNPARSABLE_NUMBER", doubleStr), line));
            this.putNewWarnings(var, list);
            return -1.0;
        }
    }

    public final Law getLaw(String lawType, double rate, double exposure) {
        int lawIndx = INDEX_LAWS.get(lawType);
        Law law = this._lawManager.createLaw(lawIndx);
        switch (lawIndx) {
            case 1: {
                law.setParamAt(0, new ParamValue(TypeParam.PROBABILITY, exposure));
                break;
            }
            case 8: {
                law.setParamAt(0, new ParamValue(TypeParam.RATE, rate));
                law.setParamAt(1, new ParamValue(TypeParam.DELAY, exposure));
                law.setParamAt(2, new ParamValue(TypeParam.PROBABILITY, 0.0));
                break;
            }
            case 9: {
                law.setParamAt(0, new ParamValue(TypeParam.RATE, rate));
                law.setParamAt(1, new ParamValue(TypeParam.DELAY, 0.0));
                law.setParamAt(2, new ParamValue(TypeParam.DELAY, exposure));
                break;
            }
            case 3: {
                law.setParamAt(0, new ParamValue(TypeParam.RATE, rate));
                law.setParamAt(1, new ParamValue(TypeParam.RATE, 1.0 / exposure));
                break;
            }
            case 2: {
                law.setParamAt(0, new ParamValue(TypeParam.PROBABILITY, 0.0));
                law.setParamAt(1, new ParamValue(TypeParam.RATE, rate));
                law.setParamAt(2, new ParamValue(TypeParam.RATE, 1.0 / exposure));
            }
        }
        return law;
    }

    private final double convertToHours(double value, String unit) {
        assert (unit != null);
        if (unit.isEmpty()) {
            return value;
        }
        double valUnit = VALUE_UNITS.get(unit);
        return value * valUnit;
    }

    private String getDescription(String[] splitLine, int indexOf, int lineIdx) {
        StringBuilder sb = new StringBuilder();
        for (int i = indexOf; i < splitLine.length; ++i) {
            sb.append(splitLine[i]).append('\t');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static {
        INDEX_LAWS.put("0", 1);
        INDEX_LAWS.put("1", 8);
        INDEX_LAWS.put("2", 9);
        INDEX_LAWS.put("3", 8);
        INDEX_LAWS.put("4", 3);
        INDEX_LAWS.put("5", 9);
        INDEX_LAWS.put("6", 2);
        VALUE_UNITS.put("S", 2.777777777777778E-4);
        VALUE_UNITS.put("I", 0.016666666666666666);
        VALUE_UNITS.put("H", 1.0);
        VALUE_UNITS.put("D", 24.0);
        VALUE_UNITS.put("M", 720.0);
        VALUE_UNITS.put("Q", 2161.0);
        VALUE_UNITS.put("Y", 8640.0);
        VALUE_UNITS.put("6", 1000000.0);
        VALUE_UNITS.put("3", 1000.0);
    }
}

