/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.io.trees.cafta.AbstractCaftaReader;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaHandler;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CaftaGatesDescReader
extends AbstractCaftaReader {
    private final Map<String, FTVariable> _varsNameToVars;

    public CaftaGatesDescReader(File fileToTreat, Map<String, FTVariable> vars) {
        super(fileToTreat);
        this._varsNameToVars = vars;
    }

    @Override
    protected void readFile(List<String> header, LineNumberReader reader) throws IOException, CaftaException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) {
                CaftaHandler._LOG.log(Level.FINEST, ResMsgCafta.getString("CAFTA_IMPORT_END_GATES_DESCR"));
                return;
            }
            String[] splitLine = line.split("\t");
            if (splitLine == null || splitLine.length == 0) continue;
            int lineIdx = reader.getLineNumber();
            String gateName = this.getStrFromArray(null, splitLine, header.indexOf("Gate"), lineIdx, header, true);
            if (gateName == null || gateName.isEmpty()) continue;
            FTVariable currentData = this._varsNameToVars.get(gateName);
            if (currentData == null) {
                this.addWarning(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_UNKNOWN_GATE", gateName), lineIdx));
                continue;
            }
            String gateDesc = this.getStrFromArray(currentData, splitLine, header.indexOf("Description"), lineIdx, header, false);
            if (gateDesc == null || gateDesc.isEmpty()) continue;
            currentData.setLabel(gateDesc);
            this.putNewWarnings(currentData, new ArrayList<CaftaException>(this.getWarnings()));
            this.getWarnings().clear();
        }
    }

    @Override
    protected String getHeaderLine() {
        return "Gate Description Report";
    }

    @Override
    protected List<String> missingHeaders(List<String> headers) {
        ArrayList<String> missingHeaders = new ArrayList<String>(LIST_HEADERS_GATES_DESC);
        for (String header : headers) {
            missingHeaders.remove(header);
        }
        return missingHeaders;
    }

    @Override
    protected CaftaException.OriginTypeFile getOriginException() {
        return CaftaException.OriginTypeFile.GATE_DESCRS;
    }
}

