/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.io.trees.cafta.AbstractCaftaReader;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaHandler;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CaftaGatesInputsReader
extends AbstractCaftaReader {
    private final List<FTVariable> _listEvents;
    private final Map<String, FTVariable> _varsNameToVars;
    private final CLawManager _lawManager;
    private final Map<FTVariable, List<String>> _mapVarToInputs;
    private static Map<String, FTDefinition.Type> _allGates = new LinkedHashMap<String, FTDefinition.Type>();

    public CaftaGatesInputsReader(File fileToTreat, CECFactory factory, List<FTVariable> events) {
        super(fileToTreat);
        this._listEvents = events;
        this._lawManager = factory.getLawManager();
        this._varsNameToVars = new LinkedHashMap<String, FTVariable>();
        this._mapVarToInputs = new LinkedHashMap<FTVariable, List<String>>();
    }

    @Override
    protected void readFile(List<String> header, LineNumberReader reader) throws IOException, CaftaException {
        String line;
        LinkedHashMap<FTVariable, Integer> mapVarToLine = new LinkedHashMap<FTVariable, Integer>();
        ArrayList<FTVariable> listGates = new ArrayList<FTVariable>();
        LinkedHashMap<FTVariable, String> mapVarToSpecialType = new LinkedHashMap<FTVariable, String>();
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) {
                CaftaHandler._LOG.log(Level.FINEST, ResMsgCafta.getString("CAFTA_IMPORT_END_GATES_INPUT"));
                break;
            }
            String[] splitLine = line.split("\t");
            if (splitLine == null || splitLine.length == 0) continue;
            int lineIdx = reader.getLineNumber();
            FTVariable currentData = new FTVariable();
            String gateName = this.getStrFromArray(null, splitLine, header.indexOf("Gate"), lineIdx, header, true);
            if (gateName == null || gateName.isEmpty()) continue;
            if (gateName.contains("'")) {
                throw new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_ERROR_QUOTE_IN_EVENT", gateName), lineIdx);
            }
            currentData.setName(gateName);
            String gateType = this.getStrFromArray(currentData, splitLine, this.getIdxHeader(header, "Type", "Gate Type"), lineIdx, header, true);
            if (gateType == null || gateType.isEmpty()) continue;
            int indexInputs = this.getIdxHeader(header, "Inputs", "Inputs...");
            ArrayList inputs = new ArrayList();
            while (indexInputs != splitLine.length) {
                inputs.add(splitLine[indexInputs++]);
            }
            FTDefinition.Type type = _allGates.get(gateType);
            int value = -1;
            if (type == null && gateType.substring(0, 3).equals("COM")) {
                type = FTDefinition.Type.KOFN;
                String valueStr = gateType.replace("COM", "");
                if (valueStr.isEmpty()) {
                    this.addWarning(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_UNKNOWN_FACTOR_KOON", gateName), lineIdx));
                    value = 2;
                } else {
                    value = Integer.parseInt(valueStr);
                }
            } else if (type == null) {
                this.addWarning(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_UNKNOWN_TYPE", gateName, gateType), lineIdx));
                type = FTDefinition.Type.OR;
            } else if (GATES_NEGATIV_PART.contains(gateType)) {
                mapVarToSpecialType.put(currentData, gateType);
            } else if (NOT_SUPPORTED_TYPES.contains(gateType)) {
                this.addWarning(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_NOT_SUPPORTED_TYPE", gateName, gateType, type.getLabel()), lineIdx));
            }
            FTDefinition ftDef = new FTDefinition(type, new ArrayList());
            if (value != -1) {
                ftDef.setAtLeast(value);
            }
            currentData.setDefinition(ftDef);
            listGates.add(currentData);
            this._mapVarToInputs.put(currentData, inputs);
            mapVarToLine.put(currentData, reader.getLineNumber());
            this._varsNameToVars.put(currentData.getName(), currentData);
            this.putNewWarnings(currentData, new ArrayList<CaftaException>(this.getWarnings()));
            this.getWarnings().clear();
        }
        for (FTVariable event : this._listEvents) {
            this._varsNameToVars.put(event.getName(), event);
        }
        for (FTVariable var : listGates) {
            List<String> inputs = this._mapVarToInputs.get(var);
            FTDefinition varDef = var.getDefinition();
            ArrayList<FTVariableAbstract> varSons = new ArrayList<FTVariableAbstract>();
            int lineIdx = (Integer)mapVarToLine.get(var);
            for (String input : inputs) {
                FTVariable varSon = this._varsNameToVars.get(input);
                if (varSon == null) {
                    varSon = this.createDefaultEvent(input);
                    this._varsNameToVars.put(input, varSon);
                    this.putNewWarnings(varSon, Arrays.asList(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_MISSING_DECL_VAR", input, var.getName(), lineIdx), lineIdx)));
                }
                varSons.add(varSon);
            }
            String specialType = (String)mapVarToSpecialType.get(var);
            if (specialType != null) {
                this.createSpecialGate(var, specialType, varSons, lineIdx);
                continue;
            }
            varDef.setArgs(varSons);
        }
    }

    @Override
    protected String getHeaderLine() {
        return "Fault Tree List Report (Depth First)";
    }

    @Override
    protected List<String> missingHeaders(List<String> headers) {
        ArrayList<String> missingHeaders1 = new ArrayList<String>(LIST_HEADERS_GATES_1);
        ArrayList<String> missingHeaders2 = new ArrayList<String>(LIST_HEADERS_GATES_2);
        for (String header : headers) {
            missingHeaders1.remove(header);
            missingHeaders2.remove(header);
        }
        if (missingHeaders1.isEmpty() || missingHeaders1.size() < missingHeaders2.size()) {
            return missingHeaders1;
        }
        if (missingHeaders2.isEmpty() || missingHeaders2.size() < missingHeaders1.size()) {
            return missingHeaders2;
        }
        ArrayList<String> returnResult = new ArrayList<String>();
        for (String missingHeader : missingHeaders1) {
            if (missingHeader.equals("Type")) {
                returnResult.add("Type ou Gate Type");
                continue;
            }
            if (!missingHeader.equals("Inputs...")) continue;
            returnResult.add("Inputs... ou Inputs");
        }
        return returnResult;
    }

    @Override
    protected CaftaException.OriginTypeFile getOriginException() {
        return CaftaException.OriginTypeFile.GATE_INPUTS;
    }

    public final List<List<FTVariable>> getAllVariables() {
        ArrayList<List<FTVariable>> getVarsByRoots = new ArrayList<List<FTVariable>>();
        LinkedHashSet<String> allInputs = new LinkedHashSet<String>();
        for (List<String> allInput : this._mapVarToInputs.values()) {
            for (String input : allInput) {
                allInputs.add(input);
            }
        }
        LinkedHashSet<FTVariable> roots = new LinkedHashSet<FTVariable>();
        for (FTVariable ftVar : this._mapVarToInputs.keySet()) {
            String varName = ftVar.getName();
            if (allInputs.contains(varName)) continue;
            roots.add(ftVar);
            ftVar.setRoot(true);
        }
        for (FTVariable root : roots) {
            List<FTVariable> extract = root.extractVariables();
            extract.get(0).setRoot(true);
            getVarsByRoots.add(extract);
        }
        return getVarsByRoots;
    }

    public Map<String, FTVariable> getVarsNameToVarsMap() {
        return this._varsNameToVars;
    }

    private final FTVariable createDefaultEvent(String name) {
        FTVariable ftVar = new FTVariable();
        FTEvent event = new FTEvent();
        event.setVariable(ftVar);
        Law law = this._lawManager.createLaw(-1);
        event.setOccurrence(law);
        ftVar.setEvent(event);
        ftVar.setName(name);
        ftVar.setLabel(ResMsgCafta.getString("CAFTA_IMPORT_AUTOGENERATED_EVENT"));
        return ftVar;
    }

    private void createSpecialGate(FTVariable var, String specialType, List<FTVariableAbstract> varSons, int line) {
        FTDefinition varDef = var.getDefinition();
        if (varSons.size() != 2) {
            ArrayList<CaftaException> errors = new ArrayList<CaftaException>();
            errors.add(new CaftaException(this.getOriginException(), ResMsgCafta.msgFormat("CAFTA_WARNING_WRONG_NUMBER_OF_SONS", var.getName(), specialType), line));
            this.putNewWarnings(var, errors);
            varDef.setArgs(varSons);
            return;
        }
        FTVariable varIntermediate = new FTVariable();
        String nameIntermediate = null;
        boolean notA = specialType.equals("ONAB") || specialType.equals("ANAB");
        nameIntermediate = notA ? "Not" + varSons.get(0).getName() : "Not" + varSons.get(1).getName();
        int i = 1;
        if (this._varsNameToVars.get(nameIntermediate) != null) {
            nameIntermediate = nameIntermediate + i;
        }
        while (this._varsNameToVars.get(nameIntermediate) != null) {
            nameIntermediate = nameIntermediate.substring(0, nameIntermediate.length() - String.valueOf(nameIntermediate).length()) + ++i;
        }
        varIntermediate.setName(nameIntermediate);
        varIntermediate.setDefinition(new FTDefinition(FTDefinition.Type.NOT, notA ? Arrays.asList(varSons.get(0)) : Arrays.asList(varSons.get(1))));
        ArrayList<FTVariableAbstract> sons = new ArrayList<FTVariableAbstract>();
        if (notA) {
            sons.add(varIntermediate);
            sons.add(varSons.get(1));
        } else {
            sons.add(varSons.get(0));
            sons.add(varIntermediate);
        }
        varDef.setArgs(sons);
    }

    static {
        _allGates.put("OR", FTDefinition.Type.OR);
        _allGates.put("AND", FTDefinition.Type.AND);
        _allGates.put("NOT", FTDefinition.Type.NOT);
        _allGates.put("XOR", FTDefinition.Type.XOR);
        _allGates.put("ANOT", FTDefinition.Type.NAND);
        _allGates.put("ONOT", FTDefinition.Type.NOR);
        _allGates.put("EQU", FTDefinition.Type.OR);
        _allGates.put("PAG", FTDefinition.Type.AND);
        _allGates.put("AANB", FTDefinition.Type.AND);
        _allGates.put("ANAB", FTDefinition.Type.AND);
        _allGates.put("ONAB", FTDefinition.Type.OR);
        _allGates.put("OANB", FTDefinition.Type.OR);
        _allGates.put("INH", FTDefinition.Type.AND);
    }
}

