/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.trees.cafta.CaftaBasicEventReader;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaGatesDescReader;
import com.dassault.cecilia.io.trees.cafta.CaftaGatesInputsReader;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CaftaHandler {
    public static Logger _LOG = Logger.getLogger(CaftaHandler.class.getPackage().getName());
    private final CECFactory _cecFactory;
    private final File[] _arrayFiles;
    private final String _login;
    private Date _currentDate;
    private List<FTEquation> _listFTEquation;

    public CaftaHandler(CECFactory factory, File[] files, String login) {
        this._cecFactory = factory;
        this._arrayFiles = files;
        this._login = login;
    }

    public boolean treatment(List<GeneralError<File>> listMsg) {
        boolean result = true;
        File basicEventFile = this._arrayFiles[0];
        File gatesFile = this._arrayFiles[1];
        try {
            CaftaBasicEventReader readerEvent = new CaftaBasicEventReader(basicEventFile, this._cecFactory);
            readerEvent.treatFile();
            List<FTVariable> ftEvents = readerEvent.getListEvents();
            this._currentDate = readerEvent.getDate();
            Map<String, List<CaftaException>> warnings = readerEvent.getMapWarnings();
            CaftaGatesInputsReader readerGates = new CaftaGatesInputsReader(gatesFile, this._cecFactory, ftEvents);
            readerGates.treatFile();
            Map<String, FTVariable> map = readerGates.getVarsNameToVarsMap();
            this._currentDate = readerGates.getDate().after(this._currentDate) ? readerGates.getDate() : this._currentDate;
            this.addWarnings(warnings, readerGates.getMapWarnings());
            File gatesDescFile = null;
            if (this._arrayFiles.length == 3 && this._arrayFiles[2] != null) {
                gatesDescFile = this._arrayFiles[2];
                CaftaGatesDescReader readerGatesDesc = new CaftaGatesDescReader(gatesDescFile, map);
                readerGatesDesc.treatFile();
                this._currentDate = readerGatesDesc.getDate().after(this._currentDate) ? readerGatesDesc.getDate() : this._currentDate;
                this.addWarnings(warnings, readerGatesDesc.getMapWarnings());
            }
            List<List<FTVariable>> allVars = readerGates.getAllVariables();
            Map<List<FTVariable>, List<CaftaException>> mapFTVarsToWarnings = this.createMapFTVarsToWarnings(allVars, warnings);
            ArrayList<CaftaException> warningsList = new ArrayList<CaftaException>();
            for (List<CaftaException> list : warnings.values()) {
                warningsList.addAll(list);
            }
            for (CaftaException caftaException : warningsList) {
                _LOG.log(Level.WARNING, caftaException.displayMessage());
                listMsg.add(new GeneralError<File>(this.getFileFromOrigin(caftaException), caftaException.displayUserFriendlyMsg(), MsgType.WARNING));
            }
            this._listFTEquation = new ArrayList<FTEquation>();
            for (Map.Entry entry : mapFTVarsToWarnings.entrySet()) {
                List listVars = (List)entry.getKey();
                List listException = (List)entry.getValue();
                FTEquation equation = new FTEquation(null);
                DBLogs.DefaultManager logsManager = new DBLogs.DefaultManager(this._login, equation.getLogs());
                for (CaftaException exception : listException) {
                    logsManager.addLog(DBLogs.DBLevel.WARNING, exception.getMessage());
                }
                equation.setVariables(listVars, logsManager, false);
                if (equation.withLoopDefinition()) {
                    CaftaException warning = new CaftaException(null, ResMsgCafta.getString("CAFTA_ERROR_LOOP_DETECTED"), -1);
                    listMsg.add(new GeneralError<File>(this.getFileFromOrigin(warning), warning.displayUserFriendlyMsg(), MsgType.ERROR));
                    result = false;
                    continue;
                }
                this._listFTEquation.add(equation);
            }
            for (FTEquation fTEquation : this._listFTEquation) {
                String rootName = fTEquation.getTopEvent().getName();
                int indexChar = DBFactory.verifyName(rootName);
                if (indexChar != 0 && Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName")) {
                    rootName = DBFactory.convertName(rootName);
                    indexChar = DBFactory.verifyName(rootName);
                }
                if (indexChar == 0) continue;
                CaftaException warning = new CaftaException(null, ResMsgCafta.msgFormat("CAFTA_ERROR_ROOT_SYNTAX_NAME", rootName, Character.valueOf((char)indexChar)), -1);
                listMsg.add(new GeneralError<File>(this.getFileFromOrigin(warning), warning.displayUserFriendlyMsg(), MsgType.ERROR));
                result = false;
            }
        }
        catch (CaftaException exc) {
            listMsg.add(new GeneralError<File>(this.getFileFromOrigin(exc), exc.displayMessage(), MsgType.FATAL));
            result = false;
        }
        return result;
    }

    public final List<FTEquation> getListFTEquation() {
        return this._listFTEquation;
    }

    public final Date getDate() {
        return this._currentDate;
    }

    public final File getFileFromOrigin(CaftaException warning) {
        CaftaException.OriginTypeFile origin = warning.getOriginException();
        if (origin == null && warning.getCause() instanceof CaftaException) {
            origin = ((CaftaException)warning.getCause()).getOriginException();
        }
        if (origin == null) {
            return null;
        }
        switch (origin) {
            case BASIC_EVNTS: {
                return this._arrayFiles[0];
            }
            case GATE_INPUTS: {
                return this._arrayFiles[1];
            }
            case GATE_DESCRS: {
                return this._arrayFiles[2];
            }
        }
        assert (false);
        return null;
    }

    private Map<List<FTVariable>, List<CaftaException>> createMapFTVarsToWarnings(List<List<FTVariable>> allVars, Map<String, List<CaftaException>> mapWarnings) {
        LinkedHashMap<List<FTVariable>, List<CaftaException>> map = new LinkedHashMap<List<FTVariable>, List<CaftaException>>();
        for (List<FTVariable> listVars : allVars) {
            ArrayList<CaftaException> warns = new ArrayList<CaftaException>();
            for (FTVariable var : listVars) {
                List<CaftaException> warningsOfFT = mapWarnings.get(var.getName());
                if (warningsOfFT == null) continue;
                warns.addAll(warningsOfFT);
            }
            map.put(listVars, warns);
        }
        return map;
    }

    private final void addWarnings(Map<String, List<CaftaException>> warnings, Map<String, List<CaftaException>> warningsToAdd) {
        for (Map.Entry<String, List<CaftaException>> entry : warningsToAdd.entrySet()) {
            String nameVar = entry.getKey();
            List<CaftaException> listException = entry.getValue();
            if (warnings.get(nameVar) != null) {
                warnings.get(nameVar).addAll(listException);
                continue;
            }
            warnings.put(nameVar, listException);
        }
    }
}

