/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.io.xml6.DBFolderXmlConstant;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBObjModelHandlerXml
extends SAXWrapHandler
implements DBFolderXmlConstant {
    String _nature;
    String _format;
    String _encoding = "";
    String _crc = "";
    StringBuilder _buffer;
    int _indentLvl;
    boolean[] _withChildren = new boolean[16];
    boolean _eoChildHandler = false;
    private static String[] INDENT = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    ", "                      ", "                        ", "                          ", "                            ", "                              "};

    public DBObjModelHandlerXml(DBLogs.DBLogsManager logMng, Locator locator) {
        super(logMng, locator);
    }

    public String getNature() {
        return this._nature;
    }

    public String getFormat() {
        return this._format;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getCRC() {
        return this._crc;
    }

    public String getBuffer() {
        return this._buffer.toString();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            String encoding;
            String crc;
            if (!"cec.model".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.model"), this.getLocator()));
            }
            this._nature = this.readName(key, "nature", attrs);
            if (!DBObjModel.verifyNature(this._nature, false)) {
                if (Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName") && this._nature.startsWith("associated.file")) {
                    String nature = DBFactory.convertName(this._nature);
                    if (DBFactory.verifyName(nature) != 0) {
                        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "nature", this._nature), this.getLocator()));
                    } else {
                        this._nature = nature;
                    }
                } else {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "nature", this._nature), this.getLocator()));
                }
            }
            this._format = this.readName(key, "format", attrs);
            if (!DBObjModel.verifyFormat(this._format)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "format", this._format), this.getLocator()));
            }
            if ((crc = attrs.get("crc")) != null && !crc.isEmpty()) {
                if (!DBObjModel.verifyCRC(crc)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "crc", this._crc), this.getLocator()));
                } else {
                    this._crc = crc;
                }
            }
            if ((encoding = attrs.get("encoding")) != null && !encoding.isEmpty()) {
                if (!DBObjModel.verifyEncoding(encoding)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "encoding", this._encoding), this.getLocator()));
                } else {
                    this._encoding = encoding;
                }
            }
            this._buffer = new StringBuilder(4096);
            this._indentLvl = 0;
            if (this._format.equals("ZML") || this._format.equals("XML")) {
                this._buffer.append("<?xml version='1.0'?>\n");
            }
            if (this._format.equals("ZML")) {
                this._format = "XML";
            }
        } else if (this._format.equals("XML")) {
            if (this._indentLvl > 0 && !this._withChildren[this._indentLvl - 1]) {
                this._buffer.append(">\n");
                this._withChildren[this._indentLvl - 1] = true;
            }
            this._buffer.append(INDENT[this._indentLvl]).append("<").append(key);
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                this._buffer.append(" ").append(attr.getKey()).append("='");
                DBObjectXmlUtility.appendXML(this._buffer, attr.getValue());
                this._buffer.append("'");
            }
            this._withChildren[this._indentLvl] = false;
            ++this._indentLvl;
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if ("cec.model".equals(key)) {
            String myText = txt.trim();
            if (myText.length() > 0) {
                this._buffer.append(myText);
            }
            return true;
        }
        if (this._format.equals("XML")) {
            --this._indentLvl;
            if (txt.trim().length() > 0) {
                String trim;
                if (!this._withChildren[this._indentLvl]) {
                    this._buffer.append(">");
                }
                if ((trim = DBObjModelHandlerXml.trimAfterLastCR(txt)) != null) {
                    DBObjectXmlUtility.appendXML(this._buffer, trim);
                } else {
                    DBObjectXmlUtility.appendXML(this._buffer, txt);
                }
                this._buffer.append("</").append(key).append(">\n");
            } else if (!this._withChildren[this._indentLvl]) {
                this._buffer.append("/>\n");
            } else {
                this._buffer.append(INDENT[this._indentLvl]).append("</").append(key).append(">\n");
            }
        }
        return false;
    }

    private static String trimAfterLastCR(String txt) {
        int pos = txt.lastIndexOf(10);
        if (pos == -1) {
            return null;
        }
        String eos = txt.substring(pos);
        if (eos.length() > 1 && eos.trim().isEmpty()) {
            return txt.substring(0, pos + 1);
        }
        return null;
    }

    private static void debug(String txt) {
        String trim = DBObjModelHandlerXml.trimAfterLastCR(txt);
        if (trim != null) {
            System.out.println(trim + "|");
        } else {
            System.err.println("Don't matche");
        }
    }

    public static void debug(String[] args) {
        DBObjModelHandlerXml.debug("toto\ntoti\n     ");
        DBObjModelHandlerXml.debug("toto\ntoti");
        DBObjModelHandlerXml.debug("toto\ntoti\n");
    }
}

