/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.io.xml6.DBFolderHandlerXml;
import com.dassault.cecilia.io.xml6.DBFolderXmlConstant;
import com.dassault.cecilia.io.xml6.DBPreferenceHandlerXml;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBRootHandlerXml
extends SAXWrapHandler
implements DBFolderXmlConstant {
    protected DAOFactory _daoFactory;
    protected boolean _reader;
    DBFolderHandlerXml _childHandler = null;
    DBPreferenceHandlerXml _preferenceHandler = null;
    protected List<String> _readerFilterPrefsKey = Arrays.asList("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine", "com.dassault.cecilia.dbobj.faulttree.egli.pref.EGL");

    public DBRootHandlerXml(DBLogs.DBLogsManager logMng, DAOFactory daoFactory, boolean reader) {
        super(logMng, null);
        this._daoFactory = daoFactory;
        this._reader = reader;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if (this._preferenceHandler != null) {
            this._preferenceHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            if (!"cec.export".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.export"), this.getLocator()));
            }
        } else if ("cec.folder".equals(key)) {
            this._childHandler = new DBFolderHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
            this._childHandler.startAction(key, attrs, true);
        } else if ("cec.prefs".equals(key)) {
            this._preferenceHandler = new DBPreferenceHandlerXml(this.getLogManager(), this.getLocator());
            this._preferenceHandler.startAction(key, attrs, true);
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childHandler != null) {
            boolean result = this._childHandler.endAction(key, attrs, txt);
            if (result) {
                DBFolder dbFolder = this._childHandler.getDBFolder();
                if (dbFolder != null) {
                    DAOFolder daoFolder = this._daoFactory.createFolderDAO();
                    DBFolder dbRoot = daoFolder.getRootID(dbFolder.getFamily().getRootName());
                    dbRoot.getChildren().add(dbFolder);
                    dbFolder.setParent(dbRoot);
                }
                this._childHandler = null;
            }
            return false;
        }
        if (this._preferenceHandler != null) {
            Map<String, String> prefs;
            boolean result = this._preferenceHandler.endAction(key, attrs, txt);
            if (result && (prefs = this._preferenceHandler.getPrefs()) != null && !prefs.isEmpty()) {
                this.savePreference(prefs);
            }
            return false;
        }
        return "cec.export".equals(key);
    }

    protected void savePreference(Map<String, String> prefs) {
        StringBuilder outData = new StringBuilder();
        outData.append("<").append("cec.prefs").append(">\n");
        for (Map.Entry<String, String> pref : prefs.entrySet()) {
            if (this._reader && this.filterReader(pref.getKey())) continue;
            outData.append("  <").append("preference");
            outData.append(" key='" + DefaultIOParameters.toXML(pref.getKey()) + "'");
            outData.append(" value='" + DefaultIOParameters.toXML(pref.getValue()) + "'");
            outData.append("/>\n");
        }
        outData.append("</").append("cec.prefs").append(">\n");
        DBUser dbUser = this._daoFactory.createUserDAO().getMasterUser();
        DBPreference dbPref = this._daoFactory.createPreferenceDAO().find(dbUser, "Default");
        if (dbPref == null) {
            dbPref = new DBPreference().setUser(dbUser).setName("Default");
            dbPref.setValue("<?xml version='1.0'?>\n" + outData.toString());
            dbPref = this._daoFactory.createPreferenceDAO().create(dbPref);
            if (dbPref == null) {
                Logger.getLogger(DBRootHandlerXml.class.getName()).warning("Probleme lors de la creation des preferences par defaut");
            }
        } else {
            dbPref.setValue("<?xml version='1.0'?>\n" + outData.toString());
            if (!this._daoFactory.createPreferenceDAO().update(dbPref)) {
                Logger.getLogger(DBRootHandlerXml.class.getName()).warning("Probleme lors de la sauvegarde des preferences par defaut");
            }
        }
    }

    private boolean filterReader(String key) {
        for (String filter : this._readerFilterPrefsKey) {
            if (!key.startsWith(filter)) continue;
            return true;
        }
        return false;
    }
}

