/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.folders;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ccf.gui.DBCCFCmdEdit;
import com.dassault.cecilia.dbobj.fmea.gui.DBModelFMEACmdEdit;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.attrib.gui.DBAttribCmdEdit;
import com.dassault.cecilia.dbobj.general.nparam.gui.DBParamCmdEdit;
import com.dassault.cecilia.dbobj.modellaw.DBModelLawCmdEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.BTPFolderCmdProperty;
import javax.swing.JPopupMenu;

public class BTPFolderTree
extends DBFolderTreeActivable {
    public BTPFolderTree(CeciliaAppl application, DBFolderTreeModel model) {
        super(application, model, false);
    }

    @Override
    protected CeciliaAppl getAppl() {
        return super.getAppl();
    }

    @Override
    protected boolean isEnabledEdit(DBFolder dbFolder) {
        if (dbFolder.getObject() == null) {
            return false;
        }
        switch (dbFolder.getFamily()) {
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isEnabledFreeze(DBFolder dbFolder) {
        if (dbFolder.isFreeze()) {
            return false;
        }
        return this.isEnabledEdit(dbFolder);
    }

    @Override
    protected boolean isEnabledAddFile(DBFolder dbFolder) {
        if (dbFolder.getFamily() == DBFolder.Family.BTP_SUBSTANTIATION) {
            return false;
        }
        return super.isEnabledAddFile(dbFolder);
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        JPopupMenu result = super.createMenuActions(popupList);
        result.remove(0);
        result.remove(0);
        return result;
    }

    @Override
    protected void refreshActions() {
        super.refreshActions();
        this._ctrlAddFolder.setEnabled(false);
        this.getAppl().getTopWindow().getDelegateAction("FOLDER_CREATE_ROOT").setEnabled(false);
    }

    @Override
    protected void doInsert(DBFolder dbParent) {
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder == DBFolder.Family.APPLICATION) {
            return;
        }
        BTPFolderCmdProperty cmd = new BTPFolderCmdProperty(this.getAppl(), (DBFolderTreeEditable)this, false);
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    @Override
    protected void doProperties(DBFolder folder, boolean readOnly) {
        if (folder.isSystem()) {
            return;
        }
        BTPFolderCmdProperty cmd = new BTPFolderCmdProperty(this.getAppl(), (DBFolderTreeEditable)this, true);
        cmd.setDBFolder(folder).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    @Override
    protected void doEdit(DBFolder folder, boolean readOnly) {
        switch (folder.getFamily()) {
            case PARAMETER: {
                if (folder.getObject() == null) {
                    return;
                }
                if (!folder.isVersion()) {
                    return;
                }
                new DBParamCmdEdit(this.getAppl(), this, folder, readOnly).realiseDo();
                return;
            }
            case ATTRIBUTE: {
                if (folder.getObject() == null) {
                    return;
                }
                if (!folder.isVersion()) {
                    return;
                }
                new DBAttribCmdEdit(this.getAppl(), this, folder, readOnly).realiseDo();
                return;
            }
            case BTP_MODEL: {
                if (folder.getObject() == null) {
                    return;
                }
                if (!folder.isVersion()) {
                    return;
                }
                new DBModelLawCmdEdit(this.getAppl(), this, folder, readOnly).realiseDo();
                return;
            }
            case CCF_MODEL: {
                if (folder.getObject() == null) {
                    return;
                }
                if (!folder.isVersion()) {
                    return;
                }
                new DBCCFCmdEdit(this.getAppl(), this, folder, readOnly).realiseDo();
                return;
            }
            case FMEA_MODEL: {
                if (folder.getObject() == null) {
                    return;
                }
                if (!folder.isVersion()) {
                    return;
                }
                new DBModelFMEACmdEdit(this.getAppl(), this, folder, readOnly).realiseDo();
                return;
            }
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return;
            }
        }
        super.doEdit(folder, readOnly);
    }
}

