/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.folders;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdProperty;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.FMEAFolderInsertPanel;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;

public class ProjectFolderCmdInsertModel
extends DBFolderCmdProperty {
    short _familyFlag;
    FTEquationAbstract _ftEquation;

    public ProjectFolderCmdInsertModel(CAppl appl, DBFolderTreeEditable ctrlTree, short familyFlag) {
        super(appl, ctrlTree, false);
        this._familyFlag = familyFlag;
    }

    @Override
    protected DBFolderPropertiesPanel constructDialog() {
        if (this._familyFlag == 4) {
            FMEAFolderInsertPanel dlg = new FMEAFolderInsertPanel((CeciliaAppl)this.getAppl());
            if (!this.configurePanel(dlg)) {
                return null;
            }
            return dlg;
        }
        return super.constructDialog();
    }

    @Override
    protected boolean verifyCreateNewModel() {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            DBFolder dbFolder = new DBFolder(this._dbFolder);
            dbFolder.setFamilyFlag(this._familyFlag);
            if (!((DemoLimitedFactory)this._application.getDAOFactory()).verifyCreateNewModel(dbFolder)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_CREATE"), this._application.getTitle(), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean configurePanel(DBFolderPropertiesPanel dlg) {
        if (!super.configurePanel(dlg)) {
            return false;
        }
        if (!this.isEditProperties()) {
            DBFolder create = dlg.getDBFolder();
            create.setFlags(DBFolder.createFlagsModel(create.getFamily(), this._familyFlag, (short)0));
            switch (this._familyFlag) {
                case 1: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_MODEL"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_MODEL"));
                    break;
                }
                case 2: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_TREE"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_TREE"));
                    break;
                }
                case 5: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_BEQ"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_BEQ"));
                    break;
                }
                case 3: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_DSF"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_DSF"));
                    break;
                }
                case 4: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_FMEA"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_FMEA"));
                }
            }
        }
        return true;
    }

    @Override
    protected void createModelFolder(DBFolderPropertiesPanel dlg) {
        DBFolder dbFolderModel = dlg.getDBFolder();
        DBFolder dbFolderVersion = new DBFolder(dbFolderModel, this._dbUser);
        if (this._familyFlag == 1) {
            dbFolderVersion.setName("1");
        } else {
            dbFolderVersion.setName("1.0");
        }
        dbFolderVersion.setFlags(DBFolder.createFlagsVersion(dbFolderModel.getFamily(), this._familyFlag, (short)0));
        dbFolderVersion.setDescription(dbFolderModel.getDescription());
        if (this._familyFlag == 4) {
            DBObject dbObject = super.createObject(dbFolderVersion);
            dbFolderVersion.setObject(dbObject);
            DBTableFMEA dbFMEA = new DBTableFMEA(dbFolderVersion);
            dbFMEA.setModelFolder(((FMEAFolderInsertPanel)dlg).getModelFolder());
            dbFMEA.configureModels(dbObject);
        } else {
            dbFolderVersion.setObject(this.createObject(dbFolderVersion));
        }
        dbFolderModel.setChildren(Collections.singletonList(dbFolderVersion));
        this.createDBFolder(dbFolderModel);
    }

    @Override
    protected DBObject createObject(DBFolder dbFolderVersion) {
        DBObject dbObject = super.createObject(dbFolderVersion);
        switch (this._familyFlag) {
            case 1: {
                AltaSystem dbSystem = new AltaSystem(dbFolderVersion);
                dbSystem.configureModels(dbObject);
                break;
            }
            case 2: {
                this._ftEquation = new FTEquation(dbFolderVersion);
                this._ftEquation.configureModels(dbObject);
                break;
            }
            case 3: {
                this._ftEquation = new DSFEquation(dbFolderVersion);
                this._ftEquation.getLogs().addLog(new Date(), this.getAppl().getDBUser().getLogin(), DBLogs.DBLevel.INIT, ResMsgObj.getString("MSG_ERR_OBJ_NOT_INITIALIZED")).setPrivate(true);
                this._ftEquation.configureModels(dbObject);
            }
        }
        return dbObject;
    }

    @Override
    protected DBFolder createDBFolder(DBFolder create) {
        DBFolder result = super.createDBFolder(create);
        if (result == null) {
            return null;
        }
        if (this._familyFlag == 2 || this._familyFlag == 3) {
            List<DBFolder> children = result.getChildren();
            if (children == null) {
                children = this.getAppl().getDAOFactory().createFolderDAO().findChildren(result);
            }
            if (children.size() == 1) {
                DBFolder child = children.get(0);
                Collection<DBGlobEvent> events = this._ftEquation.createGlobalEvents(child);
                if (!this.getAppl().getDAOFactory().createGlobEventDAO().insertAll(child, events)) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTree), ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"), this._application.getTitle(), 2);
                }
            }
        }
        return result;
    }
}

