/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsUtility;
import com.dassault.cecilia.dbobj.general.update.UpdateUtility;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.DBWrapThreadSave;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapCmdSaveAs;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class DBInternalFrame
extends CInternalFrame {
    boolean _forReadOnly = false;
    boolean _isModified = false;
    CeciliaAction _ctrlActionSave;
    CeciliaAction _ctrlActionClose;
    protected DBLogsUtility _logsUtility;
    protected UpdateUtility _updateUtility;
    protected JButton _ctrlSave;

    protected abstract String getDBLabel();

    public abstract DBWrap getDBWrap();

    protected abstract CeciliaAppl getApplication();

    protected abstract String getDescription();

    @Override
    public DBFolder getDBFolder() {
        return this.getDBWrap().getDBFolder();
    }

    protected String getDBInfo() {
        return this.getDBFolder().getRefPath();
    }

    public DBInternalFrame getMasterFrame() {
        return this;
    }

    public DBInternalFrame(DBFolder dbFolder) {
        super(DBFolderResources.getFrameIcon(dbFolder), dbFolder.isVersion() ? dbFolder.getParent().getName() + ";" + dbFolder.getName() : dbFolder.getName(), dbFolder.getRefPath());
        this.createPrivate();
        this.setButtonIcon(DBFolderResources.getIcon(dbFolder, false, dbFolder.isVersion(), true, false));
    }

    public DBInternalFrame(ImageIcon icone, String iconeLabel, String str) {
        super(icone, iconeLabel, str);
        this.createPrivate();
        this.setButtonIcon(icone);
    }

    public DBInternalFrame(ImageIcon icone, String str) {
        super(icone, str);
        this.createPrivate();
        this.setButtonIcon(icone);
    }

    public void updateIconAndTitle() {
        DBFolder dbFolder = this.getDBFolder();
        this.setButtonIcon(DBFolderResources.getIcon(dbFolder, false, dbFolder.isVersion(), true, false));
        this.setTitle(dbFolder.getRefPath());
        this.setIconText(dbFolder.isVersion() ? dbFolder.getParent().getName() + ";" + dbFolder.getName() : dbFolder.getName());
    }

    public boolean isReadOnly() {
        return this._forReadOnly;
    }

    public void setEditable(boolean state) {
        if (this._ctrlSave != null) {
            this._ctrlSave.setText(ResMsgVoc.getString(state ? "VOC_SAVE" : "VOC_SAVE_AS"));
        }
        this._forReadOnly = !state;
    }

    @Override
    public boolean isModified() {
        if (this.getLogs().isModified()) {
            return true;
        }
        return this._isModified;
    }

    public void setModified(boolean value) {
        this.getLogs().setModified(value);
        this._isModified = value;
    }

    public boolean verifyData() {
        int result;
        return this.getDBWrap() == null || this.getLogs() == null || this.getLogs().getMaxLevel().compareTo(DBLogs.DBLevel.INFO) <= 0 || (result = JOptionPane.showConfirmDialog(this, ResMsgObj.getString("CONFIRM_SAVE_WITHERROR"), this.getTitle(), 0)) != 1;
    }

    private void createPrivate() {
        this._ctrlActionSave = new CeciliaAction(ResMsgVoc.getString("VOC_SAVE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DBInternalFrame.this.verifyData()) {
                    return;
                }
                if (!DBInternalFrame.this.isReadOnly()) {
                    if (!DBInternalFrame.this.save()) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(DBInternalFrame.this), ResMsgCore.getString("MSG_ERR_SAVE_MODEL"));
                    }
                } else {
                    DBInternalFrame.this.saveAs();
                }
            }
        };
        this._ctrlActionClose = new CeciliaAction(ResMsgVoc.getString("VOC_CLOSE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBInternalFrame.this.doDefaultCloseAction();
            }
        };
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.doSave();
    }

    protected boolean doSave() {
        DBWrapThreadSave thSave = new DBWrapThreadSave(this.getDBWrap(), this.getDescription(), this.getApplication(), this._ctrlSave){

            @Override
            protected void setModif(boolean value) {
                DBInternalFrame.this.setModified(value);
            }
        };
        return this.doSave(thSave);
    }

    protected boolean doSave(DBWrapThreadSave thSave) {
        DBLogs saveLogs = this.getDBWrap().getLogs().getCopy();
        for (DBLogs.Log log : this.getDBWrap().getLogs().getLogs(DBLogs.DBLevel.WARNING)) {
            if (log.isPrivate()) {
                this.getDBWrap().getLogs().removeLog(log);
                continue;
            }
            switch (log.getLevel()) {
                case ERROR: {
                    this.getDBWrap().getLogs().changeLog(log, DBLogs.DBLevel.FINE);
                    break;
                }
                case WARNING: {
                    this.getDBWrap().getLogs().changeLog(log, DBLogs.DBLevel.FINER);
                }
            }
        }
        thSave.realiseDo();
        if (!thSave.getResult()) {
            this.getDBWrap().setLogs(saveLogs);
        } else {
            this.updateIconAndTitle();
            this.updatePrivateLogs();
        }
        this.getLogs().refreshRelations(this.getDBWrap().getUseRelations());
        return thSave.getResult();
    }

    protected boolean verifyClose() {
        if (this.isModified() && !this.isReadOnly()) {
            Object[] options = new Object[]{ResMsgVoc.getString("VOC_YES"), ResMsgVoc.getString("VOC_NO"), ResMsgVoc.getString("VOC_CANCEL")};
            int reponse = JOptionPane.showOptionDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_QST_MODIFY_SAVE_FRM", this.getDBLabel(), this.getDBInfo()), ResMsgVoc.getString("VOC_MESSAGE"), 1, 3, null, options, options[0]);
            switch (reponse) {
                case 0: {
                    if (!this.verifyData()) {
                        return false;
                    }
                    if (this.save()) break;
                    return false;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void saveAs() {
        DBWrapSaveAsDlg dlg = this.saveAsPrepareDialog();
        this.configureSaveAsDlg(dlg);
        dlg.make(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        DBFolder[] dbPrepare = this.saveAsPrepareFolders(dlg);
        DBWrapCmdSaveAs cmd = new DBWrapCmdSaveAs(this.getApplication(), this, dbPrepare, this.getDBFolder());
        cmd.realiseDo();
    }

    protected void configureSaveAsDlg(DBWrapSaveAsDlg dlg) {
        String dlgTitle = ResMsgVoc.getString("VOC_SAVE_AS") + " (" + DBFolderResources.getTypeModel(this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag()) + ")";
        dlg.setIconImage(DBFolderResources.getFrameIcon(this.getDBFolder()).getImage());
        dlg.setSelectFolder(this.getDBFolder().getParent());
        dlg.setNewName(this.getDBFolder().getParent().getName());
        dlg.setTitle(dlgTitle);
        DBFolderPropertiesPanel panel = dlg.getVersionPanel();
        DBFolder parentFolder = this.getDBFolder().getParent();
        panel.setQuestion(DBFolderResources.getTypeVersion(parentFolder.getFamily()));
        panel.setVersionsReferencies(Arrays.asList(this.getDBFolder()), parentFolder.getChildren());
        panel.setDAOFactory(this.getApplication().getDAOFactory());
        panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_VERSION"));
        panel.setUserIsAdmin(this.getApplication().getDBUser().isAdmin());
    }

    protected DBWrapSaveAsDlg saveAsPrepareDialog() {
        return new DBWrapSaveAsDlg(JOptionCecilia.getWindowOf(this), this.getApplication(), this.getDBFolder().getFamily(), true);
    }

    protected DBFolder[] saveAsPrepareFolders(DBWrapSaveAsDlg dlg) {
        if (dlg.isVersionCreation()) {
            return new DBFolder[]{DBFactory.createVersion(dlg.getSelectFolder().getParent(), this.getApplication().getDBUser(), dlg.getSelectFolder().getName(), this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag(), (short)0)};
        }
        return DBFactory.createModel(dlg.getSelectFolder(), this.getApplication().getDBUser(), dlg.getNewName(), "1", this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag(), (short)0);
    }

    public DBLogsUtility getLogs() {
        if (this._logsUtility == null) {
            this._logsUtility = new DBLogsUtility(){

                @Override
                protected DBWrap getWrap() {
                    return DBInternalFrame.this.getDBWrap();
                }

                @Override
                protected CECFactory getCECFactory() {
                    return DBInternalFrame.this.getApplication().getDAOFactory();
                }

                @Override
                protected Preferencies getPreferencies() {
                    return DBInternalFrame.this.getApplication().getPreferencies();
                }
            };
        }
        return this._logsUtility;
    }

    public UpdateUtility getUpdateUtility() {
        if (this._updateUtility == null) {
            this._updateUtility = new UpdateUtility(this){

                @Override
                protected DBWrap getWrap() {
                    return DBInternalFrame.this.getDBWrap();
                }

                @Override
                protected CECFactory getCECFactory() {
                    return DBInternalFrame.this.getApplication().getDAOFactory();
                }

                @Override
                protected Preferencies getPreferencies() {
                    return DBInternalFrame.this.getApplication().getPreferencies();
                }

                @Override
                protected void updateEdit() {
                    DBInternalFrame.this.updateEdit();
                }

                @Override
                protected boolean withUpdateEdit() {
                    return DBInternalFrame.this.withUpdateEdit();
                }
            };
        }
        return this._updateUtility;
    }

    protected boolean withUpdateEdit() {
        return false;
    }

    protected void updateEdit() {
    }

    protected void updateLogs(Collection<DBRelation> relations, DBLogs.DBLevel oldLevel, int oldNbr) {
        this.updatePrivateLogs();
        this.getLogs().refreshRelations(relations);
        boolean displayMsg = false;
        if (this.getLogs().getMaxLevel().compareTo(DBLogs.DBLevel.WARNING) >= 0) {
            if (this.getLogs().getMaxLevel().compareTo(oldLevel) > 0) {
                displayMsg = true;
            } else if (oldNbr < this.getLogs().getNbrLogs()) {
                displayMsg = true;
            }
        }
        if (displayMsg) {
            StringBuilder sb = new StringBuilder().append(this.getDBLabel());
            sb.append(" '").append(this.getDBFolder().getRefPath()).append("' ");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_ERR_VERIFY_MODEL_FRM", sb.toString()), JOptionCecilia.getTopTitleOf(this), 1);
        }
    }

    protected void updatePrivateLogs() {
    }

    @Override
    protected void toDoWhenActivated() {
        this.getApplication().getTopWindow().getDelegateAction("SAVE").addDelegate(this._ctrlActionSave).setName(ResMsgVoc.getString(this.isReadOnly() ? "VOC_SAVE_AS" : "VOC_SAVE")).setEnabled(true);
        this.getApplication().getTopWindow().getDelegateAction("CLOSE").addDelegate(this._ctrlActionClose).setEnabled(true);
        super.toDoWhenActivated();
        this.getUpdateUtility().update();
    }

    @Override
    protected void toDoWhenDeActivated() {
        this.getApplication().getTopWindow().getDelegateAction("SAVE").delDelegate(this._ctrlActionSave).setName(ResMsgVoc.getString("VOC_SAVE")).setEnabled(false);
        this.getApplication().getTopWindow().getDelegateAction("CLOSE").delDelegate(this._ctrlActionClose).setEnabled(false);
        super.toDoWhenDeActivated();
    }

    protected void displayErrors(List<GeneralError<DBFolder>> errors, String applTitle) {
        if (!errors.isEmpty()) {
            Window win = SwingUtilities.getWindowAncestor(this);
            final DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win);
            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + applTitle);
            dlg.setErrors(errors);
            dlg.setModal(true);
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dlg.setVisible(true);
                }
            });
        } else {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", "Unable to display errors encountered"), applTitle, 0);
        }
    }

    protected Component createAndPlugLogsButtonAt(Component panel) {
        JPanel panelLog = new JPanel(new GridBagLayout());
        panelLog.add((Component)this.getUpdateUtility().getButUpdate(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panelLog.add(panel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLog.add(this.getLogs().getButLogs(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panelLog;
    }

    protected Component createSaveAndClosePanel() {
        this._ctrlSave = new JButton(this._ctrlActionSave);
        this._ctrlSave.setDefaultCapable(true);
        this._ctrlClose = new JButton(this._ctrlActionClose);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)this._ctrlSave, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlClose, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }
}

