/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.reader;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsSimpleDlg;
import com.dassault.cecilia.io.xml6.ImportUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.reader.ResIcoReader;
import com.dassault.cecilia.main.reader.ResMsgReader;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class ReaderAppl
extends CeciliaAppl {
    private static Logger _LOG = Logger.getLogger(ReaderAppl.class.getName());
    String[] _args;

    public ReaderAppl(String[] args) {
        super(true);
        this._args = args;
    }

    private boolean openXMLImportConnection(File file) {
        DAOImportXmlFactory daoFactory = new DAOImportXmlFactory();
        this._daoFactory = new CeciliaFactory(this, daoFactory);
        ImportUtility importUtility = new ImportUtility(daoFactory);
        try {
            importUtility.readXml(new FileInputStream(file), true);
            List<DBLogs.Log> logs = importUtility.getLogs().getLogs(DBLogs.DBLevel.WARNING);
            if (logs.isEmpty()) {
                return true;
            }
            DBLogsSimpleDlg dlg = new DBLogsSimpleDlg(null);
            dlg.setDBLogs(importUtility.getLogs());
            dlg.setVisible(true);
            return true;
        }
        catch (FileNotFoundException e) {
            _LOG.log(Level.WARNING, "Impossible d'ouvrir le fichier : " + file.getAbsolutePath(), e);
            JOptionCecilia.showMessageDialog(null, ResMsgCore.msgFormat("FILE_ERROR_DURING_READ", file.getAbsolutePath()), this.getTitle(), 0);
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Exception lors du chargement du fichier : " + file.getAbsolutePath(), e);
            JOptionCecilia.showMessageDialog(null, ResMsgCore.msgFormat("FILE_ERROR_DURING_OPEN", file.getAbsolutePath()), this.getTitle(), 0);
        }
        return false;
    }

    @Override
    public boolean standardDatabaseConnection() {
        if (this._args.length == 1) {
            File file = new File(this._args[0]);
            return this.openXMLImportConnection(file);
        }
        if (this._args.length == 0) {
            boolean result = false;
            JFileChooser dlg = new JFileChooser(".");
            JChooserFileUtility.configureFileFilter(dlg, JChooserFileUtility.Type.XML);
            dlg.setFileSelectionMode(0);
            while (!result) {
                if (dlg.showOpenDialog(null) == 1) {
                    return false;
                }
                result = this.openXMLImportConnection(dlg.getSelectedFile());
            }
            return true;
        }
        _LOG.log(Level.SEVERE, "Cecilia Reader - Erreur de syntaxe (au plus 1 argument au niveau de la ligne de commande)");
        return false;
    }

    @Override
    public ImageIcon getSplashIcon() {
        return new ImageIcon(ResIcoReader.getInstance().getImage("SPLASH_READER", 500, 500));
    }

    @Override
    public List<? extends Image> getIcons() {
        int size = 16;
        return Arrays.asList(ResIcoReader.getInstance().getImage("FRAME_READER", 1 * size, 1 * size), ResIcoReader.getInstance().getImage("FRAME_READER", 2 * size, 2 * size), ResIcoReader.getInstance().getImage("FRAME_READER", 3 * size, 3 * size), ResIcoReader.getInstance().getImage("FRAME_READER", 4 * size, 4 * size), ResIcoReader.getInstance().getImage("FRAME_READER", 8 * size, 8 * size));
    }

    @Override
    public String getTitle() {
        return ResMsgReader.getString("TITLE_READER");
    }

    @Override
    public boolean verifyLicense(StringBuffer msgLicense) {
        return true;
    }

    @Override
    public String getModuleName() {
        return "READER";
    }
}

