/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper;

import com.dassault.cecilia.core.plugin.AbstractPluginModelBan;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.util.destination.DestinationRecord;
import com.dassault.cecilia.plugin.mbsa.translator.PanelDisplayMessage;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateOptions;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class BanInferencePlugin
extends AbstractPluginModelBan {
    public static final String PROP_CSTEPPER_ONLYGENERATE = "cecilia.mbsa.plugin.cstepper.OnlyGenerate";
    private IModel _model;

    protected BanInferencePlugin(IModel model) {
        this._model = model;
    }

    protected IModel getModel() {
        return this._model;
    }

    protected String getNameOfBanScript() {
        return "BanScriptInference2.xml";
    }

    protected InputStream getStreamOfBanScript() {
        return BanInferencePlugin.class.getResourceAsStream(this.getNameOfBanScript());
    }

    protected File getBanScript() {
        return null;
    }

    protected void prepareBanEntry(Plugable launcher, Object ... objects) {
        BanEntry ban = this.getBanEntry();
        ban.setUserProperty("altr.log.class", DestinationRecord.class.getName());
        ban.setUserProperty("altr.log.format", "txt");
        ban.setUserProperty("altr.log.opt.key", "Limit");
        ban.setUserProperty("altr.log.opt.val", "100");
        ban.setUserProperty("altr.translate.ccf", Boolean.toString(TranslateOptions.withTranslateCCF(launcher)));
        ban.setUserProperty("altr.dataflow.verify", Boolean.toString(TranslateOptions.withDataFlowVerify(launcher)));
        ban.setUserProperty("altr.verify.before", TranslateOptions.listVerifyBefore(launcher, 2));
        ban.setUserProperty("altr.verify.after", TranslateOptions.listVerifyAfter(launcher, 2));
        if (Boolean.getBoolean(PROP_CSTEPPER_ONLYGENERATE)) {
            ban.setUserProperty("altr.verify.stop", "true");
        }
    }

    protected void catchBanException(Plugable launcher, BanProcessException e, Object ... objects) {
        BanEntry ban;
        Object obj = null;
        if (this._model != null && (obj = (ban = this.getBanEntry()).getIdObject("altr-log-ref")) != null) {
            DestinationRecord dest = (DestinationRecord)obj;
            if (dest != null && dest.getNbrRecord() > 0) {
                this.showParseError(launcher, dest.getRecords(), e.getMessage());
            } else {
                obj = null;
            }
        }
        if (obj == null) {
            super.catchBanException(launcher, e, new Object[0]);
        }
    }

    protected void showParseError(Plugable launcher, List<String> msgs, final String title) {
        PanelDisplayMessage panel = new PanelDisplayMessage(){

            @Override
            public String getInfo(String key) {
                if (title != null && key.equals("ppanel.title")) {
                    return title;
                }
                return super.getInfo(key);
            }
        };
        panel.initializeData(this._model.getFile());
        launcher.addPanel((PlugPanel)panel, this._model.getUID());
        panel.updateData(msgs);
    }
}

