/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import javax.swing.JFrame;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.TestMessages;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.RunnableQueue;

public class JSVGCanvasHandler {
    public static final String REGARD_TEST_INSTANCE = "regardTestInstance";
    public static final String REGARD_START_SCRIPT = "try { regardStart(); } catch (er) {}";
    public static final String ERROR_CANNOT_LOAD_SVG = "JSVGCanvasHandler.message.error.could.not.load.svg";
    public static final String ERROR_SVG_RENDER_FAILED = "JSVGCanvasHandler.message.error.svg.render.failed";
    public static final String ERROR_SVG_UPDATE_FAILED = "JSVGCanvasHandler.message.error.svg.update.failed";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "JSVGCanvasHandler.entry.key.error.description";
    JFrame frame = null;
    JSVGCanvas canvas = null;
    WeakReference updateManager = null;
    WindowListener wl = null;
    InitialRenderListener irl = null;
    LoadListener ll = null;
    SVGLoadEventListener sll = null;
    UpdateRenderListener url = null;
    boolean failed;
    boolean abort = false;
    boolean done = false;
    final Object loadMonitor = new Object();
    final Object renderMonitor = new Object();
    Delegate delegate;
    Test host;
    String desc;

    public static String fmt(String key, Object[] args) {
        return TestMessages.formatMessage(key, args);
    }

    public JSVGCanvasHandler(Test host, Delegate delegate) {
        this.host = host;
        this.delegate = delegate;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JSVGCanvas getCanvas() {
        return this.canvas;
    }

    public JSVGCanvas createCanvas() {
        return new JSVGCanvas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void runCanvas(String desc) {
        block20: {
            this.desc = desc;
            this.setupCanvas();
            if (this.abort) {
                return;
            }
            Object object = this.renderMonitor;
            // MONITORENTER : object
            Object object2 = this.loadMonitor;
            // MONITORENTER : object2
            if (this.delegate.canvasInit(this.canvas)) {
                this.checkLoad();
            }
            // MONITOREXIT : object2
            if (this.abort) {
                // MONITOREXIT : object
                this.delegate.canvasDone(this.canvas);
                this.dispose();
                return;
            }
            this.checkRender();
            if (this.abort) {
                // MONITOREXIT : object
                this.delegate.canvasDone(this.canvas);
                this.dispose();
                return;
            }
            if (this.updateManager != null && this.updateManager.get() != null) break block20;
            // MONITOREXIT : object
            this.delegate.canvasDone(this.canvas);
            this.dispose();
            return;
        }
        try {
            do {
                if (this.done) {
                    this.delegate.canvasDone(this.canvas);
                    this.dispose();
                    return;
                }
                this.checkUpdate();
            } while (!this.abort);
            // MONITOREXIT : object
            this.delegate.canvasDone(this.canvas);
            this.dispose();
            return;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.delegate.canvasDone(this.canvas);
                this.dispose();
            }
        }
    }

    public void setupCanvas() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JSVGCanvasHandler.this.frame = new JFrame(JSVGCanvasHandler.this.delegate.getName());
                    JSVGCanvasHandler.this.canvas = JSVGCanvasHandler.this.createCanvas();
                    JSVGCanvasHandler.this.canvas.setPreferredSize(new Dimension(450, 500));
                    JSVGCanvasHandler.this.frame.getContentPane().add((Component)JSVGCanvasHandler.this.canvas);
                    JSVGCanvasHandler.this.frame.pack();
                    JSVGCanvasHandler.this.wl = new WindowAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void windowClosing(WindowEvent e) {
                            Object object = JSVGCanvasHandler.this.loadMonitor;
                            synchronized (object) {
                                JSVGCanvasHandler.this.abort = true;
                                JSVGCanvasHandler.this.loadMonitor.notifyAll();
                            }
                            object = JSVGCanvasHandler.this.renderMonitor;
                            synchronized (object) {
                                JSVGCanvasHandler.this.abort = true;
                                JSVGCanvasHandler.this.renderMonitor.notifyAll();
                            }
                        }
                    };
                    JSVGCanvasHandler.this.frame.addWindowListener(JSVGCanvasHandler.this.wl);
                    JSVGCanvasHandler.this.frame.setVisible(true);
                    JSVGCanvasHandler.this.irl = new InitialRenderListener();
                    JSVGCanvasHandler.this.canvas.addGVTTreeRendererListener((GVTTreeRendererListener)JSVGCanvasHandler.this.irl);
                    JSVGCanvasHandler.this.ll = new LoadListener();
                    JSVGCanvasHandler.this.canvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)JSVGCanvasHandler.this.ll);
                    JSVGCanvasHandler.this.sll = new SVGLoadEventListener();
                    JSVGCanvasHandler.this.canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)JSVGCanvasHandler.this.sll);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void scriptDone() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UpdateManager um = JSVGCanvasHandler.this.getUpdateManager();
                if (um != null) {
                    um.forceRepaint();
                }
                Object object = JSVGCanvasHandler.this.renderMonitor;
                synchronized (object) {
                    JSVGCanvasHandler.this.done = true;
                    JSVGCanvasHandler.this.failed = false;
                    JSVGCanvasHandler.this.renderMonitor.notifyAll();
                }
            }
        };
        UpdateManager um = this.getUpdateManager();
        if (um == null || !um.isRunning()) {
            Thread t = new Thread(r);
            t.start();
        } else {
            um.getUpdateRunnableQueue().invokeLater(r);
        }
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.removeWindowListener(this.wl);
            this.frame.setVisible(false);
        }
        this.wl = null;
        if (this.canvas != null) {
            this.canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this.irl);
            this.irl = null;
            this.canvas.removeSVGDocumentLoaderListener((SVGDocumentLoaderListener)this.ll);
            this.ll = null;
            this.canvas.removeUpdateManagerListener((UpdateManagerListener)this.url);
            this.url = null;
        }
        this.updateManager = null;
        this.canvas = null;
        this.frame = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSomething(Object monitor, String errorCode) {
        Object object = monitor;
        synchronized (object) {
            this.failed = true;
            try {
                monitor.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this.abort || this.failed) {
                DefaultTestReport report = new DefaultTestReport(this.host);
                report.setErrorCode(errorCode);
                report.setDescription(new TestReport.Entry[]{new TestReport.Entry(JSVGCanvasHandler.fmt(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)JSVGCanvasHandler.fmt(errorCode, new Object[]{this.desc}))});
                report.setPassed(false);
                this.delegate.failure((TestReport)report);
                this.done = true;
                return;
            }
        }
    }

    public void checkLoad() {
        this.checkSomething(this.loadMonitor, ERROR_CANNOT_LOAD_SVG);
        this.delegate.canvasLoaded(this.canvas);
    }

    public void checkRender() {
        this.checkSomething(this.renderMonitor, ERROR_SVG_RENDER_FAILED);
        this.delegate.canvasRendered(this.canvas);
    }

    public void checkUpdate() {
        this.checkSomething(this.renderMonitor, ERROR_SVG_UPDATE_FAILED);
        if (!this.done) {
            this.done = this.delegate.canvasUpdated(this.canvas);
        }
    }

    public void bindHost() {
        UpdateManager um = this.getUpdateManager();
        RunnableQueue rq = um.getUpdateRunnableQueue();
        rq.invokeLater(new Runnable(){
            UpdateManager um;
            {
                this.um = JSVGCanvasHandler.this.getUpdateManager();
            }

            @Override
            public void run() {
                ScriptingEnvironment scriptEnv = this.um.getScriptingEnvironment();
                Interpreter interp = scriptEnv.getInterpreter();
                interp.bindObject(JSVGCanvasHandler.REGARD_TEST_INSTANCE, (Object)JSVGCanvasHandler.this.host);
                try {
                    interp.evaluate(JSVGCanvasHandler.REGARD_START_SCRIPT);
                }
                catch (InterpreterException interpreterException) {
                    // empty catch block
                }
            }
        });
    }

    protected UpdateManager getUpdateManager() {
        if (this.updateManager != null) {
            return (UpdateManager)this.updateManager.get();
        }
        return null;
    }

    class SVGLoadEventListener
    extends SVGLoadEventDispatcherAdapter {
        SVGLoadEventListener() {
        }

        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
            SVGLoadEventDispatcher dispatcher = (SVGLoadEventDispatcher)e.getSource();
            UpdateManager um = dispatcher.getUpdateManager();
            JSVGCanvasHandler.this.updateManager = new WeakReference<UpdateManager>(um);
            JSVGCanvasHandler.this.url = new UpdateRenderListener();
            um.addUpdateManagerListener((UpdateManagerListener)JSVGCanvasHandler.this.url);
        }
    }

    class LoadListener
    extends SVGDocumentLoaderAdapter {
        LoadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            Object object = JSVGCanvasHandler.this.loadMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.failed = false;
                JSVGCanvasHandler.this.loadMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
            Object object = JSVGCanvasHandler.this.loadMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.loadMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentLoadingCancelled(SVGDocumentLoaderEvent e) {
            Object object = JSVGCanvasHandler.this.loadMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.loadMonitor.notifyAll();
            }
        }
    }

    class InitialRenderListener
    extends GVTTreeRendererAdapter {
        InitialRenderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            Object object = JSVGCanvasHandler.this.renderMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.failed = false;
                JSVGCanvasHandler.this.renderMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            Object object = JSVGCanvasHandler.this.renderMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.renderMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            Object object = JSVGCanvasHandler.this.renderMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.renderMonitor.notifyAll();
            }
        }
    }

    class UpdateRenderListener
    implements UpdateManagerListener {
        UpdateRenderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCompleted(UpdateManagerEvent e) {
            Object object = JSVGCanvasHandler.this.renderMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.failed = false;
                JSVGCanvasHandler.this.renderMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateFailed(UpdateManagerEvent e) {
            Object object = JSVGCanvasHandler.this.renderMonitor;
            synchronized (object) {
                JSVGCanvasHandler.this.renderMonitor.notifyAll();
            }
        }

        public void managerStarted(UpdateManagerEvent e) {
            JSVGCanvasHandler.this.bindHost();
        }

        public void managerSuspended(UpdateManagerEvent e) {
        }

        public void managerResumed(UpdateManagerEvent e) {
        }

        public void managerStopped(UpdateManagerEvent e) {
        }

        public void updateStarted(UpdateManagerEvent e) {
        }
    }

    public static interface Delegate {
        public String getName();

        public boolean canvasInit(JSVGCanvas var1);

        public void canvasLoaded(JSVGCanvas var1);

        public void canvasRendered(JSVGCanvas var1);

        public boolean canvasUpdated(JSVGCanvas var1);

        public void canvasDone(JSVGCanvas var1);

        public void failure(TestReport var1);
    }
}

