/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.wordxml;

import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.export.wordxml.Parseur;
import com.dassault.cecilia.plugin.export.wordxml.ResWordXml;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;

public class DocbookThread
extends CThread {
    static final String DOCBOOK_DATA_PATH_DEFAULT = "./core/plugins/docbook";
    static final String DOCBOOK_DATA_PROPERTY = "cecilia.export.wordxml.path";
    public File _file = null;
    public int _pageOrientation = 1;
    public String _pageFormat = "A4";
    Object _result = null;

    public DocbookThread(Component c, File file) {
        super(c);
        this._file = file;
    }

    protected void firstDo() {
        this._result = this.executeAction();
    }

    Object executeAction() {
        if (this._file != null) {
            File outputFile = this._file;
            File inputFile = new File(this._file.getPath() + ".tmp");
            try {
                FileUtility.copyFile((File)outputFile, (File)inputFile);
            }
            catch (IOException e) {
                ResWordXml.LOG.log(Level.WARNING, "WordWML - copyFile(" + outputFile + ", " + inputFile + ")", e);
                return e;
            }
            Object imagePath = this._file.getPath();
            int pos = ((String)imagePath).lastIndexOf(".xml");
            if (pos != -1) {
                imagePath = ((String)imagePath).substring(0, pos);
            }
            imagePath = (String)imagePath + "_images" + File.separator;
            Parseur parseur = new Parseur();
            parseur._parseurDocbook._pageFormat = this._pageFormat;
            parseur._parseurDocbook._pageOrientation = this._pageOrientation;
            String pathData = System.getProperty(DOCBOOK_DATA_PROPERTY, DOCBOOK_DATA_PATH_DEFAULT);
            File dirPath = new File(pathData);
            if (!dirPath.exists() || !dirPath.isDirectory()) {
                ResWordXml.LOG.warning("WordWML - verifyPathData(" + pathData + ") :" + dirPath.getAbsolutePath());
                return null;
            }
            parseur._parseurDocbook.buildXml(dirPath, inputFile, outputFile, new File((String)imagePath));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewFile(String file) {
        String outputFileName = file.substring(0, file.indexOf(".xml")) + "_tmp.xml";
        BufferedReader inputFile = null;
        BufferedWriter outputFile = null;
        try {
            String line;
            inputFile = new BufferedReader(new FileReader(file));
            outputFile = new BufferedWriter(new FileWriter(outputFileName));
            while ((line = inputFile.readLine()) != null) {
                outputFile.write(line + "\n");
            }
            inputFile.close();
            outputFile.close();
            String string = outputFileName;
            return string;
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - createNewFile(" + file + ")", e);
            String string = "";
            return string;
        }
        finally {
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    ResWordXml.LOG.log(Level.INFO, "WordWML - IOException during close file", e);
                }
            }
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException e) {
                    ResWordXml.LOG.log(Level.INFO, "WordWML - IOException during close file", e);
                }
            }
        }
    }
}

