/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.wordxml;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.plugin.export.wordxml.Border;
import com.dassault.cecilia.plugin.export.wordxml.ColSpec;
import com.dassault.cecilia.plugin.export.wordxml.DrawImgXml;
import com.dassault.cecilia.plugin.export.wordxml.Entry;
import com.dassault.cecilia.plugin.export.wordxml.ParseurWord;
import com.dassault.cecilia.plugin.export.wordxml.ResWordXml;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParseurDocbook
extends ParseurWord {
    public static final int _A4P_MAX_WIDTH = 500;
    public static final int _A4P_MAX_HEIGHT = 700;
    public static final int _A4L_MAX_WIDTH = 700;
    public static final int _A4L_MAX_HEIGHT = 450;
    public static final int _A3P_MAX_WIDTH = 700;
    public static final int _A3P_MAX_HEIGHT = 1000;
    public static final int _A3L_MAX_WIDTH = 1000;
    public static final int _A3L_MAX_HEIGHT = 700;
    public static final int _LETTERP_MAX_WIDTH = 510;
    public static final int _LETTERP_MAX_HEIGHT = 660;
    public static final int _LETTERL_MAX_WIDTH = 660;
    public static final int _LETTERL_MAX_HEIGHT = 660;
    public static final int _B5P_MAX_WIDTH = 430;
    public static final int _B5P_MAX_HEIGHT = 610;
    public static final int _B5L_MAX_WIDTH = 610;
    public static final int _B5L_MAX_HEIGHT = 430;
    public static final int _B4P_MAX_WIDTH = 610;
    public static final int _B4P_MAX_HEIGHT = 860;
    public static final int _B4L_MAX_WIDTH = 860;
    public static final int _B4L_MAX_HEIGHT = 860;
    public static final boolean PUCE = true;
    public static final boolean NO_PUCE = false;
    private static Logger _LOG = Logger.getLogger(ParseurDocbook.class.getPackage().getName());

    @Override
    public void parseXml(Document document) throws IOException {
        Node root = document.getLastChild();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("article")) {
                this.writeChapter(node, true);
                continue;
            }
            if (node.getNodeName().equals("chapter")) {
                this.writeChapter(node, false);
                continue;
            }
            if (node.getNodeName().equals("section")) {
                this.writeSection(node, 1);
                continue;
            }
            if (node.getNodeName().equals("info")) {
                this.writeInfoArticle(node);
                continue;
            }
            if (node.getNodeName().equals("sect1")) {
                this.writeSection(node, 1);
                continue;
            }
            if (!node.getNodeName().equals("title")) continue;
            this.writeWithStyle("Titre", node.getTextContent());
        }
    }

    public void writeChapter(Node root, boolean article) throws IOException {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (ResWordXml.LOG.isLoggable(Level.FINEST)) {
                ResWordXml.LOG.finest("chapter children nodes " + node.getNodeName());
            }
            if (node.getNodeName().equals("title")) {
                this.writeWithStyle("Titre1", node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("section")) {
                this.writeSection(node, 1);
                continue;
            }
            if (node.getNodeName().equals("sect1")) {
                this.writeSection(node, 1);
                continue;
            }
            if (node.getNodeName().equals("sect2")) {
                this.writeSection(node, 2);
                continue;
            }
            if (node.getNodeName().equals("sect3")) {
                this.writeSection(node, 3);
                continue;
            }
            if (node.getNodeName().equals("sect4")) {
                this.writeSection(node, 4);
                continue;
            }
            if (node.getNodeName().equals("sect5")) {
                this.writeSection(node, 5);
                continue;
            }
            if (node.getNodeName().equals("para")) {
                this.writePara(node, true);
                continue;
            }
            if (node.getNodeName().equals("simpara")) {
                this.writePara(node, true);
                continue;
            }
            if (node.getNodeName().equals("informaltable")) {
                this.parseInformaltable(node);
                continue;
            }
            if (!node.getNodeName().equals("info") || !article) continue;
            this.writeInfoArticle(node);
        }
    }

    private void writeInfoArticle(Node root) throws IOException {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("title")) {
                this.writeWithStyle("Titre", node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("subtitle")) {
                this.writeWithStyle("Sous-titre", node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("author")) {
                Node child = node.getFirstChild();
                if (child == null || !child.getNodeName().equals("personname")) continue;
                this.writeTexteNormal(ResMsgVoc.getString((String)"VOC_AUTHOR") + ": " + child.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("date")) {
                this.writeTexteNormal(ResMsgVoc.getString((String)"VOC_DATE") + ": " + node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("para")) {
                this.writePara(node, false);
                continue;
            }
            if (!node.getNodeName().equals("simpara")) continue;
            this.writePara(node, false);
        }
    }

    public void writeSection(Node root, int level) throws IOException {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("title")) {
                this.writeWithStyle("Titre" + level, node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("para")) {
                this.writePara(node, level >= 1 || level <= 3);
                continue;
            }
            if (node.getNodeName().equals("simpara")) {
                this.writePara(node, level >= 1 || level <= 3);
                continue;
            }
            if (node.getNodeName().equals("programlisting")) {
                this.parseProgramlisting(node);
                continue;
            }
            if (node.getNodeName().equals("section")) {
                this.writeSection(node, level + 1);
                continue;
            }
            if (node.getNodeName().equals("sect1")) {
                this.writeSection(node, 1);
                continue;
            }
            if (node.getNodeName().equals("sect2")) {
                this.writeSection(node, 2);
                continue;
            }
            if (node.getNodeName().equals("sect3")) {
                this.writeSection(node, 3);
                continue;
            }
            if (node.getNodeName().equals("sect4")) {
                this.writeSection(node, 4);
                continue;
            }
            if (node.getNodeName().equals("sect5")) {
                this.writeSection(node, 5);
                continue;
            }
            if (node.getNodeName().equals("itemizedlist")) {
                this.writeList(node);
                continue;
            }
            if (!node.getNodeName().equals("informaltable")) continue;
            this.parseInformaltable(node);
        }
    }

    public void writeList(Node root) throws IOException {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("listitem")) continue;
            this.writeListItem(node);
        }
    }

    public void writeListItem(Node root) throws IOException {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                String txt = node.getTextContent();
                if (txt.trim().isEmpty()) continue;
                this.writePuce1(txt, "");
                continue;
            }
            if (!node.getNodeName().equals("para") && !node.getNodeName().equals("simpara")) continue;
            this.writePara(node, true);
        }
    }

    public void writePara(Node root, boolean puce) throws IOException {
        boolean first = true;
        if (root.getChildNodes().getLength() == 1) {
            Node node = root.getChildNodes().item(0);
            if (node.getNodeName().equals("emphasis")) {
                this.parseEmphasis(node);
            } else if (puce) {
                String textIn = node.getNodeValue();
                if (!textIn.trim().isEmpty()) {
                    if (textIn.indexOf(":") != -1) {
                        String label = textIn.substring(0, textIn.indexOf(":") - 1);
                        String text = textIn.substring(textIn.indexOf(":") + 1, textIn.length());
                        if (!label.trim().isEmpty() || !text.trim().isEmpty()) {
                            if (text.isEmpty()) {
                                text = " ";
                            }
                            this.writePuce1(label, text);
                        }
                    } else {
                        this.writePuce1(textIn, "");
                    }
                }
            } else {
                this.writeTexteCorps(root.getTextContent(), "");
            }
        } else {
            for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
                String textIn;
                Node node = root.getChildNodes().item(i);
                if (node.getNodeName().equals("informaltable")) {
                    this.parseInformaltable(node);
                    continue;
                }
                if (node.getNodeName().equals("mediaobject")) {
                    this.parseMediaobject(node, false);
                    continue;
                }
                if (node.getNodeName().equals("sect1")) {
                    this.writeSection(node, 1);
                    continue;
                }
                if (node.getNodeName().equals("sect2")) {
                    this.writeSection(node, 2);
                    continue;
                }
                if (node.getNodeName().equals("sect3")) {
                    this.writeSection(node, 3);
                    continue;
                }
                if (node.getNodeName().equals("sect4")) {
                    this.writeSection(node, 4);
                    continue;
                }
                if (node.getNodeName().equals("sect5")) {
                    this.writeSection(node, 5);
                    continue;
                }
                if (node.getNodeName().equals("para") || node.getNodeName().equals("simpara")) {
                    this.writePara(node, false);
                    continue;
                }
                if (node.getNodeName().equals("programlisting")) {
                    Node brother = root.getChildNodes().item(i - 1);
                    if (first & !brother.getTextContent().equals("")) {
                        this.writePuce1(brother.getTextContent().substring(0, brother.getTextContent().indexOf(":") - 1), brother.getTextContent().substring(brother.getTextContent().indexOf(":") + 1, brother.getTextContent().length()));
                    }
                    first = false;
                    this.parseProgramlisting(node);
                    continue;
                }
                if (node.getNodeName().equals("emphasis")) {
                    this.parseEmphasis(node);
                    continue;
                }
                if (!puce || (textIn = node.getNodeValue()).trim().isEmpty()) continue;
                if (textIn.indexOf(":") != -1) {
                    String label = textIn.substring(0, textIn.indexOf(":") - 1);
                    String text = textIn.substring(textIn.indexOf(":") + 1, textIn.length());
                    if (label.trim().isEmpty() && text.trim().isEmpty()) continue;
                    if (text.isEmpty()) {
                        text = " ";
                    }
                    this.writePuce1(label, text);
                    continue;
                }
                this.writePuce1(textIn, "");
            }
        }
    }

    public void parseEmphasis(Node root) throws IOException {
        String att = "";
        NamedNodeMap attributs = root.getAttributes();
        if (attributs.getNamedItem("role") != null) {
            att = attributs.getNamedItem("role").getNodeValue();
        } else {
            ResWordXml.LOG.finest("WordWML - parseEmphasis : attribut 'role' is null => italic");
            att = "italic";
        }
        this.writeTexteCorps(root.getTextContent(), att);
    }

    public void parseProgramlisting(Node root) throws IOException {
        String alg = "left";
        String color = "F0F0F0";
        this.writeArrayBegin();
        try {
            this._outputFile.write("<w:tr>");
            this.drawCell(alg, color, root.getTextContent(), false, false, false, false, null);
            this._outputFile.write("</w:tr>\n");
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - parseProgramlisting", e);
        }
        this.writeArrayEnd();
    }

    public void parseInformaltable(Node root) throws IOException {
        int nbCol = 0;
        this.writeArrayBegin();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("tgroup")) continue;
            NamedNodeMap attributs = node.getAttributes();
            if (attributs.getNamedItem("cols") != null) {
                nbCol = Integer.parseInt(attributs.getNamedItem("cols").getNodeValue());
            }
            this.parseTgroup(node, nbCol);
        }
        this.writeArrayEnd();
    }

    public void parseTgroup(Node root, int nbCol) {
        Vector<ColSpec> columsSpec = new Vector<ColSpec>();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("colspec")) {
                ColSpec colSpec = new ColSpec();
                NamedNodeMap attributs = node.getAttributes();
                if (attributs.getNamedItem("colnum") != null) {
                    colSpec._colNum = Integer.parseInt(attributs.getNamedItem("colnum").getNodeValue());
                }
                if (attributs.getNamedItem("colwidth") != null) {
                    colSpec.parseWidth(attributs.getNamedItem("colwidth").getNodeValue());
                }
                if (attributs.getNamedItem("colname") != null) {
                    colSpec._colName = attributs.getNamedItem("colname").getNodeValue();
                }
                columsSpec.addElement(colSpec);
                continue;
            }
            if (node.getNodeName().equals("thead")) {
                this.parseThead(node, nbCol, columsSpec);
                continue;
            }
            if (!node.getNodeName().equals("tbody")) continue;
            this.parseTbody(node, nbCol);
        }
    }

    public void parseThead(Node root, int nbCol, Vector<ColSpec> columnsSpec) {
        int i;
        Vector<Border> borders = new Vector<Border>();
        if (ResWordXml.LOG.isLoggable(Level.FINEST)) {
            StringBuffer buffer = new StringBuffer();
            for (ColSpec c : columnsSpec) {
                buffer.append(c.toString() + "\n");
            }
            ResWordXml.LOG.finest(buffer.toString());
        }
        for (i = 0; i < nbCol; ++i) {
            borders.add(new Border());
        }
        for (i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("row")) continue;
            this.parseRow(node, nbCol, true, borders);
        }
    }

    public void parseRow(Node root, int nbCol, boolean bold, Vector<Border> borders) {
        Vector<Entry> entries = new Vector<Entry>();
        int nbEntry = 0;
        try {
            int i;
            this._outputFile.write("<w:tr>");
            for (i = 0; i < root.getChildNodes().getLength(); ++i) {
                Node node = root.getChildNodes().item(i);
                if (!node.getNodeName().equals("entry")) continue;
                entries.add(new Entry(node, nbCol, bold));
                Entry e = (Entry)entries.get(entries.size() - 1);
                if (e._morerows != 0) {
                    for (int bCt = nbEntry; bCt < borders.size(); ++bCt) {
                        Border b = borders.elementAt(bCt);
                        if (b._moreRows != 0) continue;
                        b._bottom = "nil";
                        b._top = "single";
                        b._moreRows = e._morerows + 1;
                        b._newEntry = true;
                        break;
                    }
                }
                ++nbEntry;
            }
            if (!entries.isEmpty()) {
                if (entries.size() != borders.size()) {
                    for (i = 0; i < borders.size(); ++i) {
                        if (borders.elementAt((int)i)._moreRows == 0) continue;
                        if (!borders.elementAt((int)i)._newEntry) {
                            Entry e = new Entry();
                            e._morerows = 1;
                            entries.add(i, e);
                            continue;
                        }
                        borders.elementAt((int)i)._newEntry = false;
                    }
                }
                for (i = 0; i < borders.size(); ++i) {
                    borders.elementAt((int)i)._newEntry = false;
                    if (borders.elementAt((int)i)._moreRows == 0) continue;
                    Border b = borders.elementAt(i);
                    b._top = "nil";
                    --b._moreRows;
                    if (b._moreRows != 0) continue;
                    b._bottom = "single";
                }
                for (i = 0; i < entries.size(); ++i) {
                    ((Entry)entries.elementAt((int)i))._border = borders.elementAt(i);
                    this.parseEntry((Entry)entries.elementAt(i));
                }
            }
            this._outputFile.write("</w:tr>\n");
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - writeRows", e);
        }
    }

    public void parseEntry(Entry e) throws IOException {
        if (e._node == null) {
            this.drawCell(e._alg, "", "", e._bold, false, false, false, e._border);
        } else if (e._node.getChildNodes().getLength() == 0) {
            this.drawCell(e._alg, "", "", e._bold, false, false, false, e._border);
        } else if (e._node.getChildNodes().getLength() == 1) {
            this.drawCell(e._alg, "", e._node.getTextContent(), e._bold, false, false, false, e._border);
        } else {
            for (int i = 0; i < e._node.getChildNodes().getLength(); ++i) {
                Node node = e._node.getChildNodes().item(i);
                if (node.getNodeName().equals("mediaobject")) {
                    this.parseMediaobject(node, true);
                    continue;
                }
                if (!node.getNodeName().equals("itemizedlist")) continue;
                try {
                    this._outputFile.write("<w:tc>");
                    this.writeList(node);
                    this._outputFile.write("</w:tc>");
                    continue;
                }
                catch (IOException ioe) {
                    ResWordXml.LOG.log(Level.WARNING, "WordWML - parseEntry", e);
                }
            }
        }
    }

    public void parseTbody(Node root, int nbCol) {
        int i;
        Vector<Border> borders = new Vector<Border>();
        for (i = 0; i < nbCol; ++i) {
            borders.add(new Border());
        }
        for (i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("row")) continue;
            this.parseRow(node, nbCol, false, borders);
        }
    }

    public void parseMediaobject(Node root, boolean inCell) {
        Node selectNode = null;
        String textObject = null;
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("imageobject")) {
                if (selectNode == null) {
                    selectNode = node;
                    continue;
                }
                String format = this.readFormatImagedata(node);
                if (!"EMF".equals(format)) continue;
                selectNode = node;
                continue;
            }
            if (!node.getNodeName().equals("textobject")) continue;
            textObject = this.readTextobject(node);
        }
        if (textObject != null && !inCell) {
            this.parseImagedata(selectNode, false);
        } else {
            this.parseImagedata(selectNode, inCell);
        }
    }

    private String readFormatImagedata(Node root) {
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            NamedNodeMap attributs;
            Node format;
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("imagedata") || (format = (attributs = node.getAttributes()).getNamedItem("format")) == null) continue;
            return format.getNodeValue();
        }
        return null;
    }

    private String readTextobject(Node root) {
        StringBuffer sb = new StringBuffer(1024);
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("para")) continue;
            sb.append(node.getTextContent());
        }
        return sb.toString();
    }

    public void parseImagedata(Node root, boolean inCell) {
        DrawImgXml img = new DrawImgXml();
        try {
            for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
                NamedNodeMap attributs;
                Node node = root.getChildNodes().item(i);
                if (!node.getNodeName().equals("imagedata") || (attributs = node.getAttributes()).getNamedItem("fileref") == null) continue;
                String imgName = attributs.getNamedItem("fileref").getNodeValue();
                imgName = imgName.replace("/", File.separator);
                imgName = imgName.replace("\\", File.separator);
                imgName = imgName.substring(imgName.lastIndexOf(File.separator) + 1, imgName.length());
                img.setUrl(imgName);
                img.setDirFile(this._filePathImage.getPath() + File.separator);
                if (!inCell) {
                    img._newSection = true;
                }
                if (attributs.getNamedItem("format") != null) {
                    img.setFormat(attributs.getNamedItem("format").getNodeValue());
                }
                boolean bDefineSize = false;
                try {
                    int depth;
                    String stringDepth;
                    Node nodeDepth;
                    int width;
                    String stringWidth;
                    Node nodeWidth = attributs.getNamedItem("width");
                    if (nodeWidth != null && (stringWidth = nodeWidth.getNodeValue()).length() != 0 && stringWidth.endsWith("px") && (width = Integer.parseInt(stringWidth.substring(0, stringWidth.length() - 2))) >= 0 && (nodeDepth = attributs.getNamedItem("depth")) != null && (stringDepth = nodeDepth.getNodeValue()).length() != 0 && stringDepth.endsWith("px") && (depth = Integer.parseInt(stringDepth.substring(0, stringDepth.length() - 2))) >= 0) {
                        img.setWidth(width);
                        img.setHeight(depth);
                        bDefineSize = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                if (!bDefineSize) {
                    try {
                        ImageIcon imgIcone = new ImageIcon(img.getDirFile() + img.getUrl());
                        img.setWidth(imgIcone.getIconWidth());
                        img.setHeight(imgIcone.getIconHeight());
                        bDefineSize = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!bDefineSize) continue;
                Node nodeScale = attributs.getNamedItem("scale");
                if (nodeScale != null) {
                    String stringScale = nodeScale.getNodeValue();
                    int scale = -1;
                    try {
                        scale = Integer.parseInt(stringScale);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (scale > 0) {
                        img.setWidth(img.getWidth() * scale / 100);
                        img.setHeight(img.getHeight() * scale / 100);
                    }
                }
                if (inCell) {
                    img.setAlg("center");
                    this.formatImage(img, 20, 40);
                    this._outputFile.write("<w:tc><w:tcPr><w:tcW w:w=\"9216\" w:type=\"dxa\"/></w:tcPr>");
                } else if (this._pageFormat.equals("A4")) {
                    if (this._pageOrientation == 1) {
                        this.formatImage(img, 500, 700);
                    } else if (this._pageOrientation == 0) {
                        this.formatImage(img, 700, 450);
                    }
                } else if (this._pageFormat.equals("A3")) {
                    if (this._pageOrientation == 1) {
                        this.formatImage(img, 700, 1000);
                    } else if (this._pageOrientation == 0) {
                        this.formatImage(img, 1000, 700);
                    }
                } else if (this._pageFormat.equals("B5")) {
                    if (this._pageOrientation == 1) {
                        this.formatImage(img, 430, 610);
                    } else if (this._pageOrientation == 0) {
                        this.formatImage(img, 610, 430);
                    }
                } else if (this._pageFormat.equals("B4")) {
                    if (this._pageOrientation == 1) {
                        this.formatImage(img, 610, 860);
                    } else if (this._pageOrientation == 0) {
                        this.formatImage(img, 860, 860);
                    }
                } else if (this._pageFormat.equals("LETTER")) {
                    if (this._pageOrientation == 1) {
                        this.formatImage(img, 510, 660);
                    } else if (this._pageOrientation == 0) {
                        this.formatImage(img, 660, 660);
                    }
                }
                this.drawPicture(img.getDirFile(), img, this._indPict++, inCell);
                if (!inCell) continue;
                this._outputFile.write("</w:tc>");
            }
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - parseImagedata", e);
        }
    }

    public void formatImage(DrawImgXml img, int maxWidth, int maxHeight) {
        int width = img.getWidth();
        int height = img.getHeight();
        double pwidth = 100.0;
        double pheight = 100.0;
        _LOG.finest("Beg: w=" + img.getWidth() + ", h=" + img.getHeight());
        _LOG.finest("Max: w=" + maxWidth + ", h=" + maxHeight);
        if (width > maxWidth) {
            pwidth = (double)((width - maxWidth) * 100) / (double)width;
        }
        if (height > maxHeight) {
            pheight = (double)((height - maxHeight) * 100) / (double)height;
        }
        if (pwidth != 100.0) {
            if (pheight != 100.0) {
                if (pwidth >= pheight) {
                    img.setWidth((int)((double)width - (double)width * pwidth / 100.0));
                    img.setHeight((int)((double)height - (double)height * pwidth / 100.0));
                } else {
                    img.setWidth((int)((double)width - (double)width * pheight / 100.0));
                    img.setHeight((int)((double)height - (double)height * pheight / 100.0));
                }
            } else {
                img.setWidth((int)((double)width - (double)width * pwidth / 100.0));
                img.setHeight((int)((double)height - (double)height * pwidth / 100.0));
            }
        } else if (pheight != 100.0) {
            img.setWidth((int)((double)width - (double)width * pheight / 100.0));
            img.setHeight((int)((double)height - (double)height * pheight / 100.0));
        }
        _LOG.finest("End: w=" + img.getWidth() + ", h=" + img.getHeight());
    }
}

