/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.wordxml;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.plugin.export.wordxml.DocbookThread;
import java.awt.print.PageFormat;
import java.io.File;

abstract class PluginAbstractWordXml
extends AbstractPluginModel
implements PluginMAction {
    PluginAbstractWordXml() {
    }

    protected boolean launchConvert(ExtendedPlugable launcher, File file, boolean startThread) {
        String typeOfPage;
        DocbookThread thread = new DocbookThread(launcher.getWindow(), file);
        PageFormat pFormat = launcher.getPageFormat("word.file");
        if (pFormat != null && !(typeOfPage = this.computeTypeOfPage(pFormat)).isEmpty()) {
            int pOrientation;
            thread._pageFormat = typeOfPage;
            thread._pageOrientation = pOrientation = pFormat.getOrientation();
            if (startThread) {
                thread.realiseDo();
            } else {
                thread.executeAction();
            }
            return true;
        }
        return false;
    }

    protected String computeTypeOfPage(PageFormat pf) {
        int w = (int)pf.getWidth();
        int h = (int)pf.getHeight();
        int tp = w;
        if (pf.getOrientation() == 0) {
            tp = h;
            h = w;
        }
        if (Math.abs(2380 - tp) < 10) {
            return "A0";
        }
        if (Math.abs(1684 - tp) < 2) {
            return "A1";
        }
        if (Math.abs(1190 - tp) < 2) {
            return "A2";
        }
        if (Math.abs(842 - tp) < 2) {
            return "A3";
        }
        if (Math.abs(728 - tp) < 2) {
            return "B4";
        }
        if (Math.abs(612 - tp) < 2 && Math.abs(792 - h) < 2) {
            return "LETTER";
        }
        if (Math.abs(595 - tp) < 2) {
            return "A4";
        }
        if (Math.abs(515 - tp) < 2) {
            return "B5";
        }
        return "";
    }
}

