/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.wordxml;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.export.wordxml.Parseur;
import com.dassault.cecilia.plugin.export.wordxml.PluginAbstractWordXml;
import com.dassault.cecilia.plugin.export.wordxml.ResWordXml;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PluginWordXml
extends PluginAbstractWordXml {
    public void createSession(Plugable launcher, Object parameters) {
        File file;
        IModel model;
        if (!(launcher instanceof ExtendedPlugable)) {
            Logger.getLogger(((Object)((Object)this)).getClass().getPackage().getName()).warning("Launcher plugable is not extended Launcher");
            return;
        }
        ExtendedPlugable elauncher = (ExtendedPlugable)launcher;
        boolean startThread = true;
        if (parameters != null && parameters instanceof Boolean) {
            startThread = (Boolean)parameters;
        }
        if ((model = launcher.getModel("word.file")) != null && !this.launchConvert(elauncher, file = model.getFile(), startThread)) {
            String imageDirName;
            File imageDir;
            String fileName = model.getFile().getPath();
            int position = fileName.lastIndexOf(".");
            if (position != -1 && (imageDir = new File(imageDirName = fileName.substring(0, position) + "_images")).exists()) {
                File[] listFile = imageDir.listFiles();
                if (listFile != null && listFile.length != 0) {
                    for (int i = 0; i < listFile.length; ++i) {
                        listFile[i].delete();
                    }
                }
                imageDir.delete();
            }
            file.delete();
        }
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResWordXml.getString("PLUG_WORD_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResWordXml.getString("PLUG_WORD_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "alt W";
        }
        return "Info";
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("FolderFiles-07.svg"));
        }
        return super.getIcon(key);
    }

    public static void main(String[] argv) {
        String fileName;
        String outputPath;
        File dataDir;
        String dataPath = System.getProperty("DataPath");
        if (dataPath == null) {
            System.err.println("Not 'DataPath' property");
            System.exit(1);
        }
        if (!(dataDir = new File(dataPath)).exists() || !dataDir.isDirectory()) {
            System.err.println("Bad 'DataPath' property : not valide directory");
            System.exit(1);
        }
        if ((outputPath = System.getProperty("OutputPath")) == null) {
            System.err.println("Not 'OutputPath' property");
            System.exit(1);
        }
        if ((fileName = System.getProperty("FileName")) == null) {
            System.err.println("Not 'FileName' property");
            System.exit(1);
        }
        File outputFile = new File(outputPath + File.separator + fileName);
        File inputFile = new File(outputFile.getPath() + ".tmp");
        try {
            FileUtility.copyFile((File)outputFile, (File)inputFile);
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - copyFile(" + outputFile + ", " + inputFile + ")", e);
        }
        Object imagePath = outputFile.getPath();
        int pos = ((String)imagePath).lastIndexOf(".xml");
        if (pos != -1) {
            imagePath = ((String)imagePath).substring(0, pos);
        }
        imagePath = (String)imagePath + "_images" + File.separator;
        new Parseur()._parseurDocbook.buildXml(dataDir, inputFile, outputFile, new File((String)imagePath));
    }
}

