/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class EditorDBasePath
extends DefaultTableCellRenderer
implements TableCellEditor {
    public static final String PROP_DB_WITH_FT = "cecilia.mbsa.viewer.DBEditorAcceptFaultTree";
    private static boolean DB_WITH_FT = Boolean.getBoolean("cecilia.mbsa.viewer.DBEditorAcceptFaultTree");
    TargetModel _tgt;
    JTable _lastTable;
    DlgDBData _dlg = null;
    private EventListenerList _listeners = new EventListenerList();
    private ChangeEvent _evt = new ChangeEvent(this);

    public EditorDBasePath(TargetModel tgt) {
        this._tgt = tgt;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String path;
        int pos;
        if (this._dlg == null) {
            Window win = SwingUtilities.getWindowAncestor(table);
            this._dlg = new DlgDBData(win);
        }
        if (value != null && value instanceof String && (pos = (path = (String)value).lastIndexOf("/")) != -1) {
            this._dlg._ctrlSelect.setSelectFolder(path.substring(0, pos));
            this._dlg._ctrlName.setText(path.substring(pos + 1));
        }
        this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)table));
        Point pt = this._dlg.getLocation();
        pt.x += 200;
        this._dlg.setLocation(pt);
        JOptionCecilia.ensureDialogIsIntoScreen((JDialog)((Object)this._dlg));
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public void cancelCellEditing() {
        if (this._dlg != null) {
            this._dlg.setVisible(false);
        }
    }

    @Override
    public boolean stopCellEditing() {
        if (this._dlg != null) {
            this._dlg.setVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._dlg != null) {
            return this._dlg.getTreeName();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= 2;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorDBasePath.this._dlg.setVisible(true);
                if (EditorDBasePath.this._dlg.getResult()) {
                    EditorDBasePath.this.fireEditionStopped();
                } else {
                    EditorDBasePath.this.fireEditionCanceled();
                }
            }
        });
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this._listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this._listeners.remove(CellEditorListener.class, l);
    }

    protected void fireEditionStopped() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingStopped(this._evt);
        }
    }

    protected void fireEditionCanceled() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingCanceled(this._evt);
        }
    }

    class DlgDBData
    extends JDialogCecilia {
        private JTextField _ctrlName;
        DBFolderPanelSelect _ctrlSelect;

        DlgDBData(Window owner) {
            super(owner);
            this._ctrlName = new JTextField(20);
            this.make(owner);
        }

        private void make(Window owner) {
            this._ctrlSelect = new DBFolderPanelSelect(EditorDBasePath.this._tgt.getPlugable().getAppl(), DBFolder.Family.PROJECT){

                public boolean selectFolder(DBFolder dbFolder) {
                    if (dbFolder.isVersion()) {
                        return false;
                    }
                    if (dbFolder.isModel()) {
                        switch (dbFolder.getFamilyFlag()) {
                            case 5: {
                                return true;
                            }
                            case 2: {
                                return DB_WITH_FT;
                            }
                        }
                        return false;
                    }
                    return true;
                }
            };
            this._ctrlSelect.getCtrlTree().setVisibleRowCount(12);
            this._ctrlSelect.getCtrlTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DBFolder dbFolder = DlgDBData.this.getSelectFolder();
                    if (dbFolder == null) {
                        return;
                    }
                    if (dbFolder.isModel()) {
                        DlgDBData.this._ctrlName.setText(dbFolder.getName());
                    }
                }
            });
            this._ctrlSelect.getCtrlTree().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    DBFolder dbFolder = DlgDBData.this.getSelectFolder();
                    if (dbFolder == null) {
                        return;
                    }
                    if (!dbFolder.isModel()) {
                        return;
                    }
                    DlgDBData.this.validDialog();
                }
            });
            JPanel center = new JPanel(new GridBagLayout());
            center.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_PATH")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            center.add((Component)this._ctrlSelect, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
            center.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_NAME")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            center.add((Component)this._ctrlName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.setTitle(ResViewer.getString("EDIT_TGT_SEL_DB_TITLE"));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)center, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
            this.setModal(true);
        }

        DBFolder getSelectFolder() {
            TreePath path = this._ctrlSelect.getCtrlTree().getSelectionPath();
            if (path == null) {
                return null;
            }
            DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
            if (selectNode == null) {
                return null;
            }
            DBFolder dbFolder = selectNode.getDBFolder();
            if (dbFolder == null) {
                return null;
            }
            return dbFolder;
        }

        protected boolean verifyParameters() {
            DBFolder dbFolder = this.getSelectFolder();
            if (dbFolder == null || dbFolder.getDepthUntilSystem() < 2) {
                this._ctrlSelect.requestFocus();
                return false;
            }
            String name = this._ctrlName.getText().trim();
            if (name.isEmpty()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResMsgCore.getString((String)"MSG_ERR_TEXT_EMPTY"), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
                this._ctrlName.requestFocus();
                return false;
            }
            if (name.length() < 3) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResViewer.getString("DLG_TGT_SEL_DB_ERR_NAME"), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
                this._ctrlName.requestFocus();
                return false;
            }
            if (DBFactory.verifyName((String)name) != 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResMsgObj.getString((String)"MSG_ERR_VERIFY_NAME"), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
                this._ctrlName.requestFocus();
                return false;
            }
            if (dbFolder.isModel()) {
                dbFolder = dbFolder.getParent();
            }
            if ((dbFolder = dbFolder.findChild(name)) == null) {
                return true;
            }
            switch (dbFolder.getFamilyFlag()) {
                case 5: {
                    return true;
                }
                case 2: {
                    if (!DB_WITH_FT) break;
                    return true;
                }
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResMsgObj.msgFormat((String)"MSG_FOL_ALREADY_CHILD", (Object[])new Object[]{dbFolder.getRefPath()}), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
            this._ctrlName.requestFocus();
            return false;
        }

        protected String getTreeName() {
            DBFolder dbFolder = this.getSelectFolder();
            if (dbFolder == null) {
                return "";
            }
            StringBuilder buffer = new StringBuilder(128);
            if (dbFolder.isModel()) {
                dbFolder.getParent().getPathUntilSystem(buffer);
            } else {
                dbFolder.getPathUntilSystem(buffer);
            }
            buffer.append("/").append(this._ctrlName.getText());
            return buffer.toString();
        }
    }
}

